<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CompanyInfo;
use App\Models\BlogPost;
use App\Models\Product;

class PrincipalController extends Controller
{
    public function index()
    {
        // Obtener información de la empresa desde la base de datos
        $generalInfo = CompanyInfo::getMainInfo();
        $salesInfo = CompanyInfo::getMainInfo();
        $serviceInfo = CompanyInfo::getServiceInfo();

        // Obtener posts destacados del blog
        $blogPosts = BlogPost::All();
        
        // Obtener los últimos 6 productos registrados
        $latestProducts = Product::with('category')
                                ->orderBy('created_at', 'desc')
                                ->limit(6)
                                ->get();

        return view('index', compact('generalInfo', 'salesInfo', 'serviceInfo', 'blogPosts', 'latestProducts'));
    }
}
