<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Verificar si el usuario está autenticado
        if (!Auth::check()) {
            return redirect()->route('admin.login')
                ->withErrors(['access' => 'Debes iniciar sesión para acceder al panel de administración.']);
        }

        // Verificar si el usuario es administrador
        if (Auth::user()->rol !== 'administrador') {
            return redirect()->route('admin.login')
                ->withErrors(['access' => 'No tienes permisos de administrador.']);
        }

        return $next($request);
    }
}
