<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    use HasFactory;

    protected $table = 'cart';

    protected $fillable = [
        'user_id',
        'product_id',
        'quantity'
    ];

    // Relación con usuario
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Relación con producto
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    // Obtener subtotal del item
    public function getSubtotalAttribute()
    {
        return $this->quantity * $this->product->price;
    }

    // Scope para obtener carrito por usuario
    public function scopeByUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }
}
