<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected $table = 'categories';

    protected $fillable = [
        'name',
        'description'
    ];

    // Relación con productos
    public function products()
    {
        return $this->hasMany(Product::class);
    }

    // Scope para obtener categorías con conteo de productos
    public function scopeWithProductCount($query)
    {
        return $query->withCount('products');
    }
}
