<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyInfo extends Model
{
    use HasFactory;

    protected $table = 'company_info';

    protected $fillable = [
        'type',
        'name',
        'phone',
        'email',
        'address',
        'hours',
        'description',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Scopes para diferentes tipos
    public function scopeGeneral($query)
    {
        return $query->where('type', 'general');
    }

    public function scopeVentas($query)
    {
        return $query->where('type', 'ventas');
    }

    public function scopeServicio($query)
    {
        return $query->where('type', 'servicio');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Obtener información principal de la empresa
    public static function getMainInfo()
    {
        return self::general()->active()->first();
    }

    // Obtener información de ventas
    public static function getSalesInfo()
    {
        return self::ventas()->active()->first();
    }

    // Obtener información de servicio técnico
    public static function getServiceInfo()
    {
        return self::servicio()->active()->first();
    }

    // Formatear horarios para mostrar
    public function getFormattedHoursAttribute()
    {
        return str_replace('\n', '<br>', $this->hours);
    }
}
