<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContactMessage extends Model
{
    use HasFactory;

    protected $table = 'contact_messages';

    protected $fillable = [
        'name',
        'email',
        'phone',
        'subject',
        'message',
        'status'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Scopes para filtrar por estado
    public function scopeNuevos($query)
    {
        return $query->where('status', 'nuevo');
    }

    public function scopeLeidos($query)
    {
        return $query->where('status', 'leido');
    }

    public function scopeRespondidos($query)
    {
        return $query->where('status', 'respondido');
    }

    // Marcar como leído
    public function markAsRead()
    {
        $this->update(['status' => 'leido']);
    }

    // Marcar como respondido
    public function markAsAnswered()
    {
        $this->update(['status' => 'respondido']);
    }

    // Obtener nombre del subject en español
    public function getSubjectNameAttribute()
    {
        $subjects = [
            'ventas' => 'Consulta de ventas',
            'servicio' => 'Servicio técnico',
            'garantia' => 'Garantía',
            'otros' => 'Otros'
        ];

        return $subjects[$this->subject] ?? $this->subject;
    }

    // Obtener clase CSS para el estado
    public function getStatusClassAttribute()
    {
        $classes = [
            'nuevo' => 'badge-primary',
            'leido' => 'badge-info',
            'respondido' => 'badge-success',
            'cerrado' => 'badge-secondary'
        ];

        return $classes[$this->status] ?? 'badge-light';
    }
}
