<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;
    
    protected $table = 'payments';
    
    protected $fillable = [
        'order_id',
        'payment_method',
        'card_number',
        'card_holder',
        'card_type',
        'card_last_four',
        'transaction_id',
        'payment_status',
        'amount'
    ];
    
    // Relación con la orden
    public function order()
    {
        return $this->belongsTo(Order::class);
    }
    
    // Encriptar número de tarjeta
    public function setCardNumberAttribute($value)
    {
        if ($value) {
            $cleaned = preg_replace('/\D/', '', $value);
            $this->attributes['card_last_four'] = substr($cleaned, -4);
            $this->attributes['card_number'] = '**** **** **** ' . substr($cleaned, -4);
        }
    }
    
    // Generar ID de transacción
    public static function generateTransactionId()
    {
        return 'TXN' . time() . mt_rand(1000, 9999);
    }
}
