<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $table = 'products';

    protected $fillable = [
        'name',
        'description',
        'price',
        'image',
        'category_id',
        'marca',
        
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relación con categoría
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    // Relación con items de pedidos
    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }

    // Scope para búsqueda por categoría
    public function scopeByCategory($query, $categoryId)
    {
        return $query->where('category_id', $categoryId);
    }

    // Obtener precio formateado
    public function getFormattedPriceAttribute()
    {
        return 'S/ ' . number_format($this->price, 0, '.', ',');
    }
}
