-- Script para crear solo las nuevas tablas de pagos
-- Ejecutar este SQL en tu base de datos

-- Tabla de información de pago
CREATE TABLE IF NOT EXISTS payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id INT NOT NULL,
    payment_method VARCHAR(50) NOT NULL,
    card_number VARCHAR(20) NULL,
    card_holder VARCHAR(255) NULL,
    card_type VARCHAR(20) NULL,
    card_last_four VARCHAR(4) NULL,
    transaction_id VARCHAR(100) NULL,
    payment_status ENUM('pending', 'completed', 'failed', 'refunded') DEFAULT 'pending',
    amount DECIMAL(10,2) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE
);
