-- Tabla para mensajes de contacto
CREATE TABLE contact_messages (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) NOT NULL,
    phone VARCHAR(20),
    subject ENUM('ventas', 'servicio', 'garantia', 'otros') NOT NULL,
    message TEXT NOT NULL,
    status ENUM('nuevo', 'leido', 'respondido', 'cerrado') DEFAULT 'nuevo',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabla para información de la empresa
CREATE TABLE company_info (
    id INT AUTO_INCREMENT PRIMARY KEY,
    type ENUM('general', 'ventas', 'servicio') NOT NULL,
    name VARCHAR(255) NOT NULL,
    phone VARCHAR(20),
    email VARCHAR(255),
    address TEXT,
    hours TEXT,
    description TEXT,
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabla para cotizaciones
CREATE TABLE quotes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    email VARCHAR(255) NOT NULL,
    phone VARCHAR(20) NOT NULL,
    product_name VARCHAR(255),
    product_category VARCHAR(100),
    quantity INT DEFAULT 1,
    budget_range VARCHAR(100),
    message TEXT,
    status ENUM('pendiente', 'procesando', 'enviado', 'cerrado') DEFAULT 'pendiente',
    priority ENUM('baja', 'media', 'alta') DEFAULT 'media',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabla para artículos del blog
CREATE TABLE blog_posts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    slug VARCHAR(255) UNIQUE NOT NULL,
    excerpt TEXT,
    content LONGTEXT,
    image_url VARCHAR(500),
    category VARCHAR(100) NOT NULL,
    author VARCHAR(255) DEFAULT 'ElectroMart',
    status ENUM('borrador', 'publicado', 'archivado') DEFAULT 'borrador',
    featured BOOLEAN DEFAULT FALSE,
    meta_title VARCHAR(255),
    meta_description TEXT,
    views_count INT DEFAULT 0,
    published_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Insertar datos iniciales para la empresa
INSERT INTO company_info (type, name, phone, email, address, hours, description) VALUES
('general', 'ElectroMart', '(01) 234-5678', 'info@electromart.pe', 'Av. Principal 123, Lima', 'Lun - Sáb: 9:00 AM - 8:00 PM\nDom: 10:00 AM - 6:00 PM', 'Tienda principal de ElectroMart'),
('ventas', 'Ventas ElectroMart', '(01) 234-5678', 'ventas@electromart.pe', 'Av. Principal 123, Lima', 'Lun - Sáb: 9:00 AM - 8:00 PM\nDom: 10:00 AM - 6:00 PM', 'Departamento de ventas'),
('servicio', 'Servicio Técnico Lima', '(01) 234-5679', 'servicio@electromart.pe', 'Av. Principal 123, Lima', 'Lun - Dom: 24 horas', 'Servicio técnico especializado');

-- Insertar artículos de blog de ejemplo
INSERT INTO blog_posts (title, slug, excerpt, content, image_url, category, author, status, featured, published_at) VALUES
('Cómo elegir la refrigeradora perfecta para tu hogar', 'como-elegir-refrigeradora-perfecta', 
'Descubre los factores clave que debes considerar al momento de comprar una nueva refrigeradora: capacidad, eficiencia energética y funciones especiales.',
'<h2>Factores importantes al elegir una refrigeradora</h2>
<p>Elegir la refrigeradora adecuada para tu hogar es una decisión importante que afectará tu vida diaria durante muchos años. En esta guía te ayudaremos a considerar todos los aspectos relevantes.</p>

<h3>1. Capacidad y tamaño</h3>
<p>La capacidad de la refrigeradora debe ajustarse al tamaño de tu familia y tus hábitos de compra. Como regla general:</p>
<ul>
<li>Para 1-2 personas: 200-300 litros</li>
<li>Para 3-4 personas: 300-450 litros</li>
<li>Para 5+ personas: 450+ litros</li>
</ul>

<h3>2. Eficiencia energética</h3>
<p>Una refrigeradora eficiente puede ahorrarte cientos de soles al año. Busca modelos con etiqueta energética A+ o superior.</p>

<h3>3. Funciones especiales</h3>
<p>Considera funciones como:</p>
<ul>
<li>No Frost (sin escarcha)</li>
<li>Dispensador de agua</li>
<li>Control de temperatura independiente</li>
<li>Tecnología inverter</li>
</ul>',
'https://images.pexels.com/photos/2343468/pexels-photo-2343468.jpeg?auto=compress&cs=tinysrgb&w=400',
'Tips', 'ElectroMart', 'publicado', true, '2024-08-15 10:00:00'),

('Mantenimiento básico de tu lavadora', 'mantenimiento-basico-lavadora',
'Aprende cómo mantener tu lavadora en perfecto estado con estos consejos simples que prolongarán su vida útil y mejorarán su rendimiento.',
'<h2>Guía completa de mantenimiento para lavadoras</h2>
<p>Un mantenimiento adecuado de tu lavadora no solo prolonga su vida útil, sino que también garantiza un mejor rendimiento y ahorro de energía.</p>

<h3>Limpieza mensual</h3>
<p>Realiza una limpieza profunda mensual:</p>
<ol>
<li>Ejecuta un ciclo de lavado en vacío con agua caliente</li>
<li>Añade 2 tazas de vinagre blanco al tambor</li>
<li>Agrega 1/4 taza de bicarbonato de sodio al dispensador de detergente</li>
<li>Ejecuta el ciclo completo</li>
</ol>

<h3>Cuidados diarios</h3>
<ul>
<li>Deja la puerta abierta después de cada uso</li>
<li>Limpia el dispensador de detergente regularmente</li>
<li>Revisa y limpia el filtro cada 3 meses</li>
<li>No sobrecargues la máquina</li>
</ul>

<h3>Señales de problemas</h3>
<p>Contacta a un técnico si notas:</p>
<ul>
<li>Ruidos extraños durante el funcionamiento</li>
<li>Vibración excesiva</li>
<li>Ropa que no queda completamente limpia</li>
<li>Fugas de agua</li>
</ul>',
'https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=400',
'Mantenimiento', 'ElectroMart', 'publicado', true, '2024-08-10 15:30:00'),

('Electrodomésticos que ahorran energía en la cocina', 'electrodomesticos-ahorro-energia-cocina',
'Conoce cuáles son los electrodomésticos más eficientes para tu cocina y cómo pueden ayudarte a reducir el consumo de energía en casa.',
'<h2>Ahorra energía en tu cocina con los electrodomésticos correctos</h2>
<p>La cocina es uno de los espacios que más energía consume en el hogar. Con los electrodomésticos adecuados, puedes reducir significativamente tu factura eléctrica.</p>

<h3>Refrigeradora eficiente</h3>
<p>Una refrigeradora nueva con tecnología inverter puede consumir hasta 40% menos energía que un modelo antiguo.</p>
<ul>
<li>Busca etiqueta A++ o superior</li>
<li>Considera el tamaño apropiado para tu familia</li>
<li>Mantén la temperatura entre 3-5°C</li>
</ul>

<h3>Cocina a inducción</h3>
<p>Las cocinas de inducción son las más eficientes:</p>
<ul>
<li>90% de eficiencia energética</li>
<li>Calentamiento rápido y preciso</li>
<li>Mayor seguridad</li>
<li>Fácil limpieza</li>
</ul>

<h3>Microondas moderno</h3>
<p>Un microondas eficiente puede ahorrar hasta 80% de energía comparado con el horno convencional para calentar alimentos.</p>

<h3>Consejos adicionales</h3>
<ul>
<li>Descongela alimentos naturalmente</li>
<li>Usa ollas de presión para cocinar más rápido</li>
<li>Mantén los electrodomésticos limpios</li>
<li>Aprovecha el calor residual del horno</li>
</ul>',
'https://images.pexels.com/photos/2062431/pexels-photo-2062431.jpeg?auto=compress&cs=tinysrgb&w=400',
'Consejos', 'ElectroMart', 'publicado', false, '2024-08-05 12:00:00');
