@extends('include.template')

@section('content')
<div class="admin-container" style="margin-top: 120px; max-width: 1200px; margin-left: auto; margin-right: auto; padding: 2rem;">
    <div class="admin-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 2rem; border-radius: 15px; margin-bottom: 2rem;">
        <h1 style="margin: 0; font-size: 2rem;">Administración de Información de la Empresa</h1>
        <p style="margin: 0.5rem 0 0 0; opacity: 0.9;">Gestiona la información de contacto que aparece en tu sitio web</p>
    </div>

    <form id="companyInfoForm" style="background: white; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1);">
        @csrf
        
        <!-- Información General -->
        <div class="section" style="margin-bottom: 3rem; padding-bottom: 2rem; border-bottom: 2px solid #f0f0f0;">
            <h2 style="color: #333; margin-bottom: 1.5rem; display: flex; align-items: center; gap: 0.75rem;">
                <i class="fas fa-building"></i>
                Información General
            </h2>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Nombre de la Empresa</label>
                    <input type="text" name="general_name" value="{{ $generalInfo->name ?? 'ElectroMart' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Teléfono Principal</label>
                    <input type="text" name="general_phone" value="{{ $generalInfo->phone ?? '(01) 234-5678' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
            </div>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-bottom: 1.5rem;">
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Email Principal</label>
                    <input type="email" name="general_email" value="{{ $generalInfo->email ?? 'info@electromart.pe' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Dirección</label>
                    <input type="text" name="general_address" value="{{ $generalInfo->address ?? 'Av. Principal 123, Lima' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
            </div>
            
            <div>
                <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Horarios de Atención</label>
                <textarea name="general_hours" rows="3" 
                          style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>{{ $generalInfo->hours ?? "Lun - Sáb: 9:00 AM - 8:00 PM\nDom: 10:00 AM - 6:00 PM" }}</textarea>
                <small style="color: #666; font-size: 0.9rem;">Usa saltos de línea para separar diferentes horarios</small>
            </div>
        </div>

        <!-- Información de Ventas -->
        <div class="section" style="margin-bottom: 3rem; padding-bottom: 2rem; border-bottom: 2px solid #f0f0f0;">
            <h2 style="color: #333; margin-bottom: 1.5rem; display: flex; align-items: center; gap: 0.75rem;">
                <i class="fas fa-shopping-cart"></i>
                Departamento de Ventas
            </h2>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 1.5rem;">
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Nombre del Departamento</label>
                    <input type="text" name="sales_name" value="{{ $salesInfo->name ?? 'Ventas ElectroMart' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Teléfono de Ventas</label>
                    <input type="text" name="sales_phone" value="{{ $salesInfo->phone ?? '(01) 234-5678' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Email de Ventas</label>
                    <input type="email" name="sales_email" value="{{ $salesInfo->email ?? 'ventas@electromart.pe' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
            </div>
        </div>

        <!-- Información de Servicio Técnico -->
        <div class="section" style="margin-bottom: 3rem;">
            <h2 style="color: #333; margin-bottom: 1.5rem; display: flex; align-items: center; gap: 0.75rem;">
                <i class="fas fa-tools"></i>
                Servicio Técnico
            </h2>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr 1fr; gap: 1.5rem;">
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Nombre del Servicio</label>
                    <input type="text" name="service_name" value="{{ $serviceInfo->name ?? 'Servicio Técnico Lima' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Teléfono de Servicio</label>
                    <input type="text" name="service_phone" value="{{ $serviceInfo->phone ?? '(01) 234-5679' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div>
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600; color: #333;">Email de Servicio</label>
                    <input type="email" name="service_email" value="{{ $serviceInfo->email ?? 'servicio@electromart.pe' }}" 
                           style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
            </div>
        </div>

        <!-- Botones de Acción -->
        <div style="display: flex; gap: 1rem; justify-content: center;">
            <button type="submit" style="padding: 15px 30px; background: linear-gradient(135deg, #667eea, #764ba2); color: white; border: none; border-radius: 10px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 0.5rem;">
                <i class="fas fa-save"></i>
                Guardar Cambios
            </button>
            <a href="{{ route('index') }}" style="padding: 15px 30px; background: #6c757d; color: white; border: none; border-radius: 10px; font-weight: 600; text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                <i class="fas fa-arrow-left"></i>
                Volver al Sitio
            </a>
        </div>
    </form>
</div>

<script>
document.getElementById('companyInfoForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const form = this;
    const formData = new FormData(form);
    const submitBtn = form.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    
    // Deshabilitar botón y mostrar loading
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Guardando...';
    
    // Convertir FormData a objeto
    const data = Object.fromEntries(formData);
    
    fetch("{{ route('admin.company.info.update') }}", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: '¡Información Actualizada!',
                text: data.message,
                icon: 'success',
                confirmButtonText: 'Perfecto'
            });
        } else {
            Swal.fire({
                title: 'Error',
                text: data.message,
                icon: 'error',
                confirmButtonText: 'Entendido'
            });
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error',
            text: 'Error de conexión. Inténtalo nuevamente.',
            icon: 'error',
            confirmButtonText: 'Reintentar'
        });
    })
    .finally(() => {
        // Restaurar botón
        submitBtn.disabled = false;
        submitBtn.innerHTML = originalText;
    });
});
</script>
@endsection
