@extends('administrador.include.template')

@section('title', 'Reportes y Estadísticas')

@section('breadcrumb')
    <span class="breadcrumb-item">Sistema</span>
    <span class="breadcrumb-item active">Reportes</span>
@endsection

@push('styles')
<style>
    .reports-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
    }
    
    .reports-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .report-cards {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
        gap: 2rem;
        margin-bottom: 2rem;
    }
    
    .report-card {
        background: white;
        border-radius: 12px;
        padding: 2rem;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        border-left: 4px solid var(--primary-color);
    }
    
    .report-card h3 {
        font-size: 1.25rem;
        font-weight: 600;
        color: var(--gray-900);
        margin-bottom: 1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .report-card p {
        color: var(--gray-600);
        margin-bottom: 1.5rem;
        line-height: 1.5;
    }
    
    .filters-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-bottom: 1.5rem;
    }
    
    .filter-group {
        display: flex;
        flex-direction: column;
    }
    
    .filter-group label {
        font-size: 0.875rem;
        font-weight: 600;
        color: var(--gray-700);
        margin-bottom: 0.5rem;
    }
    
    .filter-input {
        padding: 0.75rem;
        border: 2px solid var(--gray-200);
        border-radius: 8px;
        font-size: 0.875rem;
        transition: border-color 0.3s ease;
    }
    
    .filter-input:focus {
        outline: none;
        border-color: var(--primary-color);
    }
    
    .action-buttons {
        display: flex;
        gap: 1rem;
        flex-wrap: wrap;
    }
    
    .btn {
        padding: 0.75rem 1.5rem;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.875rem;
        transition: all 0.3s ease;
    }
    
    .btn-primary {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
    }
    
    .btn-success {
        background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
        color: white;
    }
    
    .btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
    }
    
    .results-table {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        margin-top: 2rem;
        display: none;
    }
    
    .table-responsive {
        overflow-x: auto;
        max-height: 500px;
        overflow-y: auto;
    }
    
    .table {
        width: 100%;
        margin-bottom: 0;
        color: var(--gray-700);
    }
    
    .table thead th {
        background: var(--gray-50);
        border-bottom: 1px solid var(--gray-200);
        padding: 1rem;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        color: var(--gray-600);
        position: sticky;
        top: 0;
        z-index: 10;
    }
    
    .table tbody td {
        padding: 0.75rem 1rem;
        border-bottom: 1px solid var(--gray-100);
        vertical-align: middle;
        font-size: 0.875rem;
    }
    
    .table tbody tr:hover {
        background: var(--gray-50);
    }
    
    .loading-spinner {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100px;
    }
    
    .spinner {
        width: 30px;
        height: 30px;
        border: 3px solid var(--gray-200);
        border-top: 3px solid var(--primary-color);
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }
    
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .stats-summary {
        background: var(--gray-50);
        padding: 1rem;
        border-radius: 8px;
        margin-bottom: 1rem;
        display: none;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 1rem;
        text-align: center;
    }
    
    .stat-item {
        background: white;
        padding: 1rem;
        border-radius: 6px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }
    
    .stat-number {
        font-size: 1.5rem;
        font-weight: 700;
        color: var(--primary-color);
    }
    
    .stat-label {
        font-size: 0.75rem;
        color: var(--gray-600);
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
</style>
@endpush

@section('content')
<div class="reports-container">
    <div class="reports-header">
        <h1 class="reports-title">
            <i class="fas fa-chart-bar"></i>
            Reportes y Estadísticas
        </h1>
    </div>
    
    <div class="report-cards">
        <!-- Reporte de Pedidos -->
        <div class="report-card">
            <h3>
                <i class="fas fa-shopping-cart" style="color: #667eea;"></i>
                Reporte de Pedidos
            </h3>
            <p>Genera reportes detallados de todos los pedidos con filtros por fecha y estado.</p>
            
            <div class="filters-row">
                <div class="filter-group">
                    <label>Fecha Inicio:</label>
                    <input type="date" class="filter-input" id="ordersDateFrom">
                </div>
                <div class="filter-group">
                    <label>Fecha Fin:</label>
                    <input type="date" class="filter-input" id="ordersDateTo">
                </div>
                <div class="filter-group">
                    <label>Estado:</label>
                    <select class="filter-input" id="ordersStatus">
                        <option value="">Todos</option>
                        <option value="pending">Pendiente</option>
                        <option value="confirmed">Confirmado</option>
                        <option value="processing">En Preparación</option>
                        <option value="shipped">Enviado</option>
                        <option value="delivered">Entregado</option>
                        <option value="cancelled">Cancelado</option>
                    </select>
                </div>
            </div>
            
            <div class="action-buttons">
                <button class="btn btn-primary" onclick="generateOrdersReport('view')">
                    <i class="fas fa-eye"></i>
                    Ver Reporte
                </button>
                <button class="btn btn-success" onclick="generateOrdersReport('excel')">
                    <i class="fas fa-download"></i>
                    Descargar Excel
                </button>
            </div>
        </div>
        
        <!-- Reporte de Mensajes -->
        <div class="report-card">
            <h3>
                <i class="fas fa-envelope" style="color: #4299e1;"></i>
                Reporte de Mensajes
            </h3>
            <p>Analiza los mensajes de contacto recibidos con filtros por estado y fecha.</p>
            
            <div class="filters-row">
                <div class="filter-group">
                    <label>Fecha Inicio:</label>
                    <input type="date" class="filter-input" id="messagesDateFrom">
                </div>
                <div class="filter-group">
                    <label>Fecha Fin:</label>
                    <input type="date" class="filter-input" id="messagesDateTo">
                </div>
                <div class="filter-group">
                    <label>Estado:</label>
                    <select class="filter-input" id="messagesStatus">
                        <option value="">Todos</option>
                        <option value="nuevo">Nuevo</option>
                        <option value="leido">Leído</option>
                        <option value="respondido">Respondido</option>
                    </select>
                </div>
            </div>
            
            <div class="action-buttons">
                <button class="btn btn-primary" onclick="generateMessagesReport('view')">
                    <i class="fas fa-eye"></i>
                    Ver Reporte
                </button>
                <button class="btn btn-success" onclick="generateMessagesReport('excel')">
                    <i class="fas fa-download"></i>
                    Descargar Excel
                </button>
            </div>
        </div>
        
        <!-- Reporte de Productos -->
        <div class="report-card">
            <h3>
                <i class="fas fa-box" style="color: #48bb78;"></i>
                Reporte de Productos
            </h3>
            <p>Lista completa de productos registrados con información de categorías y precios.</p>
            
            <div class="filters-row">
                <div class="filter-group">
                    <label>Categoría:</label>
                    <select class="filter-input" id="productsCategory">
                        <option value="">Todas las categorías</option>
                        <!-- Se cargarán dinámicamente -->
                    </select>
                </div>
            </div>
            
            <div class="action-buttons">
                <button class="btn btn-primary" onclick="generateProductsReport('view')">
                    <i class="fas fa-eye"></i>
                    Ver Reporte
                </button>
                <button class="btn btn-success" onclick="generateProductsReport('excel')">
                    <i class="fas fa-download"></i>
                    Descargar Excel
                </button>
            </div>
        </div>
        
       
    </div>
    
    <!-- Tabla de Resultados -->
    <div class="results-table" id="resultsTable">
        <div class="stats-summary" id="statsSummary"></div>
        <div class="table-responsive">
            <table class="table">
                <thead id="tableHeader"></thead>
                <tbody id="tableBody"></tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Cargar categorías al cargar la página
document.addEventListener('DOMContentLoaded', function() {
    loadCategories();
    setDefaultDates();
});

// Establecer fechas por defecto (último mes)
function setDefaultDates() {
    const today = new Date();
    const lastMonth = new Date(today.getFullYear(), today.getMonth() - 1, today.getDate());
    
    const todayStr = today.toISOString().split('T')[0];
    const lastMonthStr = lastMonth.toISOString().split('T')[0];
    
    // Establecer fechas por defecto para todos los reportes
    document.getElementById('ordersDateFrom').value = lastMonthStr;
    document.getElementById('ordersDateTo').value = todayStr;
    document.getElementById('messagesDateFrom').value = lastMonthStr;
    document.getElementById('messagesDateTo').value = todayStr;
    document.getElementById('usersDateFrom').value = lastMonthStr;
    document.getElementById('usersDateTo').value = todayStr;
}

// Cargar categorías para el filtro
async function loadCategories() {
    try {
        const response = await fetch('{{ route("admin.categories.data") }}');
        const result = await response.json();
        
        if (result.success) {
            const select = document.getElementById('productsCategory');
            result.data.forEach(category => {
                const option = document.createElement('option');
                option.value = category.id;
                option.textContent = category.name;
                select.appendChild(option);
            });
        }
    } catch (error) {
        console.error('Error al cargar categorías:', error);
    }
}

// Generar reporte de pedidos
async function generateOrdersReport(formato) {
    const dateFrom = document.getElementById('ordersDateFrom').value;
    const dateTo = document.getElementById('ordersDateTo').value;
    const status = document.getElementById('ordersStatus').value;
    
    const params = new URLSearchParams();
    if (dateFrom) params.append('fecha_inicio', dateFrom);
    if (dateTo) params.append('fecha_fin', dateTo);
    if (status) params.append('estado', status);
    if (formato === 'excel') params.append('formato', 'excel');
    
    const url = '{{ route("admin.reports.orders") }}?' + params.toString();
    
    if (formato === 'excel') {
        window.open(url, '_blank');
        return;
    }
    
    showLoading();
    try {
        const response = await fetch(url);
        const result = await response.json();
        
        if (result.success) {
            displayOrdersTable(result.data);
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo generar el reporte: ' + error.message,
            icon: 'error'
        });
    }
}

// Generar reporte de mensajes
async function generateMessagesReport(formato) {
    const dateFrom = document.getElementById('messagesDateFrom').value;
    const dateTo = document.getElementById('messagesDateTo').value;
    const status = document.getElementById('messagesStatus').value;
    
    const params = new URLSearchParams();
    if (dateFrom) params.append('fecha_inicio', dateFrom);
    if (dateTo) params.append('fecha_fin', dateTo);
    if (status) params.append('estado', status);
    if (formato === 'excel') params.append('formato', 'excel');
    
    const url = '{{ route("admin.reports.messages") }}?' + params.toString();
    
    if (formato === 'excel') {
        window.open(url, '_blank');
        return;
    }
    
    showLoading();
    try {
        const response = await fetch(url);
        const result = await response.json();
        
        if (result.success) {
            displayMessagesTable(result.data);
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo generar el reporte: ' + error.message,
            icon: 'error'
        });
    }
}

// Generar reporte de productos
async function generateProductsReport(formato) {
    const category = document.getElementById('productsCategory').value;
    
    const params = new URLSearchParams();
    if (category) params.append('categoria', category);
    if (formato === 'excel') params.append('formato', 'excel');
    
    const url = '{{ route("admin.reports.products") }}?' + params.toString();
    
    if (formato === 'excel') {
        window.open(url, '_blank');
        return;
    }
    
    showLoading();
    try {
        const response = await fetch(url);
        const result = await response.json();
        
        if (result.success) {
            displayProductsTable(result.data);
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo generar el reporte: ' + error.message,
            icon: 'error'
        });
    }
}

// Generar reporte de usuarios
async function generateUsersReport(formato) {
    const dateFrom = document.getElementById('usersDateFrom').value;
    const dateTo = document.getElementById('usersDateTo').value;
    
    const params = new URLSearchParams();
    if (dateFrom) params.append('fecha_inicio', dateFrom);
    if (dateTo) params.append('fecha_fin', dateTo);
    if (formato === 'excel') params.append('formato', 'excel');
    
    const url = '{{ route("admin.reports.users") }}?' + params.toString();
    
    if (formato === 'excel') {
        window.open(url, '_blank');
        return;
    }
    
    showLoading();
    try {
        const response = await fetch(url);
        const result = await response.json();
        
        if (result.success) {
            displayUsersTable(result.data);
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo generar el reporte: ' + error.message,
            icon: 'error'
        });
    }
}

// Mostrar loading
function showLoading() {
    const resultsTable = document.getElementById('resultsTable');
    const tableBody = document.getElementById('tableBody');
    
    resultsTable.style.display = 'block';
    tableBody.innerHTML = `
        <tr>
            <td colspan="100%">
                <div class="loading-spinner">
                    <div class="spinner"></div>
                </div>
            </td>
        </tr>
    `;
}

// Mostrar tabla de pedidos
function displayOrdersTable(data) {
    const header = document.getElementById('tableHeader');
    const body = document.getElementById('tableBody');
    const stats = document.getElementById('statsSummary');
    
    // Calcular estadísticas
    const totalPedidos = data.length;
    const totalVentas = data.reduce((sum, order) => sum + parseFloat(order.total.replace(/[^\d.-]/g, '')), 0);
    
    // Mostrar estadísticas
    stats.innerHTML = `
        <div class="stats-grid">
            <div class="stat-item">
                <div class="stat-number">${totalPedidos}</div>
                <div class="stat-label">Total Pedidos</div>
            </div>
            <div class="stat-item">
                <div class="stat-number">S/ ${totalVentas.toFixed(2)}</div>
                <div class="stat-label">Ventas Totales</div>
            </div>
        </div>
    `;
    stats.style.display = 'block';
    
    // Encabezados
    header.innerHTML = `
        <tr>
            <th>ID</th>
            <th>Número</th>
            <th>Cliente</th>
            <th>Email</th>
            <th>Teléfono</th>
            <th>Dirección</th>
            <th>Pago</th>
            <th>Total</th>
            <th>Items</th>
            <th>Estado</th>
            <th>Fecha</th>
        </tr>
    `;
    
    // Datos
    body.innerHTML = data.map(order => `
        <tr>
            <td>${order.id}</td>
            <td><strong>${order.order_number}</strong></td>
            <td>${order.cliente}</td>
            <td>${order.email}</td>
            <td>${order.telefono}</td>
            <td>${order.direccion}</td>
            <td>${order.metodo_pago}</td>
            <td><strong>S/ ${order.total}</strong></td>
            <td>${order.items}</td>
            <td>${order.estado}</td>
            <td>${order.fecha}</td>
        </tr>
    `).join('');
}

// Mostrar tabla de mensajes
function displayMessagesTable(data) {
    const header = document.getElementById('tableHeader');
    const body = document.getElementById('tableBody');
    const stats = document.getElementById('statsSummary');
    
    // Calcular estadísticas
    const totalMensajes = data.length;
    const nuevos = data.filter(m => m.estado === 'Nuevo').length;
    const respondidos = data.filter(m => m.estado === 'Respondido').length;
    
    // Mostrar estadísticas
    stats.innerHTML = `
        <div class="stats-grid">
            <div class="stat-item">
                <div class="stat-number">${totalMensajes}</div>
                <div class="stat-label">Total Mensajes</div>
            </div>
            <div class="stat-item">
                <div class="stat-number">${nuevos}</div>
                <div class="stat-label">Nuevos</div>
            </div>
            <div class="stat-item">
                <div class="stat-number">${respondidos}</div>
                <div class="stat-label">Respondidos</div>
            </div>
        </div>
    `;
    stats.style.display = 'block';
    
    // Encabezados
    header.innerHTML = `
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Email</th>
            <th>Teléfono</th>
            <th>Asunto</th>
            <th>Mensaje</th>
            <th>Estado</th>
            <th>Fecha</th>
        </tr>
    `;
    
    // Datos
    body.innerHTML = data.map(message => `
        <tr>
            <td>${message.id}</td>
            <td>${message.nombre}</td>
            <td>${message.email}</td>
            <td>${message.telefono}</td>
            <td>${message.asunto}</td>
            <td>${message.mensaje}</td>
            <td>${message.estado}</td>
            <td>${message.fecha}</td>
        </tr>
    `).join('');
}

// Mostrar tabla de productos
function displayProductsTable(data) {
    const header = document.getElementById('tableHeader');
    const body = document.getElementById('tableBody');
    const stats = document.getElementById('statsSummary');
    
    // Calcular estadísticas
    const totalProductos = data.length;
    
    // Mostrar estadísticas
    stats.innerHTML = `
        <div class="stats-grid">
            <div class="stat-item">
                <div class="stat-number">${totalProductos}</div>
                <div class="stat-label">Total Productos</div>
            </div>
        </div>
    `;
    stats.style.display = 'block';
    
    // Encabezados
    header.innerHTML = `
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Categoría</th>
            <th>Precio</th>
            <th>Stock</th>
            <th>Estado</th>
            <th>Fecha</th>
        </tr>
    `;
    
    // Datos
    body.innerHTML = data.map(product => `
        <tr>
            <td>${product.id}</td>
            <td>${product.nombre}</td>
            <td>${product.categoria}</td>
            <td><strong>${product.precio}</strong></td>
            <td>${product.stock}</td>
            <td>${product.estado}</td>
            <td>${product.fecha}</td>
        </tr>
    `).join('');
}

// Mostrar tabla de usuarios
function displayUsersTable(data) {
    const header = document.getElementById('tableHeader');
    const body = document.getElementById('tableBody');
    const stats = document.getElementById('statsSummary');
    
    // Calcular estadísticas
    const totalUsuarios = data.length;
    
    // Mostrar estadísticas
    stats.innerHTML = `
        <div class="stats-grid">
            <div class="stat-item">
                <div class="stat-number">${totalUsuarios}</div>
                <div class="stat-label">Total Usuarios</div>
            </div>
        </div>
    `;
    stats.style.display = 'block';
    
    // Encabezados
    header.innerHTML = `
        <tr>
            <th>ID</th>
            <th>Nombre</th>
            <th>Email</th>
            <th>Pedidos</th>
            <th>Registro</th>
            <th>Último Acceso</th>
        </tr>
    `;
    
    // Datos
    body.innerHTML = data.map(user => `
        <tr>
            <td>${user.id}</td>
            <td>${user.nombre}</td>
            <td>${user.email}</td>
            <td>${user.pedidos}</td>
            <td>${user.fecha_registro}</td>
            <td>${user.ultimo_acceso}</td>
        </tr>
    `).join('');
}
</script>
@endpush
