@extends('include.template')

@section('content')
<div class="login-container">
    <div class="login-form-wrapper">
        <div class="login-form">
            <h2>Iniciar Sesión</h2>
            <form id="loginForm">
                @csrf
                <div class="form-group">
                    <input type="email" id="email" name="email" placeholder="Correo electrónico" required>
                </div>
                <div class="form-group">
                    <input type="password" id="password" name="password" placeholder="Contraseña" required>
                </div>
                <button type="submit" class="btn btn-primary login-btn">Iniciar Sesión</button>
            </form>
            
            <div class="login-links">
                <p>¿No tienes cuenta? <a href="{{ route('register') }}">Regístrate aquí</a></p>
            </div>
           
        </div>
    </div>
</div>

<style>
.login-container {
    min-height: 80vh;
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 2rem;
}

.login-form-wrapper {
    background: white;
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    padding: 3rem;
    max-width: 400px;
    width: 100%;
}

.login-form h2 {
    text-align: center;
    margin-bottom: 2rem;
    color: #333;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group input {
    width: 100%;
    padding: 12px;
    border: 1px solid #ddd;
    border-radius: 5px;
    font-size: 16px;
}

.login-btn {
    width: 100%;
    padding: 12px;
    background: #007bff;
    color: white;
    border: none;
    border-radius: 5px;
    font-size: 16px;
    cursor: pointer;
}

.login-btn:hover {
    background: #0056b3;
}

.login-links {
    text-align: center;
    margin-top: 1rem;
}

.login-links a {
    color: #007bff;
    text-decoration: none;
}
</style>
@endsection

@section('script')
<script>
// URLs para AJAX
window.loginUrl = "{{ route('login.post') }}";
window.createUserUrl = "{{ route('create.test.user') }}";

$(document).ready(function() {
    $('#loginForm').on('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        
        $.ajax({
            url: window.loginUrl,
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        title: '¡Éxito!',
                        text: response.message,
                        icon: 'success',
                        timer: 1500,
                        showConfirmButton: false
                    }).then(() => {
                        window.location.href = response.redirect;
                    });
                } else {
                    Swal.fire({
                        title: 'Error',
                        text: response.message,
                        icon: 'error'
                    });
                }
            },
            error: function() {
                Swal.fire({
                    title: 'Error',
                    text: 'Error de conexión',
                    icon: 'error'
                });
            }
        });
    });
});

function createTestUser() {
    $.ajax({
        url: window.createUserUrl,
        type: "POST",
        data: {
            _token: $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                Swal.fire({
                    title: '¡Usuario creado!',
                    html: `Email: ${response.email}<br>Password: ${response.password}`,
                    icon: 'success'
                });
            }
        }
    });
}
</script>
@endsection
