<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crear Administrador - ElectroMart</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            max-width: 500px; 
            margin: 50px auto; 
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .btn { 
            background: #667eea; 
            color: white; 
            padding: 15px 30px; 
            border: none; 
            border-radius: 5px; 
            cursor: pointer; 
            font-size: 16px;
            width: 100%;
        }
        .btn:hover { background: #5a67d8; }
        .success { color: #28a745; margin: 15px 0; }
        .error { color: #dc3545; margin: 15px 0; }
        .info { background: #e3f2fd; padding: 15px; border-radius: 5px; margin: 20px 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Crear Usuario Administrador</h1>
        <p>Haz clic en el botón para crear un usuario administrador por defecto.</p>
        
        <div class="info">
            <strong>Credenciales por defecto:</strong><br>
            Email: admin@electromart.pe<br>
            Contraseña: admin123
        </div>
        
        <button class="btn" onclick="createAdmin()">Crear Administrador</button>
        
        <div id="result"></div>
        
        <div style="margin-top: 30px; text-align: center;">
            <a href="/administrador" style="color: #667eea;">Ir al Login de Administrador</a>
        </div>
    </div>

    <script>
        async function createAdmin() {
            try {
                const response = await fetch('/create-admin', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });
                
                const data = await response.json();
                const resultDiv = document.getElementById('result');
                
                if (data.success) {
                    resultDiv.innerHTML = `<div class="success">✅ ${data.message}</div>`;
                } else {
                    resultDiv.innerHTML = `<div class="error">❌ ${data.message}</div>`;
                }
            } catch (error) {
                document.getElementById('result').innerHTML = `<div class="error">❌ Error al crear administrador</div>`;
            }
        }
    </script>
</body>
</html>
