    <!-- Header -->
    <header class="header">
        <div class="user-dropdown">
        </div>
        <div class="container">
            <div class="header-top-content">
                <div class="header-top-left">
                    <a href="#nosotros" class="header-link">Nosotros</a>
                    <a href="#blog" class="header-link">Blog</a>
                    <a href="#contacto" class="header-link">Contacto</a>
                </div>
               
            </div>
        </div>
        </div>

        <div class="header-main">
            <div class="container">
                <div class="header-main-content">
                    <div class="logo">
                        <h1>Industria sp</h1>
                    </div>

                    <nav class="main-nav">
                        <a href="{{ route('index') }}" class="nav-link">Inicio</a>
                        <a href="{{ route('Producto.index') }}" class="nav-link">Productos</a>
                        <a href="#servicio" class="nav-link">Servicio Técnico</a>
                    </nav>

                    <div class="header-actions">
                        <button class="search-btn">
                            <i class="fas fa-search"></i>
                        </button>
                        <button class="cart-btn" onclick="openCartModal()">
                            <i class="fas fa-shopping-cart"></i>
                            <span class="cart-count">0</span>
                        </button>

                        <!-- User Menu -->
                        <div class="user-menu-container">
                            @if (Session::has('user_id'))
                                <!-- Usuario logueado -->
                                <div class="user-profile" onclick="toggleUserMenu()">
                                    <div class="user-avatar">
                                        <i class="fas fa-user"></i>
                                    </div>
                                    <span class="user-name">{{ Session::get('user_name') }}</span>
                                    <i class="fas fa-chevron-down user-arrow"></i>
                                </div>

                                <!-- Menú desplegable -->
                                <div class="user-dropdown" id="userDropdown">
                                    <div class="user-dropdown-header">
                                        <div class="user-info">
                                            <strong>{{ Session::get('user_name') }}</strong>
                                            <span>{{ Session::get('user_email') }}</span>
                                        </div>
                                    </div>
                                    <div class="user-dropdown-menu">
                                        <div class="user-dropdown-menu">
                                            <a href="{{ route('user.profile') }}" class="dropdown-item">
                                                <i class="fas fa-user"></i> Mi Perfil
                                            </a>
                                            <a href="{{ route('user.orders') }}" class="dropdown-item">
                                                <i class="fas fa-shopping-bag"></i> Mis Pedidos
                                            </a>
                                            <a href="{{ route('user.settings') }}" class="dropdown-item">
                                                <i class="fas fa-cog"></i> Configuración
                                            </a>
                                        </div>
                                        <div class="dropdown-divider"></div>
                                        <a href="#" class="dropdown-item logout-btn" onclick="logout()">
                                            <i class="fas fa-sign-out-alt"></i> Cerrar Sesión
                                        </a>
                                    </div>
                                </div>
                            @else
                                <!-- Usuario no logueado -->
                                <a href="{{ route('login') }}" class="login-btn">
                                    <i class="fas fa-user"></i>
                                    <span>Iniciar Sesión</span>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Modal del Carrito -->
    <div class="cart-modal" id="cartModal">
        <div class="cart-modal-content">
            <div class="cart-modal-header">
                <h3>Mi Carrito</h3>
                <button class="close-modal" onclick="closeCartModal()">
                    <i class="fas fa-times"></i>
                </button>
            </div>

            <div class="cart-modal-body" id="cartModalBody">
                <!-- Los items del carrito se cargarán aquí -->
            </div>

            <div class="cart-modal-footer">
                <div class="cart-total">
                    <strong>Total: <span id="cartModalTotal">S/ 0.00</span></strong>
                </div>
                <div class="cart-actions">
                    <button class="btn btn-secondary" onclick="closeCartModal()">
                        Seguir Comprando
                    </button>
                    <button class="btn btn-primary" onclick="goToCheckout()">
                        <i class="fas fa-credit-card"></i>
                        Ir a Pagar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <style>
        /* Estilos del modal del carrito */
        .cart-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 9999;
            overflow-y: auto;
        }

        .cart-modal.show {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .cart-modal-content {
            background: white;
            border-radius: 10px;
            max-width: 600px;
            width: 90%;
            max-height: 80vh;
            overflow: hidden;
            display: flex;
            flex-direction: column;
        }

        .cart-modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1.5rem;
            border-bottom: 1px solid #eee;
        }

        .close-modal {
            background: none;
            border: none;
            font-size: 20px;
            color: #666;
            cursor: pointer;
            padding: 5px;
        }

        .cart-modal-body {
            flex: 1;
            overflow-y: auto;
            padding: 1rem;
            max-height: 400px;
        }

        .cart-item {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1rem 0;
            border-bottom: 1px solid #eee;
        }

        .cart-item:last-child {
            border-bottom: none;
        }

        .cart-item-image {
            width: 60px;
            height: 60px;
            border-radius: 5px;
            object-fit: cover;
        }

        .cart-item-details {
            flex: 1;
        }

        .cart-item-name {
            font-weight: 500;
            margin-bottom: 0.25rem;
        }

        .cart-item-price {
            color: #666;
            font-size: 14px;
        }

        .cart-item-controls {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .quantity-btn {
            width: 30px;
            height: 30px;
            border: 1px solid #ddd;
            background: white;
            border-radius: 3px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .quantity-btn:hover {
            background: #f8f9fa;
        }

        .quantity-input {
            width: 50px;
            text-align: center;
            border: 1px solid #ddd;
            border-radius: 3px;
            padding: 5px;
        }

        .remove-item {
            color: #dc3545;
            background: none;
            border: none;
            cursor: pointer;
            padding: 5px;
            margin-left: 0.5rem;
        }

        .cart-modal-footer {
            padding: 1.5rem;
            border-top: 1px solid #eee;
            background: #f8f9fa;
        }

        .cart-total {
            text-align: center;
            margin-bottom: 1rem;
            font-size: 18px;
        }

        .cart-actions {
            display: flex;
            gap: 1rem;
            justify-content: center;
        }

        .cart-actions .btn {
            flex: 1;
            max-width: 200px;
        }

        .empty-cart {
            text-align: center;
            padding: 2rem;
            color: #666;
        }

        .empty-cart i {
            font-size: 48px;
            margin-bottom: 1rem;
            color: #ddd;
        }

        @media (max-width: 768px) {
            .cart-modal-content {
                width: 95%;
                margin: 1rem;
            }

            .cart-actions {
                flex-direction: column;
            }

            .cart-actions .btn {
                max-width: none;
            }
        }
    </style>

    <style>
        /* Estilos para el menú de usuario */
        .user-menu-container {
            position: relative;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 12px;
            background: #f8f9fa;
            border-radius: 25px;
            cursor: pointer;
            transition: all 0.3s ease;
            border: 1px solid #e0e0e0;
        }

        .user-profile:hover {
            background: #e9ecef;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .user-avatar {
            width: 32px;
            height: 32px;
            background: #007bff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
        }

        .user-name {
            font-weight: 500;
            color: #333;
            font-size: 14px;
        }

        .user-arrow {
            font-size: 12px;
            color: #666;
            transition: transform 0.3s ease;
        }

        .user-profile.active .user-arrow {
            transform: rotate(180deg);
        }

        .user-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            margin-top: 8px;
            width: 280px;
            background: white;
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
            border: 1px solid #e0e0e0;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .user-dropdown.show {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }

        .user-dropdown-header {
            padding: 16px;
            border-bottom: 1px solid #e0e0e0;
            background: #f8f9fa;
            border-radius: 8px 8px 0 0;
        }

        .user-info strong {
            display: block;
            color: #333;
            font-size: 16px;
            margin-bottom: 4px;
        }

        .user-info span {
            color: #666;
            font-size: 14px;
        }

        .user-dropdown-menu {
            padding: 8px 0;
        }

        .dropdown-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            color: #333;
            text-decoration: none;
            transition: background 0.2s ease;
        }

        .dropdown-item:hover {
            background: #f8f9fa;
            color: #007bff;
        }

        .dropdown-item i {
            width: 16px;
            font-size: 14px;
        }

        .dropdown-divider {
            height: 1px;
            background: #e0e0e0;
            margin: 8px 0;
        }

        .logout-btn {
            color: #dc3545 !important;
        }

        .logout-btn:hover {
            background: #fff5f5 !important;
        }

        .login-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            background: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 25px;
            transition: all 0.3s ease;
            font-size: 14px;
        }

        .login-btn:hover {
            background: #0056b3;
            color: white;
            text-decoration: none;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .user-dropdown {
                width: 250px;
            }

            .user-name {
                display: none;
            }
        }
    </style>

    <script>
        // URLs para el carrito
        window.getCartItemsUrl = "{{ route('cart.items') }}";
        window.updateCartItemUrl = "{{ route('cart.update') }}";
        window.removeCartItemUrl = "{{ route('cart.remove') }}";
        window.checkoutUrl = "{{ route('checkout') }}";

        // Funciones básicas
        function toggleUserMenu() {
            const dropdown = document.getElementById('userDropdown');
            const profile = document.querySelector('.user-profile');

            if (dropdown && profile) {
                dropdown.classList.toggle('show');
                profile.classList.toggle('active');
            }
        }

        function logout() {
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    title: '¿Cerrar sesión?',
                    text: '¿Estás seguro que deseas cerrar tu sesión?',
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonText: 'Sí, cerrar sesión',
                    cancelButtonText: 'Cancelar',
                    confirmButtonColor: '#dc3545'
                }).then((result) => {
                    if (result.isConfirmed) {
                        const form = document.createElement('form');
                        form.method = 'POST';
                        form.action = '{{ route('logout') }}';

                        const csrfToken = document.createElement('input');
                        csrfToken.type = 'hidden';
                        csrfToken.name = '_token';
                        csrfToken.value = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

                        form.appendChild(csrfToken);
                        document.body.appendChild(form);
                        form.submit();
                    }
                });
            }
        }

        // Funciones del carrito
        function openCartModal() {
            @if (Session::has('user_id'))
                loadCartItems();
                const modal = document.getElementById('cartModal');
                if (modal) {
                    modal.classList.add('show');
                }
            @else
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        title: 'Debes iniciar sesión',
                        text: 'Para ver tu carrito necesitas estar logueado',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Ir a Login',
                        cancelButtonText: 'Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = "{{ route('login') }}";
                        }
                    });
                }
            @endif
        }

        function closeCartModal() {
            const modal = document.getElementById('cartModal');
            if (modal) {
                modal.classList.remove('show');
            }
        }

        function loadCartItems() {
            console.log('Cargando items del carrito...'); // Debug

            // Usar fetch en lugar de jQuery para evitar problemas
            fetch(window.getCartItemsUrl, {
                    method: 'GET',
                    headers: {
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    console.log('Respuesta del servidor:', data); // Debug

                    if (data.success) {
                        let itemsHtml = '';

                        if (data.items.length === 0) {
                            itemsHtml = `
                        <div class="empty-cart">
                            <i class="fas fa-shopping-cart"></i>
                            <h4>Tu carrito está vacío</h4>
                            <p>Agrega algunos productos para comenzar</p>
                        </div>
                    `;
                        } else {
                            data.items.forEach(function(item) {
                                // Convertir price a número para evitar errores con toFixed
                                const price = parseFloat(item.price);
                                const subtotal = parseFloat(item.subtotal);

                                itemsHtml += `
                            <div class="cart-item" data-cart-id="${item.id}">
                                <img src="${item.image}" alt="${item.name}" class="cart-item-image">
                                <div class="cart-item-details">
                                    <div class="cart-item-name">${item.name}</div>
                                    <div class="cart-item-price">S/ ${price.toFixed(2)}</div>
                                </div>
                                <div class="cart-item-controls">
                                    <button class="quantity-btn" onclick="updateQuantity(${item.id}, ${item.quantity - 1})">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <input type="number" value="${item.quantity}" min="1" class="quantity-input" 
                                           onchange="updateQuantity(${item.id}, this.value)">
                                    <button class="quantity-btn" onclick="updateQuantity(${item.id}, ${item.quantity + 1})">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                    <button class="remove-item" onclick="removeItem(${item.id})">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                        `;
                            });
                        }

                        const cartBody = document.getElementById('cartModalBody');
                        const cartTotal = document.getElementById('cartModalTotal');

                        if (cartBody) cartBody.innerHTML = itemsHtml;
                        if (cartTotal) cartTotal.textContent = data.formatted_total;
                    } else {
                        console.error('Error:', data.message);
                    }
                })
                .catch(error => {
                    console.error('Error al cargar carrito:', error);
                });
        }

        function updateQuantity(cartItemId, newQuantity) {
            if (newQuantity < 1) {
                removeItem(cartItemId);
                return;
            }

            const formData = new FormData();
            formData.append('cart_item_id', cartItemId);
            formData.append('quantity', newQuantity);
            formData.append('_token', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));

            fetch(window.updateCartItemUrl, {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        loadCartItems();
                        updateHeaderCartCount(data.cart_count);
                    }
                })
                .catch(error => console.error('Error:', error));
        }

        function removeItem(cartItemId) {
            const formData = new FormData();
            formData.append('cart_item_id', cartItemId);
            formData.append('_token', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));

            fetch(window.removeCartItemUrl, {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        loadCartItems();
                        updateHeaderCartCount(data.cart_count);

                        if (typeof Swal !== 'undefined') {
                            Swal.fire({
                                title: 'Producto eliminado',
                                text: data.message,
                                icon: 'success',
                                timer: 1500,
                                showConfirmButton: false,
                                position: 'top-end',
                                toast: true
                            });
                        }
                    }
                })
                .catch(error => console.error('Error:', error));
        }

        function goToCheckout() {
            window.location.href = window.checkoutUrl;
        }

        function updateHeaderCartCount(count) {
            const cartCounter = document.querySelector('.cart-count');
            if (cartCounter) {
                cartCounter.textContent = count || 0;
            }
        }

        // Event listeners
        document.addEventListener('click', function(event) {
            const userMenu = document.querySelector('.user-menu-container');
            const dropdown = document.getElementById('userDropdown');
            const profile = document.querySelector('.user-profile');
            const cartModal = document.getElementById('cartModal');

            // Cerrar menú de usuario
            if (userMenu && !userMenu.contains(event.target)) {
                if (dropdown) dropdown.classList.remove('show');
                if (profile) profile.classList.remove('active');
            }

            // Cerrar modal del carrito
            if (cartModal && event.target === cartModal) {
                closeCartModal();
            }
        });

        // Cargar contador inicial del carrito
        @if (Session::has('user_id'))
            document.addEventListener('DOMContentLoaded', function() {
                fetch("{{ route('cart.count') }}", {
                        method: 'GET',
                        headers: {
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        updateHeaderCartCount(data.count);
                    })
                    .catch(error => console.error('Error al cargar contador:', error));
            });
        @endif
    </script>
