@extends('include.template')

@section('content')
<div class="order-success-container">
    <div class="success-card">
        <div class="success-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        
        <h1>¡Pedido Realizado con Éxito!</h1>
        
        <div class="order-details">
            <h3>Detalles de tu Pedido</h3>
            <div class="detail-item">
                <span class="label">Número de Orden:</span>
                <span class="value">#{{ $order->order_number }}</span>
            </div>
            <div class="detail-item">
                <span class="label">Total Pagado:</span>
                <span class="value">S/ {{ number_format($order->total, 2) }}</span>
            </div>
            <div class="detail-item">
                <span class="label">Método de Pago:</span>
                <span class="value">
                    @if($order->payment_method === 'tarjeta')
                        Tarjeta de Crédito/Débito
                    @elseif($order->payment_method === 'efectivo')
                        Efectivo
                    @else
                        {{ ucfirst($order->payment_method) }}
                    @endif
                </span>
            </div>
            <div class="detail-item">
                <span class="label">Estado:</span>
                <span class="value status-pending">Pendiente</span>
            </div>
        </div>

        <div class="delivery-info">
            <h3>Información de Entrega</h3>
            <p><strong>Nombre:</strong> {{ $order->full_name }}</p>
            <p><strong>Teléfono:</strong> {{ $order->phone }}</p>
            <p><strong>Dirección:</strong> {{ $order->address }}</p>
            <p><strong>Distrito:</strong> {{ $order->district }}</p>
        </div>

        <div class="next-steps">
            <h3>¿Qué sigue?</h3>
            <ul>
                <li><i class="fas fa-phone"></i> Te contactaremos en las próximas 2 horas para confirmar tu pedido</li>
                <li><i class="fas fa-truck"></i> El tiempo de entrega es de 1 a 3 días hábiles</li>
                <li><i class="fas fa-whatsapp"></i> Recibirás actualizaciones por WhatsApp</li>
            </ul>
        </div>

        <div class="action-buttons">
            <a href="{{ route('index') }}" class="btn btn-primary">
                <i class="fas fa-home"></i>
                Volver al Inicio
            </a>
            <button onclick="window.print()" class="btn btn-secondary">
                <i class="fas fa-print"></i>
                Imprimir Comprobante
            </button>
        </div>
    </div>
</div>

<style>
.order-success-container {
    max-width: 800px;
    margin: 2rem auto;
    padding: 1rem;
    min-height: 60vh;
}

.success-card {
    background: white;
    padding: 3rem;
    border-radius: 15px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    text-align: center;
}

.success-icon {
    font-size: 4rem;
    color: #28a745;
    margin-bottom: 1rem;
}

.success-card h1 {
    color: #28a745;
    margin-bottom: 2rem;
    font-size: 2rem;
}

.order-details,
.delivery-info,
.next-steps {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 10px;
    margin: 1.5rem 0;
    text-align: left;
}

.order-details h3,
.delivery-info h3,
.next-steps h3 {
    color: #333;
    margin-bottom: 1rem;
    font-size: 1.2rem;
    border-bottom: 2px solid #007bff;
    padding-bottom: 0.5rem;
}

.detail-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0.5rem 0;
    border-bottom: 1px solid #eee;
}

.detail-item:last-child {
    border-bottom: none;
}

.label {
    font-weight: 500;
    color: #666;
}

.value {
    font-weight: bold;
    color: #333;
}

.status-pending {
    color: #ffc107;
    background: rgba(255, 193, 7, 0.1);
    padding: 0.25rem 0.5rem;
    border-radius: 15px;
    font-size: 0.9rem;
}

.delivery-info p {
    margin: 0.5rem 0;
    color: #555;
}

.next-steps ul {
    list-style: none;
    padding: 0;
}

.next-steps li {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem 0;
    color: #555;
}

.next-steps li i {
    color: #007bff;
    width: 20px;
}

.action-buttons {
    display: flex;
    gap: 1rem;
    justify-content: center;
    margin-top: 2rem;
}

.btn {
    padding: 12px 24px;
    border: none;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-primary {
    background: #007bff;
    color: white;
}

.btn-primary:hover {
    background: #0056b3;
    transform: translateY(-2px);
}

.btn-secondary {
    background: #6c757d;
    color: white;
}

.btn-secondary:hover {
    background: #545b62;
    transform: translateY(-2px);
}

@media (max-width: 768px) {
    .success-card {
        padding: 2rem 1rem;
    }
    
    .action-buttons {
        flex-direction: column;
    }
    
    .detail-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.25rem;
    }
}

@media print {
    .action-buttons {
        display: none;
    }
    
    .success-card {
        box-shadow: none;
        border: 1px solid #ddd;
    }
}
</style>
@endsection

@section('script')
<script>
// Prevenir navegación hacia atrás después de completar orden
if (window.history && window.history.pushState) {
    window.history.pushState('forward', null, window.location.href);
    window.addEventListener('popstate', function() {
        window.history.pushState('forward', null, window.location.href);
    });
}

// Limpiar cache del navegador
if ('caches' in window) {
    caches.keys().then(function(names) {
        names.forEach(function(name) {
            caches.delete(name);
        });
    });
}

// Mensaje de confirmación si intentan cerrar la página
window.addEventListener('beforeunload', function(e) {
    const message = 'Tu pedido ha sido procesado exitosamente. ¿Estás seguro que quieres salir?';
    e.returnValue = message;
    return message;
});

// Eliminar el mensaje después de 10 segundos
setTimeout(function() {
    window.removeEventListener('beforeunload', function() {});
}, 10000);
</script>
@endsection
