@extends('include.template')

@section('content')
<div class="profile-container">
    <div class="profile-header">
        <div class="profile-info">
            <div class="profile-avatar">
                <i class="fas fa-user-circle"></i>
            </div>
            <div class="profile-details">
                <h1>{{ $user->name }}</h1>
                <p class="profile-email">{{ $user->email }}</p>
                <p class="profile-member-since">Miembro desde {{ $user->created_at->format('F Y') }}</p>
            </div>
        </div>
        <div class="profile-stats">
            <div class="stat-item">
                <span class="stat-number">{{ $user->orders()->count() }}</span>
                <span class="stat-label">Pedidos</span>
            </div>
            <div class="stat-item">
                <span class="stat-number">S/ {{ number_format($user->orders()->sum('total'), 2) }}</span>
                <span class="stat-label">Total Gastado</span>
            </div>
        </div>
    </div>

    <div class="profile-content">
        <div class="profile-menu">
            <a href="{{ route('user.profile') }}" class="menu-item active">
                <i class="fas fa-user"></i>
                Mi Perfil
            </a>
            <a href="{{ route('user.orders') }}" class="menu-item">
                <i class="fas fa-shopping-bag"></i>
                Mis Pedidos
            </a>
            <a href="{{ route('user.settings') }}" class="menu-item">
                <i class="fas fa-cog"></i>
                Configuración
            </a>
        </div>

        <div class="profile-main">
            <div class="section-card">
                <h2>Información Personal</h2>
                <form id="profileForm" class="profile-form">
                    @csrf
                    <div class="form-row">
                        <div class="form-group">
                            <label for="name">Nombre Completo</label>
                            <input type="text" id="name" name="name" value="{{ $user->name }}" required>
                        </div>
                        <div class="form-group">
                            <label for="email">Correo Electrónico</label>
                            <input type="email" id="email" name="email" value="{{ $user->email }}" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="phone">Teléfono</label>
                            <input type="tel" id="phone" name="phone" value="{{ $user->phone }}">
                        </div>
                        <div class="form-group">
                            <label>Miembro desde</label>
                            <input type="text" value="{{ $user->created_at->format('d/m/Y') }}" readonly class="readonly-input">
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        Guardar Cambios
                    </button>
                </form>
            </div>

            <div class="section-card">
                <h2>Resumen de Actividad</h2>
                <div class="activity-grid">
                    <div class="activity-item">
                        <div class="activity-icon">
                            <i class="fas fa-shopping-cart"></i>
                        </div>
                        <div class="activity-info">
                            <h3>{{ $user->orders()->count() }}</h3>
                            <p>Pedidos Realizados</p>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="activity-info">
                            <h3>{{ $user->orders()->where('status', 'pending')->count() }}</h3>
                            <p>Pedidos Pendientes</p>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <div class="activity-info">
                            <h3>{{ $user->orders()->where('status', 'delivered')->count() }}</h3>
                            <p>Pedidos Entregados</p>
                        </div>
                    </div>
                    <div class="activity-item">
                        <div class="activity-icon">
                            <i class="fas fa-heart"></i>
                        </div>
                        <div class="activity-info">
                            <h3>0</h3>
                            <p>Productos Favoritos</p>
                        </div>
                    </div>
                </div>
            </div>

            @if($user->orders()->count() > 0)
            <div class="section-card">
                <h2>Últimos Pedidos</h2>
                <div class="recent-orders">
                    @foreach($user->orders()->latest()->take(3)->get() as $order)
                    <div class="order-item">
                        <div class="order-info">
                            <h4>#{{ $order->order_number }}</h4>
                            <p>{{ $order->created_at->format('d/m/Y H:i') }}</p>
                        </div>
                        <div class="order-status">
                            <span class="status-badge status-{{ $order->status }}">
                                {{ ucfirst($order->status) }}
                            </span>
                        </div>
                        <div class="order-total">
                            <strong>S/ {{ number_format($order->total, 2) }}</strong>
                        </div>
                    </div>
                    @endforeach
                </div>
                <a href="{{ route('user.orders') }}" class="btn btn-outline">Ver todos los pedidos</a>
            </div>
            @endif
        </div>
    </div>
</div>

<style>
.profile-container {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 0 1rem;
}

.profile-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px 15px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.profile-info {
    display: flex;
    align-items: center;
    gap: 1.5rem;
}

.profile-avatar i {
    font-size: 4rem;
    opacity: 0.9;
}

.profile-details h1 {
    margin: 0 0 0.5rem 0;
    font-size: 1.8rem;
}

.profile-email {
    opacity: 0.9;
    margin: 0 0 0.25rem 0;
}

.profile-member-since {
    opacity: 0.7;
    margin: 0;
    font-size: 0.9rem;
}

.profile-stats {
    display: flex;
    gap: 2rem;
}

.stat-item {
    text-align: center;
}

.stat-number {
    display: block;
    font-size: 1.8rem;
    font-weight: bold;
}

.stat-label {
    font-size: 0.9rem;
    opacity: 0.8;
}

.profile-content {
    display: grid;
    grid-template-columns: 250px 1fr;
    background: white;
    border-radius: 0 0 15px 15px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    overflow: hidden;
}

.profile-menu {
    background: #f8f9fa;
    padding: 1.5rem 0;
}

.menu-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem 1.5rem;
    color: #666;
    text-decoration: none;
    transition: all 0.3s ease;
    border-left: 3px solid transparent;
}

.menu-item:hover {
    background: #e9ecef;
    color: #333;
}

.menu-item.active {
    background: white;
    color: #667eea;
    border-left-color: #667eea;
}

.profile-main {
    padding: 2rem;
}

.section-card {
    background: white;
    border: 1px solid #eee;
    border-radius: 10px;
    padding: 1.5rem;
    margin-bottom: 2rem;
}

.section-card h2 {
    color: #333;
    margin: 0 0 1.5rem 0;
    padding-bottom: 0.5rem;
    border-bottom: 2px solid #f0f0f0;
}

.profile-form {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-group label {
    font-weight: 500;
    color: #333;
}

.form-group input {
    padding: 12px;
    border: 1px solid #ddd;
    border-radius: 8px;
    font-size: 14px;
}

.readonly-input {
    background: #f8f9fa;
    color: #666;
}

.activity-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}

.activity-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 10px;
}

.activity-icon {
    width: 50px;
    height: 50px;
    background: #667eea;
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.activity-info h3 {
    margin: 0;
    font-size: 1.5rem;
    color: #333;
}

.activity-info p {
    margin: 0;
    color: #666;
    font-size: 0.9rem;
}

.recent-orders {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
    margin-bottom: 1rem;
}

.order-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 8px;
}

.order-info h4 {
    margin: 0 0 0.25rem 0;
    color: #333;
}

.order-info p {
    margin: 0;
    color: #666;
    font-size: 0.9rem;
}

.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 15px;
    font-size: 0.8rem;
    font-weight: 500;
}

.status-pending {
    background: #fff3cd;
    color: #856404;
}

.status-confirmed {
    background: #d1ecf1;
    color: #0c5460;
}

.status-delivered {
    background: #d4edda;
    color: #155724;
}

.btn {
    padding: 12px 24px;
    border: none;
    border-radius: 8px;
    font-weight: 500;
    cursor: pointer;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.3s ease;
}

.btn-primary {
    background: #667eea;
    color: white;
}

.btn-primary:hover {
    background: #5a6fd8;
    transform: translateY(-2px);
}

.btn-outline {
    background: transparent;
    color: #667eea;
    border: 2px solid #667eea;
}

.btn-outline:hover {
    background: #667eea;
    color: white;
}

@media (max-width: 768px) {
    .profile-header {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .profile-content {
        grid-template-columns: 1fr;
    }
    
    .profile-menu {
        display: flex;
        overflow-x: auto;
        padding: 1rem;
    }
    
    .menu-item {
        white-space: nowrap;
        border-left: none;
        border-bottom: 3px solid transparent;
    }
    
    .menu-item.active {
        border-left: none;
        border-bottom-color: #667eea;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
    
    .activity-grid {
        grid-template-columns: 1fr 1fr;
    }
}
</style>
@endsection

@section('script')
<script>
document.getElementById('profileForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const data = Object.fromEntries(formData);
    
    fetch("{{ route('user.profile.update') }}", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: '¡Perfil Actualizado!',
                text: data.message,
                icon: 'success',
                confirmButtonText: 'Continuar'
            });
        } else {
            Swal.fire({
                title: 'Error',
                text: data.message,
                icon: 'error',
                confirmButtonText: 'Entendido'
            });
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error',
            text: 'Error de conexión',
            icon: 'error',
            confirmButtonText: 'Reintentar'
        });
    });
});
</script>
@endsection
