@extends('include.template')

@section('content')
<div class="profile-container">
    <div class="profile-header">
        <div class="profile-info">
            <div class="profile-avatar">
                <i class="fas fa-cog"></i>
            </div>
            <div class="profile-details">
                <h1>Configuración</h1>
                <p class="profile-subtitle">Administra tu cuenta y preferencias</p>
            </div>
        </div>
    </div>

    <div class="profile-content">
        <div class="profile-menu">
            <a href="{{ route('user.profile') }}" class="menu-item">
                <i class="fas fa-user"></i>
                Mi Perfil
            </a>
            <a href="{{ route('user.orders') }}" class="menu-item">
                <i class="fas fa-shopping-bag"></i>
                Mis Pedidos
            </a>
            <a href="{{ route('user.settings') }}" class="menu-item active">
                <i class="fas fa-cog"></i>
                Configuración
            </a>
        </div>

        <div class="profile-main">
            <!-- Seguridad y Contraseña -->
            <div class="section-card">
                <h2><i class="fas fa-shield-alt"></i> Seguridad y Contraseña</h2>
                <form id="passwordForm" class="settings-form">
                    @csrf
                    <div class="form-group">
                        <label for="current_password">Contraseña Actual</label>
                        <input type="password" id="current_password" name="current_password" required>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label for="new_password">Nueva Contraseña</label>
                            <input type="password" id="new_password" name="new_password" required minlength="6">
                            <small class="form-hint">Mínimo 6 caracteres</small>
                        </div>
                        <div class="form-group">
                            <label for="new_password_confirmation">Confirmar Nueva Contraseña</label>
                            <input type="password" id="new_password_confirmation" name="new_password_confirmation" required>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i>
                        Cambiar Contraseña
                    </button>
                </form>
            </div>

            <!-- Preferencias de Notificaciones -->
            <div class="section-card">
                <h2><i class="fas fa-bell"></i> Notificaciones</h2>
                <div class="settings-form">
                    <div class="notification-setting">
                        <div class="setting-info">
                            <h4>Ofertas y Promociones</h4>
                            <p>Recibe correos sobre descuentos y ofertas especiales</p>
                        </div>
                        <label class="toggle-switch">
                            <input type="checkbox" id="emailOffers" checked>
                            <span class="slider"></span>
                        </label>
                    </div>
                    
                    <div class="notification-setting">
                        <div class="setting-info">
                            <h4>Estado de Pedidos</h4>
                            <p>Notificaciones sobre el estado de tus pedidos</p>
                        </div>
                        <label class="toggle-switch">
                            <input type="checkbox" id="orderUpdates" checked>
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="notification-setting">
                        <div class="setting-info">
                            <h4>Nuevos Productos</h4>
                            <p>Notificaciones sobre nuevos productos y categorías</p>
                        </div>
                        <label class="toggle-switch">
                            <input type="checkbox" id="newProducts">
                            <span class="slider"></span>
                        </label>
                    </div>

                    <div class="notification-setting">
                        <div class="setting-info">
                            <h4>WhatsApp</h4>
                            <p>Recibe actualizaciones importantes por WhatsApp</p>
                        </div>
                        <label class="toggle-switch">
                            <input type="checkbox" id="whatsappNotifications" checked>
                            <span class="slider"></span>
                        </label>
                    </div>

                    <button type="button" class="btn btn-primary" onclick="saveNotificationSettings()">
                        <i class="fas fa-save"></i>
                        Guardar Preferencias
                    </button>
                </div>
            </div>

            <!-- Privacidad y Datos -->
            <div class="section-card">
                <h2><i class="fas fa-user-shield"></i> Privacidad y Datos</h2>
                <div class="privacy-options">
                    <div class="privacy-item">
                        <div class="privacy-info">
                            <h4>Descargar mis Datos</h4>
                            <p>Obtén una copia de toda la información asociada a tu cuenta</p>
                        </div>
                        <button class="btn btn-outline" onclick="downloadData()">
                            <i class="fas fa-download"></i>
                            Descargar
                        </button>
                    </div>

                    <div class="privacy-item">
                        <div class="privacy-info">
                            <h4>Eliminar Historial de Navegación</h4>
                            <p>Borra tu historial de productos visitados y búsquedas</p>
                        </div>
                        <button class="btn btn-outline" onclick="clearHistory()">
                            <i class="fas fa-trash"></i>
                            Limpiar
                        </button>
                    </div>
                </div>
            </div>

            <!-- Información de la Cuenta -->
            <div class="section-card">
                <h2><i class="fas fa-info-circle"></i> Información de la Cuenta</h2>
                <div class="account-info">
                    <div class="info-row">
                        <span class="info-label">ID de Usuario:</span>
                        <span class="info-value">{{ $user->id }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Fecha de Registro:</span>
                        <span class="info-value">{{ $user->created_at->format('d/m/Y H:i') }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Última Actualización:</span>
                        <span class="info-value">{{ $user->updated_at->format('d/m/Y H:i') }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Total de Pedidos:</span>
                        <span class="info-value">{{ $user->orders()->count() }}</span>
                    </div>
                </div>
            </div>

            <!-- Zona de Peligro -->
            <div class="section-card danger-zone">
                <h2><i class="fas fa-exclamation-triangle"></i> Zona de Peligro</h2>
                <div class="danger-content">
                    <div class="danger-item">
                        <div class="danger-info">
                            <h4>Cerrar Sesión en Todos los Dispositivos</h4>
                            <p>Cierra tu sesión en todos los dispositivos donde hayas iniciado sesión</p>
                        </div>
                        <button class="btn btn-warning" onclick="logoutAllDevices()">
                            <i class="fas fa-sign-out-alt"></i>
                            Cerrar Todas las Sesiones
                        </button>
                    </div>

                    <div class="danger-item">
                        <div class="danger-info">
                            <h4>Eliminar Cuenta</h4>
                            <p>Elimina permanentemente tu cuenta y todos los datos asociados</p>
                        </div>
                        <button class="btn btn-danger" onclick="deleteAccount()">
                            <i class="fas fa-user-times"></i>
                            Eliminar Cuenta
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.profile-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem;
    margin-top: 120px;
}

.profile-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.profile-info {
    display: flex;
    align-items: center;
    gap: 1.5rem;
}

.profile-avatar {
    width: 80px;
    height: 80px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
}

.profile-details h1 {
    margin: 0 0 0.5rem 0;
    font-size: 2rem;
    font-weight: 600;
}

.profile-subtitle {
    margin: 0;
    opacity: 0.9;
    font-size: 1.1rem;
}

.profile-content {
    display: grid;
    grid-template-columns: 280px 1fr;
    gap: 2rem;
}

.profile-menu {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    height: fit-content;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    border: 1px solid #f0f0f0;
}

.menu-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    text-decoration: none;
    color: #666;
    border-radius: 10px;
    margin-bottom: 0.5rem;
    transition: all 0.3s ease;
    font-weight: 500;
}

.menu-item:hover {
    background: #f8f9ff;
    color: #667eea;
    transform: translateX(5px);
}

.menu-item.active {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
}

.profile-main {
    background: white;
    border-radius: 15px;
    padding: 0;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    border: 1px solid #f0f0f0;
}

.section-card {
    padding: 2rem;
    border-bottom: 1px solid #f0f0f0;
}

.section-card:last-child {
    border-bottom: none;
    border-radius: 0 0 15px 15px;
}

.section-card:first-child {
    border-radius: 15px 15px 0 0;
}

.section-card h2 {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin: 0 0 1.5rem 0;
    color: #333;
    font-size: 1.5rem;
    font-weight: 600;
}

.settings-form {
    display: flex;
    flex-direction: column;
    gap: 1.5rem;
}

.form-group {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1.5rem;
}

.form-group label {
    font-weight: 600;
    color: #333;
    font-size: 0.95rem;
}

.form-group input {
    padding: 12px 16px;
    border: 2px solid #e9ecef;
    border-radius: 10px;
    font-size: 1rem;
    transition: all 0.3s ease;
    background: #f8f9fa;
}

.form-group input:focus {
    outline: none;
    border-color: #667eea;
    background: white;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.btn {
    padding: 12px 24px;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    font-size: 1rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    text-decoration: none;
    justify-content: center;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea, #764ba2);
    color: white;
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
}

.btn-outline {
    background: white;
    color: #667eea;
    border: 2px solid #667eea;
}

.btn-outline:hover {
    background: #667eea;
    color: white;
    transform: translateY(-2px);
}

.notification-setting,
.privacy-item,
.danger-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem;
    background: #f8f9ff;
    border-radius: 12px;
    margin-bottom: 1rem;
    border: 1px solid #e9ecef;
    transition: all 0.3s ease;
}

.notification-setting:hover,
.privacy-item:hover,
.danger-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.setting-info h4,
.privacy-info h4,
.danger-info h4 {
    margin: 0 0 0.5rem 0;
    color: #333;
    font-size: 1.1rem;
    font-weight: 600;
}

.setting-info p,
.privacy-info p,
.danger-info p {
    margin: 0;
    color: #666;
    font-size: 0.95rem;
    line-height: 1.4;
}

.toggle-switch {
    position: relative;
    display: inline-block;
    width: 60px;
    height: 30px;
}

.toggle-switch input {
    opacity: 0;
    width: 0;
    height: 0;
}

.slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #ccc;
    border-radius: 30px;
    transition: 0.4s;
}

.slider:before {
    position: absolute;
    content: "";
    height: 22px;
    width: 22px;
    left: 4px;
    bottom: 4px;
    background-color: white;
    border-radius: 50%;
    transition: 0.4s;
    box-shadow: 0 2px 4px rgba(0,0,0,0.2);
}

input:checked + .slider {
    background: linear-gradient(135deg, #667eea, #764ba2);
}

input:checked + .slider:before {
    transform: translateX(30px);
}

.privacy-options,
.danger-content {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.account-info {
    background: #f8f9ff;
    padding: 2rem;
    border-radius: 12px;
    border: 1px solid #e9ecef;
}

.info-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem 0;
    border-bottom: 1px solid #e9ecef;
}

.info-row:last-child {
    border-bottom: none;
    padding-bottom: 0;
}

.info-label {
    color: #666;
    font-weight: 600;
    font-size: 0.95rem;
}

.info-value {
    color: #333;
    font-weight: 700;
    font-size: 1rem;
}

.danger-zone {
    border: 2px solid #dc3545;
    background: #fff5f5;
}

.danger-zone h2 {
    color: #dc3545;
}

.danger-zone .danger-item {
    background: white;
    border: 1px solid #ffcdd2;
}

.btn-warning {
    background: linear-gradient(135deg, #ffc107, #ff8f00);
    color: #212529;
    border: none;
    box-shadow: 0 5px 15px rgba(255, 193, 7, 0.3);
}

.btn-warning:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(255, 193, 7, 0.4);
}

.btn-danger {
    background: linear-gradient(135deg, #dc3545, #c82333);
    color: white;
    border: none;
    box-shadow: 0 5px 15px rgba(220, 53, 69, 0.3);
}

.btn-danger:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(220, 53, 69, 0.4);
}

.form-hint {
    color: #666;
    font-size: 0.85rem;
    margin-top: 0.25rem;
    font-style: italic;
}

@media (max-width: 1024px) {
    .profile-content {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .profile-menu {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 0.5rem;
        padding: 1rem;
    }
    
    .menu-item {
        margin-bottom: 0;
        text-align: center;
        flex-direction: column;
        gap: 0.5rem;
        padding: 0.75rem 0.5rem;
        font-size: 0.9rem;
    }
}

@media (max-width: 768px) {
    .profile-container {
        padding: 1rem;
        margin-top: 100px;
    }
    
    .profile-header {
        padding: 1.5rem;
    }
    
    .profile-info {
        flex-direction: column;
        text-align: center;
        gap: 1rem;
    }
    
    .profile-avatar {
        width: 60px;
        height: 60px;
        font-size: 1.5rem;
    }
    
    .profile-details h1 {
        font-size: 1.5rem;
    }
    
    .form-row {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .notification-setting,
    .privacy-item,
    .danger-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 1rem;
        text-align: left;
    }
    
    .toggle-switch {
        align-self: flex-end;
    }
    
    .info-row {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
    
    .section-card {
        padding: 1.5rem;
    }
    
    .profile-menu {
        grid-template-columns: 1fr;
    }
    
    .menu-item {
        flex-direction: row;
        justify-content: flex-start;
    }
}

@media (max-width: 480px) {
    .profile-container {
        padding: 0.5rem;
    }
    
    .profile-header {
        padding: 1rem;
        margin-bottom: 1rem;
    }
    
    .section-card {
        padding: 1rem;
    }
    
    .btn {
        width: 100%;
        justify-content: center;
    }
}
</style>
@endsection

@section('script')
<script>
// Cambiar contraseña
document.getElementById('passwordForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const newPassword = formData.get('new_password');
    const confirmPassword = formData.get('new_password_confirmation');
    
    if (newPassword !== confirmPassword) {
        Swal.fire({
            title: 'Error',
            text: 'Las contraseñas no coinciden',
            icon: 'error',
            confirmButtonText: 'Entendido'
        });
        return;
    }
    
    const data = Object.fromEntries(formData);
    
    fetch("{{ route('user.password.update') }}", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: '¡Contraseña Actualizada!',
                text: data.message,
                icon: 'success',
                confirmButtonText: 'Continuar'
            });
            document.getElementById('passwordForm').reset();
        } else {
            Swal.fire({
                title: 'Error',
                text: data.message,
                icon: 'error',
                confirmButtonText: 'Entendido'
            });
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error',
            text: 'Error de conexión',
            icon: 'error',
            confirmButtonText: 'Reintentar'
        });
    });
});

function saveNotificationSettings() {
    const settings = {
        emailOffers: document.getElementById('emailOffers').checked,
        orderUpdates: document.getElementById('orderUpdates').checked,
        newProducts: document.getElementById('newProducts').checked,
        whatsappNotifications: document.getElementById('whatsappNotifications').checked
    };
    
    // Simular guardado (aquí iría la lógica real)
    Swal.fire({
        title: '¡Preferencias Guardadas!',
        text: 'Tus preferencias de notificación han sido actualizadas',
        icon: 'success',
        confirmButtonText: 'Continuar'
    });
}

function downloadData() {
    Swal.fire({
        title: 'Descargar Datos',
        text: 'Te enviaremos un archivo con todos tus datos a tu correo electrónico en las próximas 24 horas.',
        icon: 'info',
        showCancelButton: true,
        confirmButtonText: 'Solicitar Descarga',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Solicitud Enviada',
                text: 'Recibirás un correo con instrucciones para descargar tus datos',
                icon: 'success',
                confirmButtonText: 'Entendido'
            });
        }
    });
}

function clearHistory() {
    Swal.fire({
        title: '¿Limpiar Historial?',
        text: 'Esta acción eliminará tu historial de navegación y búsquedas',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#007bff',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sí, limpiar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: '¡Historial Limpiado!',
                text: 'Tu historial de navegación ha sido eliminado',
                icon: 'success',
                confirmButtonText: 'Continuar'
            });
        }
    });
}

function logoutAllDevices() {
    Swal.fire({
        title: '¿Cerrar todas las sesiones?',
        text: 'Se cerrará tu sesión en todos los dispositivos donde hayas iniciado sesión',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#ffc107',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sí, cerrar todas',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = "{{ route('logout') }}";
        }
    });
}

function deleteAccount() {
    Swal.fire({
        title: '¿Eliminar cuenta permanentemente?',
        html: `
            <p>Esta acción eliminará:</p>
            <ul style="text-align: left; margin: 1rem 0;">
                <li>Tu perfil y datos personales</li>
                <li>Historial de pedidos</li>
                <li>Preferencias guardadas</li>
                <li>Todos los datos asociados</li>
            </ul>
            <p><strong>Esta acción NO se puede deshacer</strong></p>
        `,
        icon: 'error',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Eliminar mi cuenta',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Confirma con tu contraseña',
                input: 'password',
                inputLabel: 'Ingresa tu contraseña para confirmar',
                inputPlaceholder: 'Contraseña',
                showCancelButton: true,
                confirmButtonText: 'Eliminar Definitivamente',
                cancelButtonText: 'Cancelar',
                inputValidator: (value) => {
                    if (!value) {
                        return 'Debes ingresar tu contraseña';
                    }
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    // Aquí iría la lógica para eliminar la cuenta
                    Swal.fire({
                        title: 'Cuenta Eliminada',
                        text: 'Tu cuenta ha sido eliminada permanentemente',
                        icon: 'info',
                        confirmButtonText: 'Adiós'
                    }).then(() => {
                        window.location.href = "{{ route('index') }}";
                    });
                }
            });
        }
    });
}
</script>
@endsection
