<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Http\Controllers\PrincipalController;
use App\Http\Controllers\ProductoController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\ProfileController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Rutas públicas
Route::get('/', [PrincipalController::class, 'index'])->name('index');
Route::resource('Producto', ProductoController::class);
Route::get('/productos/search', [ProductoController::class, 'search'])->name('productos.search');
Route::get('/productos/home', [ProductoController::class, 'getProductsForHome'])->name('productos.home');

// Rutas de autenticación
Route::get('/login', function () {
    return view('auth.login');
})->name('login');

Route::get('/register', function () {
    return view('auth.register');  
})->name('register');

// Ruta de prueba para login
Route::post('/test-login', function(Request $request) {
    \Log::info('Test login called', $request->all());
    return response()->json(['message' => 'Test login endpoint reached', 'data' => $request->all()]);
});

// Ruta de prueba para verificar usuarios
Route::get('/test-users', function() {
    $users = \App\Models\User::take(5)->get(['id', 'first_name', 'last_name', 'email']);
    return response()->json([
        'users_count' => \App\Models\User::count(),
        'users' => $users
    ]);
});

Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

Route::prefix('auth')->group(function () {
    Route::post('/login', [AuthController::class, 'login'])->name('auth.login');
    Route::post('/register', [AuthController::class, 'register'])->name('auth.register');
    Route::post('/logout', [AuthController::class, 'logout'])->name('auth.logout');
    Route::get('/user', [AuthController::class, 'user'])->name('auth.user');
});

// Rutas del carrito (requieren autenticación) - COMENTADAS HASTA CREAR EL CONTROLLER
/*
Route::middleware('auth')->prefix('cart')->group(function () {
    Route::get('/', [CartController::class, 'getCart'])->name('cart.get');
    Route::post('/add', [CartController::class, 'addToCart'])->name('cart.add');
    Route::post('/update-quantity', [CartController::class, 'updateQuantity'])->name('cart.updateQuantity');
    Route::post('/remove', [CartController::class, 'removeItem'])->name('cart.remove');
    Route::post('/clear', [CartController::class, 'clearCart'])->name('cart.clear');
    Route::get('/count', [CartController::class, 'getCartCount'])->name('cart.count');
});
*/

// Rutas del perfil de usuario (requieren autenticación)
Route::middleware('auth')->prefix('profile')->group(function () {
    Route::get('/', [ProfileController::class, 'index'])->name('profile.index');
    Route::post('/update', [ProfileController::class, 'updateProfile'])->name('profile.update');
    Route::post('/update-image', [ProfileController::class, 'updateProfileImage'])->name('profile.updateImage');
    Route::get('/orders', [ProfileController::class, 'getOrders'])->name('profile.orders');
    Route::post('/orders/{id}/cancel', [ProfileController::class, 'cancelOrder'])->name('profile.orders.cancel');
    Route::get('/orders/{id}/invoice', [ProfileController::class, 'downloadInvoice'])->name('profile.orders.invoice');
    Route::post('/orders/{id}/refund', [ProfileController::class, 'requestRefund'])->name('profile.orders.refund');
    Route::get('/addresses', [ProfileController::class, 'getAddresses'])->name('profile.addresses');
    Route::post('/addresses', [ProfileController::class, 'storeAddress'])->name('profile.addresses.store');
    Route::put('/addresses/{id}', [ProfileController::class, 'updateAddress'])->name('profile.addresses.update');
    Route::delete('/addresses/{id}', [ProfileController::class, 'deleteAddress'])->name('profile.addresses.delete');
    Route::get('/reviews', [ProfileController::class, 'getReviews'])->name('profile.reviews');
    Route::post('/change-password', [ProfileController::class, 'changePassword'])->name('profile.changePassword');
    Route::get('/stats', [ProfileController::class, 'getStats'])->name('profile.stats');
});

// Ruta del checkout (requiere autenticación)
Route::middleware('auth')->get('/checkout', function () {
    return view('checkout.index');
})->name('checkout');
