-- Productos de muestra para ElectroMart
-- Asegúrate de que la tabla products exista con estas columnas: id, name, description, price, image, category_id, created_at, updated_at

-- Primero insertamos las categorías
INSERT INTO categories (name, description, created_at, updated_at) VALUES
('Refrigeración', 'Refrigeradoras, congeladores y exhibidoras', NOW(), NOW()),
('Lavandería', 'Lavadoras, secadoras y centros de lavado', NOW(), NOW()),
('Cocina', 'Cocinas, hornos microondas y campanas', NOW(), NOW()),
('Pequeños Electrodomésticos', 'Licuadoras, batidoras y procesadores', NOW(), NOW())
ON DUPLICATE KEY UPDATE name = VALUES(name);

-- Ahora insertamos productos de muestra
INSERT INTO products (name, description, price, image, category_id, created_at, updated_at) VALUES
-- Refrigeración
('Refrigeradora Samsung RF220NCTASL 220L', 'Refrigeradora No Frost con dispensador de agua, eficiencia energética A+, control de temperatura digital, compartimentos especiales para frutas y verduras.', 1299.00, 'https://images.pexels.com/photos/2343468/pexels-photo-2343468.jpeg?auto=compress&cs=tinysrgb&w=400', 1, NOW(), NOW()),

('Refrigeradora LG GT29BPP 260L', 'Refrigeradora con tecnología Inverter Linear Compressor, No Frost, panel táctil, filtro Pure N Fresh, garantía de 10 años en compresor.', 1599.00, 'https://images.pexels.com/photos/2343468/pexels-photo-2343468.jpeg?auto=compress&cs=tinysrgb&w=400', 1, NOW(), NOW()),

('Congeladora Horizontal Midea 142L', 'Congeladora horizontal con tapa de vidrio templado, canasta interna removible, cerradura de seguridad, bajo consumo energético.', 699.00, 'https://images.pexels.com/photos/2343468/pexels-photo-2343468.jpeg?auto=compress&cs=tinysrgb&w=400', 1, NOW(), NOW()),

-- Lavandería
('Lavadora LG F1496TDP 14kg', 'Lavadora automática con motor Inverter Direct Drive, 12 programas de lavado, vapor TrueSteam, tambor 6 Motion DD, eficiencia A+++.', 1899.00, 'https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=400', 2, NOW(), NOW()),

('Lavadora Samsung WA16T6260BY 16kg', 'Lavadora automática con tecnología Wobble, Activador Dual Storm, Magic Dispenser, Digital Inverter Technology.', 1299.00, 'https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=400', 2, NOW(), NOW()),

('Secadora Whirlpool 7MWED1633DW', 'Secadora eléctrica de 15kg, 13 ciclos de secado, sensor AutoDry, tambor de acero inoxidable, control electrónico.', 1499.00, 'https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=400', 2, NOW(), NOW()),

-- Cocina
('Cocina a Gas Bosch PRO445IX 6 Hornillas', 'Cocina a gas con 6 quemadores, horno de 90 litros, parrillas de hierro fundido, encendido automático, acero inoxidable.', 1799.00, 'https://images.pexels.com/photos/2062431/pexels-photo-2062431.jpeg?auto=compress&cs=tinysrgb&w=400', 3, NOW(), NOW()),

('Microondas LG MS2596OB 25L', 'Horno microondas con grill, 10 niveles de potencia, plato giratorio de cristal, timer digital, función descongelado automático.', 399.00, 'https://images.pexels.com/photos/2062431/pexels-photo-2062431.jpeg?auto=compress&cs=tinysrgb&w=400', 3, NOW(), NOW()),

('Campana Extractora Teka DX2 90cm', 'Campana extractora de pared, 3 velocidades, iluminación LED, filtros de aluminio lavables, nivel de ruido 68dB.', 599.00, 'https://images.pexels.com/photos/2062431/pexels-photo-2062431.jpeg?auto=compress&cs=tinysrgb&w=400', 3, NOW(), NOW()),

-- Pequeños Electrodomésticos
('Licuadora Oster BLSTMG-B00-013', 'Licuadora con vaso de vidrio de 1.5L, cuchillas de acero inoxidable, 3 velocidades + pulso, motor de 600W.', 159.00, 'https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=400', 4, NOW(), NOW()),

('Batidora KitchenAid KSM150', 'Batidora de pedestal con bowl de 4.8L, 10 velocidades, incluye batidor, gancho amasador y batidor globo.', 1299.00, 'https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=400', 4, NOW(), NOW()),

('Procesador de Alimentos Braun FP3010', 'Procesador multifuncional con bowl de 2L, 7 accesorios incluidos, 2 velocidades + pulso, motor de 800W.', 299.00, 'https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=400', 4, NOW(), NOW());

-- Simular algunas ventas para mostrar productos más vendidos
-- Insertamos órdenes de muestra
INSERT INTO orders (user_id, order_number, full_name, phone, address, district, payment_method, subtotal, shipping_cost, total, status, created_at, updated_at) VALUES
(1, 'EM-2024-001', 'Cliente Demo', '987654321', 'Av. Ejemplo 123', 'Lima', 'efectivo', 1299.00, 0.00, 1299.00, 'completed', DATE_SUB(NOW(), INTERVAL 30 DAY), DATE_SUB(NOW(), INTERVAL 30 DAY)),
(1, 'EM-2024-002', 'Cliente Demo', '987654321', 'Av. Ejemplo 123', 'Lima', 'tarjeta', 1899.00, 0.00, 1899.00, 'completed', DATE_SUB(NOW(), INTERVAL 25 DAY), DATE_SUB(NOW(), INTERVAL 25 DAY)),
(1, 'EM-2024-003', 'Cliente Demo', '987654321', 'Av. Ejemplo 123', 'Lima', 'efectivo', 1799.00, 0.00, 1799.00, 'completed', DATE_SUB(NOW(), INTERVAL 20 DAY), DATE_SUB(NOW(), INTERVAL 20 DAY)),
(1, 'EM-2024-004', 'Cliente Demo', '987654321', 'Av. Ejemplo 123', 'Lima', 'tarjeta', 1299.00, 0.00, 1299.00, 'completed', DATE_SUB(NOW(), INTERVAL 15 DAY), DATE_SUB(NOW(), INTERVAL 15 DAY)),
(1, 'EM-2024-005', 'Cliente Demo', '987654321', 'Av. Ejemplo 123', 'Lima', 'efectivo', 1599.00, 0.00, 1599.00, 'completed', DATE_SUB(NOW(), INTERVAL 10 DAY), DATE_SUB(NOW(), INTERVAL 10 DAY)),
(1, 'EM-2024-006', 'Cliente Demo', '987654321', 'Av. Ejemplo 123', 'Lima', 'tarjeta', 159.00, 0.00, 159.00, 'completed', DATE_SUB(NOW(), INTERVAL 5 DAY), DATE_SUB(NOW(), INTERVAL 5 DAY));

-- Insertamos items de órdenes para simular ventas
INSERT INTO order_items (order_id, product_id, product_name, product_price, quantity, subtotal, created_at, updated_at) VALUES
-- Orden 1
(1, 1, 'Refrigeradora Samsung RF220NCTASL 220L', 1299.00, 1, 1299.00, DATE_SUB(NOW(), INTERVAL 30 DAY), DATE_SUB(NOW(), INTERVAL 30 DAY)),
-- Orden 2
(2, 4, 'Lavadora LG F1496TDP 14kg', 1899.00, 1, 1899.00, DATE_SUB(NOW(), INTERVAL 25 DAY), DATE_SUB(NOW(), INTERVAL 25 DAY)),
-- Orden 3
(3, 7, 'Cocina a Gas Bosch PRO445IX 6 Hornillas', 1799.00, 1, 1799.00, DATE_SUB(NOW(), INTERVAL 20 DAY), DATE_SUB(NOW(), INTERVAL 20 DAY)),
-- Orden 4
(4, 5, 'Lavadora Samsung WA16T6260BY 16kg', 1299.00, 1, 1299.00, DATE_SUB(NOW(), INTERVAL 15 DAY), DATE_SUB(NOW(), INTERVAL 15 DAY)),
-- Orden 5
(5, 2, 'Refrigeradora LG GT29BPP 260L', 1599.00, 1, 1599.00, DATE_SUB(NOW(), INTERVAL 10 DAY), DATE_SUB(NOW(), INTERVAL 10 DAY)),
-- Orden 6
(6, 10, 'Licuadora Oster BLSTMG-B00-013', 159.00, 1, 159.00, DATE_SUB(NOW(), INTERVAL 5 DAY), DATE_SUB(NOW(), INTERVAL 5 DAY)),
-- Más ventas para productos populares
(2, 1, 'Refrigeradora Samsung RF220NCTASL 220L', 1299.00, 2, 2598.00, DATE_SUB(NOW(), INTERVAL 25 DAY), DATE_SUB(NOW(), INTERVAL 25 DAY)),
(3, 4, 'Lavadora LG F1496TDP 14kg', 1899.00, 1, 1899.00, DATE_SUB(NOW(), INTERVAL 20 DAY), DATE_SUB(NOW(), INTERVAL 20 DAY)),
(4, 1, 'Refrigeradora Samsung RF220NCTASL 220L', 1299.00, 1, 1299.00, DATE_SUB(NOW(), INTERVAL 15 DAY), DATE_SUB(NOW(), INTERVAL 15 DAY)),
(5, 7, 'Cocina a Gas Bosch PRO445IX 6 Hornillas', 1799.00, 1, 1799.00, DATE_SUB(NOW(), INTERVAL 10 DAY), DATE_SUB(NOW(), INTERVAL 10 DAY));

-- Nota: Ajusta los IDs de órdenes y usuarios según tu base de datos actual
-- Este script creará productos de muestra con datos realistas para una tienda de electrodomésticos
