

<?php $__env->startSection('content'); ?>
<div class="products-page">
    <div class="breadcrumb">
        <a href="#inicio">Inicio</a>
        <span>/</span>
        <span>Productos</span>
    </div>
    
    <div class="products-layout">
        <aside class="sidebar">
            <div class="filter-section">
                <h3>Categorías</h3>
                <ul class="category-list">
                    <li><a href="#" class="category-link active" data-category="all">Todos los productos</a></li>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><a href="#" class="category-link" data-category="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            
            <div class="filter-section">
                <h3>Filtros</h3>
                <div class="price-filter">
                    <h4>Precio</h4>
                    <label>
                        <input type="checkbox" name="price_range" value="under_500"> Menos de S/ 500
                    </label>
                    <label>
                        <input type="checkbox" name="price_range" value="500_1000"> S/ 500 - S/ 1000
                    </label>
                    <label>
                        <input type="checkbox" name="price_range" value="1000_2000"> S/ 1000 - S/ 2000
                    </label>
                    <label>
                        <input type="checkbox" name="price_range" value="over_2000"> Más de S/ 2000
                    </label>
                </div>
                
                <div class="search-filter">
                    <h4>Buscar</h4>
                    <input type="text" id="search-input" placeholder="Buscar productos..." class="search-input">
                </div>
            </div>
        </aside>
        
        <main class="products-main">
            <div class="products-header">
                <h2 id="products-title">Todos los productos</h2>
                <div class="products-controls">
                    <div class="control-group">
                        <label>Mostrar:</label>
                        <select id="per-page-select">
                            <option value="12">12 por página</option>
                            <option value="24">24 por página</option>
                            <option value="36">36 por página</option>
                        </select>
                    </div>
                    <div class="control-group">
                        <label>Ordenar por precio</label>
                        <select id="sort-select">
                            <option value="">Seleccionar orden</option>
                            <option value="price_asc">Menor a mayor</option>
                            <option value="price_desc">Mayor a menor</option>
                            <option value="name_asc">Nombre A-Z</option>
                            <option value="name_desc">Nombre Z-A</option>
                        </select>
                    </div>
                </div>
            </div>
            
            <div id="loading-products" class="loading-indicator" style="display: none;">
                <p>Cargando productos...</p>
            </div>
            
            <div class="products-grid-detailed" id="products-container">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="product-card-detailed">
                    <div class="product-image">
                        <img src="<?php echo e($product->image); ?>" alt="<?php echo e($product->name); ?>">
                    </div>
                    <div class="product-details">
                        <h3><?php echo e($product->name); ?></h3>
                        <ul class="product-features">
                            <li><i class="fas fa-check"></i> <?php echo e($product->description); ?></li>
                        </ul>
                        <div class="price-info">
                            <span class="price"><?php echo e($product->formatted_price); ?></span>
                        </div>
                        <div class="product-actions">
                            <button class="btn btn-primary add-to-cart-btn" onclick="addToCart(<?php echo e($product->id); ?>, '<?php echo e($product->name); ?>', <?php echo e($product->price); ?>)">
                                <i class="fas fa-shopping-cart"></i> Agregar al Carrito
                            </button>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div id="pagination-container" class="pagination-container">
                <?php echo e($products->links()); ?>

            </div>
        </main>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
// URLs para AJAX
window.checkAuthUrl = "<?php echo e(route('check.auth')); ?>";
window.loginUrl = "<?php echo e(route('login')); ?>";
window.getCartCountUrl = "<?php echo e(route('cart.count')); ?>";
window.addToCartUrl = "<?php echo e(route('cart.add')); ?>";
window.filterProductsUrl = "<?php echo e(route('products.filter')); ?>";
window.getCategoriesUrl = "<?php echo e(route('categories.get')); ?>";

// Variables globales para filtros
let currentFilters = {
    category: 'all',
    priceRanges: [],
    search: '',
    sort: '',
    perPage: 12,
    page: 1
};

// Función para cargar productos con filtros
function loadProducts(resetPage = true) {
    if (resetPage) {
        currentFilters.page = 1;
    }
    
    const loadingIndicator = document.getElementById('loading-products');
    const productsContainer = document.getElementById('products-container');
    const paginationContainer = document.getElementById('pagination-container');
    
    loadingIndicator.style.display = 'block';
    
    const params = new URLSearchParams();
    
    // Agregar parámetros de filtro
    if (currentFilters.category !== 'all') {
        params.append('category', currentFilters.category);
    }
    
    if (currentFilters.priceRanges.length > 0) {
        currentFilters.priceRanges.forEach(range => {
            params.append('price_ranges[]', range);
        });
    }
    
    if (currentFilters.search) {
        params.append('search', currentFilters.search);
    }
    
    if (currentFilters.sort) {
        params.append('sort', currentFilters.sort);
    }
    
    params.append('per_page', currentFilters.perPage);
    params.append('page', currentFilters.page);
    
    fetch(`${window.filterProductsUrl}?${params.toString()}`, {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        loadingIndicator.style.display = 'none';
        
        if (data.success) {
            renderProducts(data.products);
            renderPagination(data.pagination);
        } else {
            console.error('Error al cargar productos:', data.message);
        }
    })
    .catch(error => {
        loadingIndicator.style.display = 'none';
        console.error('Error de red:', error);
    });
}

// Función para renderizar productos
function renderProducts(products) {
    const container = document.getElementById('products-container');
    
    if (products.length === 0) {
        container.innerHTML = '<div class="no-products"><p>No se encontraron productos con los filtros seleccionados.</p></div>';
        return;
    }
    
    container.innerHTML = products.map(product => `
        <div class="product-card-detailed">
            <div class="product-image">
                <img src="${product.image}" alt="${product.name}">
            </div>
            <div class="product-details">
                <h3>${product.name}</h3>
                <ul class="product-features">
                    <li><i class="fas fa-check"></i> ${product.description}</li>
                </ul>
                <div class="price-info">
                    <span class="price">${product.formatted_price}</span>
                </div>
                <div class="product-actions">
                    <button class="btn btn-primary add-to-cart-btn" onclick="addToCart(${product.id}, '${product.name}', ${product.price})">
                        <i class="fas fa-shopping-cart"></i> Agregar al Carrito
                    </button>
                </div>
            </div>
        </div>
    `).join('');
}

// Función para renderizar paginación
function renderPagination(pagination) {
    const container = document.getElementById('pagination-container');
    
    if (pagination.last_page <= 1) {
        container.innerHTML = '';
        return;
    }
    
    let paginationHTML = '<nav class="pagination">';
    
    // Botón anterior
    if (pagination.current_page > 1) {
        paginationHTML += `<button class="pagination-btn" onclick="changePage(${pagination.current_page - 1})">&laquo; Anterior</button>`;
    }
    
    // Números de página
    for (let i = 1; i <= pagination.last_page; i++) {
        if (i === pagination.current_page) {
            paginationHTML += `<button class="pagination-btn active">${i}</button>`;
        } else {
            paginationHTML += `<button class="pagination-btn" onclick="changePage(${i})">${i}</button>`;
        }
    }
    
    // Botón siguiente
    if (pagination.current_page < pagination.last_page) {
        paginationHTML += `<button class="pagination-btn" onclick="changePage(${pagination.current_page + 1})">Siguiente &raquo;</button>`;
    }
    
    paginationHTML += '</nav>';
    paginationHTML += `<div class="pagination-info">Mostrando ${pagination.from} a ${pagination.to} de ${pagination.total} productos</div>`;
    
    container.innerHTML = paginationHTML;
}

// Función para cambiar página
function changePage(page) {
    currentFilters.page = page;
    loadProducts(false);
    window.scrollTo({ top: 0, behavior: 'smooth' });
}

// Función para cargar categorías dinámicamente
function loadCategories() {
    fetch(window.getCategoriesUrl, {
        method: 'GET',
        headers: {
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            updateCategoriesList(data.categories);
        }
    })
    .catch(error => {
        console.error('Error al cargar categorías:', error);
    });
}

// Función para actualizar lista de categorías
function updateCategoriesList(categories) {
    const categoryList = document.querySelector('.category-list');
    const currentLinks = categoryList.innerHTML;
    
    // Solo actualizar si hay categorías nuevas
    if (categories.length > 0) {
        let categoryHTML = '<li><a href="#" class="category-link active" data-category="all">Todos los productos</a></li>';
        
        categories.forEach(category => {
            categoryHTML += `<li><a href="#" class="category-link" data-category="${category.id}">${category.name} (${category.products_count})</a></li>`;
        });
        
        categoryList.innerHTML = categoryHTML;
        setupCategoryListeners();
    }
}

// Configurar event listeners para categorías
function setupCategoryListeners() {
    document.querySelectorAll('.category-link').forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Remover clase active de todos los links
            document.querySelectorAll('.category-link').forEach(l => l.classList.remove('active'));
            
            // Agregar clase active al link clickeado
            this.classList.add('active');
            
            // Actualizar filtro y cargar productos
            currentFilters.category = this.dataset.category;
            updateProductsTitle(this.textContent);
            loadProducts();
        });
    });
}

// Actualizar título de productos
function updateProductsTitle(categoryName) {
    document.getElementById('products-title').textContent = categoryName;
}

// Configurar event listeners para filtros de precio
function setupPriceFilters() {
    document.querySelectorAll('input[name="price_range"]').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            const value = this.value;
            
            if (this.checked) {
                if (!currentFilters.priceRanges.includes(value)) {
                    currentFilters.priceRanges.push(value);
                }
            } else {
                const index = currentFilters.priceRanges.indexOf(value);
                if (index > -1) {
                    currentFilters.priceRanges.splice(index, 1);
                }
            }
            
            loadProducts();
        });
    });
}

// Configurar búsqueda con debounce
function setupSearch() {
    const searchInput = document.getElementById('search-input');
    let searchTimeout;
    
    searchInput.addEventListener('input', function() {
        clearTimeout(searchTimeout);
        
        searchTimeout = setTimeout(() => {
            currentFilters.search = this.value;
            loadProducts();
        }, 500); // Esperar 500ms después de que el usuario deje de escribir
    });
}

// Configurar controles de productos por página y ordenamiento
function setupProductControls() {
    const perPageSelect = document.getElementById('per-page-select');
    const sortSelect = document.getElementById('sort-select');
    
    perPageSelect.addEventListener('change', function() {
        currentFilters.perPage = parseInt(this.value);
        loadProducts();
    });
    
    sortSelect.addEventListener('change', function() {
        currentFilters.sort = this.value;
        loadProducts();
    });
}

// Función para agregar productos al carrito (mantener la original)
function addToCart(productId, productName, price) {
    const formData = new FormData();
    formData.append('product_id', productId);
    formData.append('quantity', 1);
    formData.append('_token', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));
    
    fetch(window.addToCartUrl, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    title: '¡Producto agregado!',
                    text: data.message,
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 1500,
                    position: 'top-end',
                    toast: true
                });
            }
            
            // Actualizar contador del carrito
            updateCartCounter(data.cart_count);
            
        } else {
            if (data.message.includes('iniciar sesión')) {
                // Usuario no logueado
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        title: 'Debes iniciar sesión',
                        text: data.message,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonText: 'Ir a Login',
                        cancelButtonText: 'Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = window.loginUrl;
                        }
                    });
                }
            } else {
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        title: 'Error',
                        text: data.message,
                        icon: 'error'
                    });
                }
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        if (typeof Swal !== 'undefined') {
            Swal.fire({
                title: 'Error',
                text: 'Error de conexión',
                icon: 'error'
            });
        }
    });
}

// Función para actualizar el contador del carrito
function updateCartCounter(count) {
    const cartCounter = document.querySelector('.cart-count');
    if (cartCounter) {
        cartCounter.textContent = count || 0;
    }
}

// Función para cargar el contador inicial del carrito
function loadCartCount() {
    fetch(window.getCartCountUrl, {
        method: 'GET',
        headers: {
            'Accept': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        updateCartCounter(data.count);
    })
    .catch(error => {
        console.error('Error al cargar contador:', error);
    });
}

// Inicializar cuando el documento esté listo
document.addEventListener('DOMContentLoaded', function() {
    console.log('Página de productos cargada correctamente');
    
    // Cargar contador inicial del carrito
    loadCartCount();
    
    // Configurar todos los event listeners
    setupCategoryListeners();
    setupPriceFilters();
    setupSearch();
    setupProductControls();
    
    // Cargar categorías dinámicamente
    loadCategories();
    
    console.log('Filtros AJAX inicializados correctamente');
});
</script>

<style>
/* Estilos adicionales para los filtros AJAX */
.loading-indicator {
    text-align: center;
    padding: 20px;
    font-style: italic;
    color: #666;
}

.search-input {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    margin-top: 5px;
}

.no-products {
    text-align: center;
    padding: 40px 20px;
    color: #666;
}

.pagination {
    display: flex;
    justify-content: center;
    gap: 5px;
    margin: 20px 0;
}

.pagination-btn {
    padding: 8px 12px;
    border: 1px solid #ddd;
    background: white;
    color: #333;
    cursor: pointer;
    border-radius: 4px;
    transition: all 0.3s ease;
}

.pagination-btn:hover {
    background: #f5f5f5;
}

.pagination-btn.active {
    background: #007bff;
    color: white;
    border-color: #007bff;
}

.pagination-info {
    text-align: center;
    color: #666;
    font-size: 14px;
    margin-top: 10px;
}

.price-filter label {
    display: block;
    margin-bottom: 8px;
    cursor: pointer;
    user-select: none;
}

.price-filter input[type="checkbox"] {
    margin-right: 8px;
}

.search-filter {
    margin-top: 20px;
}

.search-filter h4 {
    margin-bottom: 10px;
}
</style>
<?php echo $__env->make('include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/productos/index.blade.php ENDPATH**/ ?>