

<?php $__env->startSection('content'); ?>
<div class="auth-container">
    <div class="auth-card">
        <div class="auth-header">
            <div class="logo">
                <i class="fas fa-user-plus"></i>
                <h2>Crear Cuenta</h2>
                <p>Únete a ElectroMart y disfruta de beneficios exclusivos</p>
            </div>
        </div>

        <form id="registerForm" class="auth-form">
            <?php echo csrf_field(); ?>
            <div class="form-group">
                <label for="name">
                    <i class="fas fa-user"></i>
                    Nombre Completo
                </label>
                <input type="text" id="name" name="name" required placeholder="Ingresa tu nombre completo">
            </div>

            <div class="form-group">
                <label for="email">
                    <i class="fas fa-envelope"></i>
                    Correo Electrónico
                </label>
                <input type="email" id="email" name="email" required placeholder="Ingresa tu correo electrónico">
            </div>

            <div class="form-group">
                <label for="phone">
                    <i class="fas fa-phone"></i>
                    Teléfono (Opcional)
                </label>
                <input type="tel" id="phone" name="phone" placeholder="Ingresa tu número de teléfono">
            </div>

            <div class="form-group">
                <label for="password">
                    <i class="fas fa-lock"></i>
                    Contraseña
                </label>
                <input type="password" id="password" name="password" required placeholder="Mínimo 6 caracteres">
                <small class="password-hint">Debe tener al menos 6 caracteres</small>
            </div>

            <div class="form-group">
                <label for="password_confirmation">
                    <i class="fas fa-lock"></i>
                    Confirmar Contraseña
                </label>
                <input type="password" id="password_confirmation" name="password_confirmation" required placeholder="Repite tu contraseña">
            </div>

            <div class="form-group checkbox-group">
                <label class="checkbox-label">
                    <input type="checkbox" id="terms" required>
                    <span class="checkmark"></span>
                    Acepto los <a href="#" class="link">Términos y Condiciones</a> y la <a href="#" class="link">Política de Privacidad</a>
                </label>
            </div>

            <div class="form-group checkbox-group">
                <label class="checkbox-label">
                    <input type="checkbox" id="newsletter">
                    <span class="checkmark"></span>
                    Quiero recibir ofertas y promociones por correo electrónico
                </label>
            </div>

            <button type="submit" class="auth-btn" id="registerBtn">
                <i class="fas fa-user-plus"></i>
                Crear Mi Cuenta
            </button>
        </form>

        <div class="auth-footer">
            <p>¿Ya tienes una cuenta? <a href="<?php echo e(route('login')); ?>" class="link">Inicia Sesión</a></p>
        </div>

        <div class="benefits-section">
            <h3>Al unirte a ElectroMart obtienes:</h3>
            <ul class="benefits-list">
                <li><i class="fas fa-shipping-fast"></i> Envío gratis en compras mayores a S/ 200</li>
                <li><i class="fas fa-percent"></i> Descuentos exclusivos para miembros</li>
                <li><i class="fas fa-headset"></i> Soporte técnico especializado</li>
                <li><i class="fas fa-gift"></i> Ofertas especiales en tu cumpleaños</li>
            </ul>
        </div>
    </div>
</div>

<style>
.auth-container {
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 2rem 1rem;
}

.auth-card {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    box-shadow: 0 20px 40px rgba(0,0,0,0.1);
    width: 100%;
    max-width: 500px;
    animation: slideUp 0.6s ease-out;
}

@keyframes slideUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.auth-header {
    text-align: center;
    margin-bottom: 2rem;
}

.logo i {
    font-size: 3rem;
    color: #667eea;
    margin-bottom: 1rem;
}

.logo h2 {
    color: #333;
    margin: 0 0 0.5rem 0;
    font-size: 1.8rem;
}

.logo p {
    color: #666;
    margin: 0;
    font-size: 0.95rem;
}

.auth-form {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.form-group {
    position: relative;
}

.form-group label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 500;
    color: #333;
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
}

.form-group label i {
    color: #667eea;
    width: 16px;
}

.form-group input {
    width: 100%;
    padding: 12px 16px;
    border: 2px solid #e1e5e9;
    border-radius: 10px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-group input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.password-hint {
    color: #666;
    font-size: 0.8rem;
    margin-top: 0.25rem;
}

.checkbox-group {
    margin: 0.5rem 0;
}

.checkbox-label {
    display: flex;
    align-items: flex-start;
    gap: 0.75rem;
    cursor: pointer;
    font-size: 0.9rem;
    line-height: 1.4;
}

.checkbox-label input[type="checkbox"] {
    display: none;
}

.checkmark {
    width: 18px;
    height: 18px;
    border: 2px solid #ddd;
    border-radius: 4px;
    position: relative;
    flex-shrink: 0;
    margin-top: 1px;
    transition: all 0.3s ease;
}

.checkbox-label input[type="checkbox"]:checked + .checkmark {
    background: #667eea;
    border-color: #667eea;
}

.checkbox-label input[type="checkbox"]:checked + .checkmark::after {
    content: '✓';
    position: absolute;
    color: white;
    font-size: 12px;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}

.link {
    color: #667eea;
    text-decoration: none;
    font-weight: 500;
}

.link:hover {
    text-decoration: underline;
}

.auth-btn {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    padding: 14px 20px;
    border-radius: 10px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    margin-top: 1rem;
}

.auth-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
}

.auth-btn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
    transform: none;
}

.auth-footer {
    text-align: center;
    margin-top: 1.5rem;
    color: #666;
}

.benefits-section {
    margin-top: 2rem;
    padding-top: 1.5rem;
    border-top: 1px solid #eee;
}

.benefits-section h3 {
    color: #333;
    font-size: 1rem;
    margin-bottom: 1rem;
    text-align: center;
}

.benefits-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.benefits-list li {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.5rem 0;
    color: #555;
    font-size: 0.9rem;
}

.benefits-list li i {
    color: #28a745;
    width: 16px;
}

@media (max-width: 768px) {
    .auth-container {
        padding: 1rem 0.5rem;
    }
    
    .auth-card {
        padding: 1.5rem;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
document.getElementById('registerForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const btn = document.getElementById('registerBtn');
    const formData = new FormData(this);
    
    // Validar que las contraseñas coincidan
    const password = formData.get('password');
    const passwordConfirmation = formData.get('password_confirmation');
    
    if (password !== passwordConfirmation) {
        Swal.fire({
            title: 'Error',
            text: 'Las contraseñas no coinciden',
            icon: 'error',
            confirmButtonText: 'Entendido'
        });
        return;
    }
    
    // Validar términos y condiciones
    if (!document.getElementById('terms').checked) {
        Swal.fire({
            title: 'Términos y Condiciones',
            text: 'Debes aceptar los términos y condiciones para continuar',
            icon: 'warning',
            confirmButtonText: 'Entendido'
        });
        return;
    }
    
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Creando cuenta...';
    
    const data = Object.fromEntries(formData);
    
    fetch("<?php echo e(route('register.post')); ?>", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            Swal.fire({
                title: '¡Bienvenido a ElectroMart!',
                text: data.message,
                icon: 'success',
                confirmButtonText: 'Continuar'
            }).then(() => {
                window.location.href = data.redirect;
            });
        } else {
            Swal.fire({
                title: 'Error al registrarse',
                text: data.message,
                icon: 'error',
                confirmButtonText: 'Intentar de nuevo'
            });
            
            btn.disabled = false;
            btn.innerHTML = '<i class="fas fa-user-plus"></i> Crear Mi Cuenta';
        }
    })
    .catch(error => {
        console.error('Error:', error);
        Swal.fire({
            title: 'Error',
            text: 'Error de conexión. Inténtalo de nuevo.',
            icon: 'error',
            confirmButtonText: 'Reintentar'
        });
        
        btn.disabled = false;
        btn.innerHTML = '<i class="fas fa-user-plus"></i> Crear Mi Cuenta';
    });
});

// Validación en tiempo real de contraseñas
document.getElementById('password_confirmation').addEventListener('input', function() {
    const password = document.getElementById('password').value;
    const confirmation = this.value;
    
    if (confirmation && password !== confirmation) {
        this.style.borderColor = '#dc3545';
    } else {
        this.style.borderColor = '#e1e5e9';
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/auth/register.blade.php ENDPATH**/ ?>