

<?php $__env->startSection('title', 'Gestión del Blog'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <span class="breadcrumb-item">Contenido</span>
    <span class="breadcrumb-item active">Blog</span>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<!-- CSS de Summernote para el editor de texto -->
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

<style>
    /* Estilos para la cabecera del blog */
    .blog-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
    }
    
    .blog-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--gray-900);
    }
    
    /* Botón para crear nuevo post */
    .btn-create {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
        border: none;
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.3s ease;
    }
    
    .btn-create:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }
    
    /* Sección de filtros */
    .filter-section {
        background: white;
        border-radius: 12px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .filter-row {
        display: grid;
        grid-template-columns: 1fr 1fr 1fr auto;
        gap: 1rem;
        align-items: end;
    }
    
    .filter-group {
        display: flex;
        flex-direction: column;
    }
    
    .filter-label {
        font-weight: 600;
        margin-bottom: 0.5rem;
        color: var(--gray-700);
    }
    
    .filter-input, .filter-select {
        padding: 0.75rem;
        border: 2px solid var(--gray-200);
        border-radius: 8px;
        font-size: 0.875rem;
    }
    
    .btn-filter {
        background: var(--success-color);
        color: white;
        border: none;
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        cursor: pointer;
        height: fit-content;
    }
    
    /* Estilos de la tabla de posts */
    .blog-table {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    
    .table {
        width: 100%;
        margin-bottom: 0;
        color: var(--gray-700);
    }
    
    .table th {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
        font-weight: 600;
        padding: 1rem;
        text-align: left;
        border: none;
    }
    
    .table td {
        padding: 1rem;
        border-bottom: 1px solid var(--gray-100);
        vertical-align: middle;
    }
    
    .table tbody tr:hover {
        background-color: var(--gray-50);
    }
    
    /* Estilos para títulos y extractos de posts */
    .post-title {
        font-weight: 600;
        color: var(--gray-900);
        margin-bottom: 0.25rem;
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .post-excerpt {
        font-size: 0.875rem;
        color: var(--gray-600);
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    /* Distintivo para posts destacados */
    .featured-badge {
        display: inline-flex;
        align-items: center;
        gap: 0.25rem;
        background: var(--warning-color);
        color: white;
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
        border-radius: 12px;
        margin-top: 0.25rem;
    }
    
    /* Distintivo de categoría */
    .category-badge {
        background: var(--info-color);
        color: white;
        padding: 0.25rem 0.75rem;
        border-radius: 12px;
        font-size: 0.875rem;
        font-weight: 500;
    }
    
    /* Distintivos de estado del post */
    .status-badge {
        padding: 0.25rem 0.75rem;
        border-radius: 12px;
        font-size: 0.875rem;
        font-weight: 500;
        text-transform: capitalize;
    }
    
    .status-publicado {
        background: var(--success-color);
        color: white;
    }
    
    .status-borrador {
        background: var(--gray-400);
        color: white;
    }
    
    .status-programado {
        background: var(--warning-color);
        color: white;
    }
    
    /* Botones de acción para cada post */
    .action-buttons {
        display: flex;
        gap: 0.5rem;
    }
    
    .btn-action {
        width: 32px;
        height: 32px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.2s ease;
    }
    
    .btn-star {
        background: var(--gray-100);
        color: var(--gray-600);
    }
    
    .btn-star.featured {
        background: var(--warning-color);
        color: white;
    }
    
    .btn-edit {
        background: var(--info-color);
        color: white;
    }
    
    .btn-delete {
        background: var(--danger-color);
        color: white;
    }
    
    .btn-action:hover {
        transform: scale(1.1);
    }
    
    /* Estado vacío cuando no hay posts */
    .empty-state {
        text-align: center;
        padding: 3rem;
        color: var(--gray-500);
    }
    
    .empty-state i {
        font-size: 3rem;
        margin-bottom: 1rem;
        color: var(--gray-300);
    }
    
    /* Estilos del modal */
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        justify-content: center;
        align-items: center;
    }
    
    .modal-content {
        background: white;
        border-radius: 12px;
        width: 90%;
        max-width: 800px;
        max-height: 90vh;
        overflow-y: auto;
        box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
    }
    
    .modal-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem;
        border-bottom: 1px solid var(--gray-200);
    }
    
    .modal-title {
        font-size: 1.25rem;
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .close-btn {
        background: none;
        border: none;
        font-size: 1.5rem;
        cursor: pointer;
        color: var(--gray-500);
        padding: 0.5rem;
        border-radius: 6px;
        transition: all 0.2s ease;
    }
    
    .close-btn:hover {
        background: var(--gray-100);
    }
    
    .modal-body {
        padding: 1.5rem;
    }
    
    /* Estilos de formulario */
    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1rem;
        margin-bottom: 1rem;
    }
    
    .form-group {
        margin-bottom: 1rem;
    }
    
    .form-label {
        display: block;
        font-weight: 600;
        margin-bottom: 0.5rem;
        color: var(--gray-700);
    }
    
    .form-input, .form-textarea, .form-select {
        width: 100%;
        padding: 0.75rem;
        border: 2px solid var(--gray-200);
        border-radius: 8px;
        font-size: 0.875rem;
        transition: border-color 0.2s ease;
    }
    
    .form-input:focus, .form-textarea:focus, .form-select:focus {
        outline: none;
        border-color: var(--primary-color);
    }
    
    .form-checkbox {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-top: 1rem;
    }
    
    .modal-footer {
        display: flex;
        justify-content: flex-end;
        gap: 1rem;
        padding: 1.5rem;
        border-top: 1px solid var(--gray-200);
    }
    
    .btn-secondary {
        background: var(--gray-100);
        color: var(--gray-700);
        border: none;
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        cursor: pointer;
        font-weight: 600;
    }
    
    .btn-primary {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
        border: none;
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        cursor: pointer;
        font-weight: 600;
    }
    
    .btn-secondary:hover, .btn-primary:hover {
        transform: translateY(-1px);
    }
    
    /* Diseño responsivo para móviles */
    @media (max-width: 768px) {
        .filter-row {
            grid-template-columns: 1fr;
        }
        
        .form-row {
            grid-template-columns: 1fr;
        }
        
        .modal-content {
            width: 95%;
            margin: 1rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="blog-container">
    <!-- Cabecera del blog -->
    <div class="blog-header">
        <h1 class="blog-title">Gestión del Blog</h1>
        <button class="btn-create" onclick="abrirModalCrear()">
            <i class="fas fa-plus"></i>
            Nuevo Post
        </button>
    </div>
    
    <!-- Sección de filtros -->
    <div class="filter-section">
        <div class="filter-row">
            <div class="filter-group">
                <label class="filter-label">Buscar Post</label>
                <input type="text" id="buscarPost" class="filter-input" placeholder="Buscar por título o contenido...">
            </div>
            <div class="filter-group">
                <label class="filter-label">Categoría</label>
                <select id="filtroCategoria" class="filter-select">
                    <option value="">Todas las categorías</option>
                </select>
            </div>
            <div class="filter-group">
                <label class="filter-label">Estado</label>
                <select id="filtroEstado" class="filter-select">
                    <option value="">Todos los estados</option>
                    <option value="publicado">Publicado</option>
                    <option value="borrador">Borrador</option>
                    <option value="programado">Programado</option>
                </select>
            </div>
            <button class="btn-filter" onclick="aplicarFiltros()">
                <i class="fas fa-filter"></i>
                Filtrar
            </button>
        </div>
    </div>
    
    <!-- Tabla de posts del blog -->
    <div class="blog-table">
        <table class="table">
            <thead>
                <tr>
                    <th>Post</th>
                    <th>Categoría</th>
                    <th>Autor</th>
                    <th>Estado</th>
                    <th>Vistas</th>
                    <th>Fecha</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="tablaPostsBody">
                <!-- Los posts se cargan aquí mediante JavaScript -->
            </tbody>
        </table>
    </div>
</div>

<!-- Modal para crear/editar posts -->
<div id="modalBlog" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h2 id="tituloModal" class="modal-title">Nuevo Post</h2>
            <button class="close-btn" onclick="cerrarModal()">×</button>
        </div>
        
        <div class="modal-body">
            <form id="formularioPost">
                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">Título *</label>
                        <input type="text" id="tituloPost" name="title" class="form-input" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Categoría *</label>
                        <input type="text" id="categoriaPost" name="category" class="form-input" required>
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">Autor *</label>
                        <input type="text" id="autorPost" name="author" class="form-input" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Estado</label>
                        <select id="estadoPost" name="status" class="form-select">
                            <option value="borrador">Borrador</option>
                            <option value="publicado">Publicado</option>
                            <option value="programado">Programado</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">URL de Imagen</label>
                    <input type="url" id="imagenPost" name="image_url" class="form-input">
                </div>
                
                <div class="form-group">
                    <label class="form-label">Extracto</label>
                    <textarea id="extractoPost" name="excerpt" class="form-textarea" rows="3"></textarea>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Contenido *</label>
                    <textarea id="contenidoPost" name="content"></textarea>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label class="form-label">Fecha de Publicación</label>
                        <input type="datetime-local" id="fechaPublicacion" name="published_at" class="form-input">
                    </div>
                    <div class="form-group">
                        <label class="form-label">Meta Título (SEO)</label>
                        <input type="text" id="metaTitulo" name="meta_title" class="form-input">
                    </div>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Meta Descripción (SEO)</label>
                    <textarea id="metaDescripcion" name="meta_description" class="form-textarea" rows="2"></textarea>
                </div>
                
                <div class="form-checkbox">
                    <input type="checkbox" id="postDestacado" name="featured">
                    <label for="postDestacado">Marcar como destacado</label>
                </div>
            </form>
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn-secondary" onclick="cerrarModal()">Cancelar</button>
            <button type="button" class="btn-primary" onclick="guardarPost()">Guardar Post</button>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- jQuery (necesario para Summernote) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- JavaScript de Summernote -->
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Variables globales
let idPostActual = null; // ID del post que se está editando
let modoEdicion = false; // Si estamos editando o creando
let todosLosPosts = []; // Array con todos los posts

// Función que se ejecuta cuando se carga la página
document.addEventListener('DOMContentLoaded', function() {
    // Cargar los posts desde el servidor
    cargarPosts();
    // Cargar las categorías para los filtros
    cargarCategorias();
    
    // Inicializar el editor Summernote
    $('#contenidoPost').summernote({
        height: 300, // Altura del editor
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'clear']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture', 'video']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ]
    });
    
    // Agregar evento para el campo de búsqueda
    const campoBusqueda = document.getElementById('buscarPost');
    if (campoBusqueda) {
        campoBusqueda.addEventListener('input', aplicarFiltros);
    }
});

// Función para cargar todos los posts desde el servidor
async function cargarPosts() {
    try {
        console.log('Cargando posts...');
        const respuesta = await fetch('<?php echo e(route("admin.blog.data")); ?>');
        const resultado = await respuesta.json();
        
        const cuerpoTabla = document.getElementById('tablaPostsBody');
        
        if (resultado.success && resultado.data.length > 0) {
            // Si hay posts, guardarlos y mostrarlos
            todosLosPosts = resultado.data;
            mostrarPosts(todosLosPosts);
            console.log('Posts cargados exitosamente:', todosLosPosts.length);
        } else {
            // Si no hay posts, mostrar mensaje vacío
            cuerpoTabla.innerHTML = `
                <tr>
                    <td colspan="7">
                        <div class="empty-state">
                            <i class="fas fa-blog"></i>
                            <p>No hay posts registrados</p>
                            <button class="btn-create" onclick="abrirModalCrear()" style="margin-top: 1rem;">
                                <i class="fas fa-plus"></i>
                                Crear Primer Post
                            </button>
                        </div>
                    </td>
                </tr>
            `;
            console.log('No se encontraron posts');
        }
    } catch (error) {
        console.error('Error al cargar posts:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Error al cargar los posts. Revisa la consola para más detalles.'
        });
    }
}

// Función para mostrar los posts en la tabla
function mostrarPosts(posts) {
    const cuerpoTabla = document.getElementById('tablaPostsBody');
    
    // Generar HTML para cada post
    cuerpoTabla.innerHTML = posts.map(post => `
        <tr>
            <td>
                <div class="post-title" title="${post.title}">${post.title}</div>
                <div class="post-excerpt" title="${post.excerpt || ''}">${post.excerpt || 'Sin extracto'}</div>
                ${post.featured ? '<span class="featured-badge"><i class="fas fa-star"></i> Destacado</span>' : ''}
            </td>
            <td>
                <span class="category-badge">${post.category}</span>
            </td>
            <td>${post.author}</td>
            <td>
                <span class="status-badge status-${post.status}">${post.status}</span>
            </td>
            <td>${post.views_count || 0}</td>
            <td>${post.published_at || post.created_at}</td>
            <td>
                <div class="action-buttons">
                    <button class="btn-action btn-star ${post.featured ? 'featured' : ''}" onclick="cambiarDestacado(${post.id})" title="${post.featured ? 'Quitar destacado' : 'Marcar destacado'}">
                        <i class="fas fa-star"></i>
                    </button>
                    <button class="btn-action btn-edit" onclick="editarPost(${post.id})" title="Editar">
                        <i class="fas fa-edit"></i>
                    </button>
                    <button class="btn-action btn-delete" onclick="eliminarPost(${post.id})" title="Eliminar">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </td>
        </tr>
    `).join('');
}

// Función para cargar las categorías disponibles
async function cargarCategorias() {
    try {
        const respuesta = await fetch('<?php echo e(route("admin.blog.categories")); ?>');
        const resultado = await respuesta.json();
        
        if (resultado.success) {
            const selectorCategoria = document.getElementById('filtroCategoria');
            selectorCategoria.innerHTML = '<option value="">Todas las categorías</option>';
            
            // Agregar cada categoría al selector
            resultado.data.forEach(categoria => {
                selectorCategoria.innerHTML += `<option value="${categoria}">${categoria}</option>`;
            });
        }
    } catch (error) {
        console.error('Error al cargar categorías:', error);
    }
}

// Función para aplicar filtros de búsqueda
function aplicarFiltros() {
    const terminoBusqueda = document.getElementById('buscarPost').value.toLowerCase();
    const filtroCategoria = document.getElementById('filtroCategoria').value;
    const filtroEstado = document.getElementById('filtroEstado').value;
    
    // Filtrar posts según los criterios
    let postsFiltrados = todosLosPosts.filter(post => {
        const coincideBusqueda = !terminoBusqueda || 
            post.title.toLowerCase().includes(terminoBusqueda) ||
            (post.content && post.content.toLowerCase().includes(terminoBusqueda)) ||
            (post.excerpt && post.excerpt.toLowerCase().includes(terminoBusqueda));
        
        const coincideCategoria = !filtroCategoria || post.category === filtroCategoria;
        const coincideEstado = !filtroEstado || post.status === filtroEstado;
        
        return coincideBusqueda && coincideCategoria && coincideEstado;
    });
    
    mostrarPosts(postsFiltrados);
}

// Función para abrir modal de creación
function abrirModalCrear() {
    modoEdicion = false;
    idPostActual = null;
    document.getElementById('tituloModal').textContent = 'Nuevo Post';
    document.getElementById('formularioPost').reset();
    $('#contenidoPost').summernote('code', '');
    document.getElementById('modalBlog').style.display = 'flex';
}

// Función para cerrar el modal
function cerrarModal() {
    document.getElementById('modalBlog').style.display = 'none';
    document.getElementById('formularioPost').reset();
    $('#contenidoPost').summernote('code', '');
    modoEdicion = false;
    idPostActual = null;
}

// Función para editar un post existente
async function editarPost(id) {
    try {
        console.log('Cargando post para editar:', id);
        const respuesta = await fetch('<?php echo e(route("admin.blog.show", ":id")); ?>'.replace(':id', id));
        const resultado = await respuesta.json();
        
        if (resultado.success) {
            const post = resultado.data;
            modoEdicion = true;
            idPostActual = id;
            
            // Llenar el formulario con los datos del post
            document.getElementById('tituloModal').textContent = 'Editar Post';
            document.getElementById('tituloPost').value = post.title || '';
            document.getElementById('categoriaPost').value = post.category || '';
            document.getElementById('autorPost').value = post.author || '';
            document.getElementById('estadoPost').value = post.status || 'borrador';
            document.getElementById('imagenPost').value = post.image_url || '';
            document.getElementById('extractoPost').value = post.excerpt || '';
            $('#contenidoPost').summernote('code', post.content || '');
            document.getElementById('fechaPublicacion').value = post.published_at || '';
            document.getElementById('metaTitulo').value = post.meta_title || '';
            document.getElementById('metaDescripcion').value = post.meta_description || '';
            document.getElementById('postDestacado').checked = post.featured || false;
            
            // Mostrar el modal
            document.getElementById('modalBlog').style.display = 'flex';
        }
    } catch (error) {
        console.error('Error al cargar post:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Error al cargar el post'
        });
    }
}

// Función para guardar post (crear nuevo o actualizar existente)
async function guardarPost() {
    // Obtener datos del formulario
    const titulo = document.getElementById('tituloPost').value.trim();
    const categoria = document.getElementById('categoriaPost').value.trim();
    const autor = document.getElementById('autorPost').value.trim();
    const contenido = $('#contenidoPost').summernote('code');
    
    // Validar campos obligatorios
    if (!titulo || !categoria || !autor || !contenido.trim()) {
        Swal.fire({
            icon: 'warning',
            title: 'Campos requeridos',
            text: 'Por favor completa todos los campos obligatorios'
        });
        return;
    }
    
    // Preparar datos para enviar
    const datos = {
        title: titulo,
        category: categoria,
        author: autor,
        content: contenido,
        status: document.getElementById('estadoPost').value,
        image_url: document.getElementById('imagenPost').value.trim() || null,
        excerpt: document.getElementById('extractoPost').value.trim() || null,
        published_at: document.getElementById('fechaPublicacion').value || null,
        meta_title: document.getElementById('metaTitulo').value.trim() || null,
        meta_description: document.getElementById('metaDescripcion').value.trim() || null,
        featured: document.getElementById('postDestacado').checked
    };
    
    try {
        let url, metodo;
        if (modoEdicion) {
            // Actualizar post existente
            url = '<?php echo e(route("admin.blog.update", ":id")); ?>'.replace(':id', idPostActual);
            metodo = 'PUT';
        } else {
            // Crear nuevo post
            url = '<?php echo e(route("admin.blog.store")); ?>';
            metodo = 'POST';
        }
        
        console.log('Guardando post:', metodo, url, datos);
        
        const respuesta = await fetch(url, {
            method: metodo,
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(datos)
        });
        
        const resultado = await respuesta.json();
        
        if (resultado.success) {
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: resultado.message || 'Post guardado exitosamente',
                timer: 2000,
                showConfirmButton: false
            });
            cerrarModal();
            cargarPosts(); // Recargar la lista de posts
        } else {
            // Mostrar errores de validación si existen
            let mensajeError = resultado.message;
            if (resultado.errors) {
                mensajeError = Object.values(resultado.errors).flat().join('\n');
            }
            Swal.fire({
                icon: 'error',
                title: 'Error de validación',
                text: mensajeError
            });
        }
    } catch (error) {
        console.error('Error al guardar post:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Error al guardar el post'
        });
    }
}

// Función para cambiar el estado destacado de un post
async function cambiarDestacado(id) {
    try {
        const respuesta = await fetch('<?php echo e(route("admin.blog.toggle-featured", ":id")); ?>'.replace(':id', id), {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });
        
        const resultado = await respuesta.json();
        
        if (resultado.success) {
            cargarPosts(); // Recargar para mostrar cambios
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: resultado.message
            });
        }
    } catch (error) {
        console.error('Error al cambiar estado destacado:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Error al cambiar el estado destacado'
        });
    }
}

// Función para eliminar un post
async function eliminarPost(id) {
    const result = await Swal.fire({
        title: '¿Estás seguro?',
        text: '¿Deseas eliminar este post? Esta acción no se puede deshacer.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    });

    if (!result.isConfirmed) {
        return;
    }
    
    try {
        const respuesta = await fetch('<?php echo e(route("admin.blog.destroy", ":id")); ?>'.replace(':id', id), {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });
        
        const resultado = await respuesta.json();
        
        if (resultado.success) {
            Swal.fire({
                icon: 'success',
                title: 'Eliminado',
                text: resultado.message || 'Post eliminado exitosamente',
                timer: 2000,
                showConfirmButton: false
            });
            cargarPosts(); // Recargar la lista
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: resultado.message
            });
        }
    } catch (error) {
        console.error('Error al eliminar post:', error);
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Error al eliminar el post'
        });
    }
}

// Cerrar modal al hacer clic fuera del contenido
document.getElementById('modalBlog').addEventListener('click', function(e) {
    if (e.target === this) {
        cerrarModal();
    }
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('administrador.include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/administrador/blog/index.blade.php ENDPATH**/ ?>