

<?php $__env->startSection('title', 'Gestión de Cotizaciones'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <span class="breadcrumb-item">Ventas</span>
    <span class="breadcrumb-item active">Cotizaciones</span>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .quotes-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
    }
    
    .quotes-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .quotes-table {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    
    .table-responsive {
        overflow-x: auto;
    }
    
    .table {
        width: 100%;
        margin-bottom: 0;
        color: var(--gray-700);
    }
    
    .table thead th {
        background: var(--gray-50);
        border-bottom: 1px solid var(--gray-200);
        padding: 1rem;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        color: var(--gray-600);
    }
    
    .table tbody td {
        padding: 1rem;
        border-bottom: 1px solid var(--gray-100);
        vertical-align: middle;
    }
    
    .table tbody tr:hover {
        background: var(--gray-25);
    }
    
    .quote-number {
        font-family: 'Monaco', 'Menlo', monospace;
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .customer-info {
        display: flex;
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .customer-name {
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .customer-email {
        font-size: 0.875rem;
        color: var(--gray-600);
    }
    
    .product-info {
        display: flex;
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .product-name {
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .product-category {
        font-size: 0.875rem;
        color: var(--gray-600);
    }
    
    .quote-quantity {
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .quote-budget {
        font-weight: 600;
        color: #10b981;
    }
    
    .status-badge {
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        white-space: nowrap;
    }
    
    .badge-warning { background: rgba(237, 137, 54, 0.1); color: #ed8936; }
    .badge-info { background: rgba(66, 153, 225, 0.1); color: #4299e1; }
    .badge-success { background: rgba(72, 187, 120, 0.1); color: #48bb78; }
    .badge-secondary { background: rgba(113, 128, 150, 0.1); color: #718096; }
    .badge-danger { background: rgba(245, 101, 101, 0.1); color: #f56565; }
    .badge-light { background: rgba(113, 128, 150, 0.1); color: #718096; }
    
    .priority-badge {
        padding: 0.25rem 0.5rem;
        border-radius: 12px;
        font-size: 0.75rem;
        font-weight: 600;
        margin-left: 0.5rem;
    }
    
    .quote-date {
        display: flex;
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .date-full {
        font-weight: 600;
        color: var(--gray-900);
        font-size: 0.875rem;
    }
    
    .date-relative {
        color: var(--gray-600);
        font-size: 0.75rem;
    }
    
    .action-buttons {
        display: flex;
        gap: 0.5rem;
        align-items: center;
    }
    
    .btn-action {
        padding: 0.5rem;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        font-size: 0.875rem;
        transition: all 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 36px;
        height: 36px;
    }
    
    .btn-view {
        background: rgba(66, 153, 225, 0.1);
        color: #4299e1;
    }
    
    .btn-view:hover {
        background: rgba(66, 153, 225, 0.2);
        transform: translateY(-1px);
    }
    
    .btn-edit {
        background: rgba(102, 126, 234, 0.1);
        color: #667eea;
    }
    
    .btn-edit:hover {
        background: rgba(102, 126, 234, 0.2);
        transform: translateY(-1px);
    }
    
    .btn-priority {
        background: rgba(237, 137, 54, 0.1);
        color: #ed8936;
    }
    
    .btn-priority:hover {
        background: rgba(237, 137, 54, 0.2);
        transform: translateY(-1px);
    }
    
    .btn-delete {
        background: rgba(245, 101, 101, 0.1);
        color: #f56565;
    }
    
    .btn-delete:hover {
        background: rgba(245, 101, 101, 0.2);
        transform: translateY(-1px);
    }
    
    .stats-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        margin-bottom: 2rem;
    }
    
    .stat-card {
        background: white;
        padding: 1.5rem;
        border-radius: 12px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        border-left: 4px solid #667eea;
    }
    
    .stat-card.warning { border-left-color: #ed8936; }
    .stat-card.info { border-left-color: #4299e1; }
    .stat-card.success { border-left-color: #48bb78; }
    .stat-card.secondary { border-left-color: #718096; }
    
    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        color: var(--gray-900);
        margin-bottom: 0.5rem;
    }
    
    .stat-label {
        color: var(--gray-600);
        font-size: 0.875rem;
    }
    
    .loading-skeleton {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: loading 1.5s infinite;
        border-radius: 4px;
        height: 20px;
        margin-bottom: 10px;
    }
    
    @keyframes loading {
        0% { background-position: 200% 0; }
        100% { background-position: -200% 0; }
    }
    
    .empty-state {
        text-align: center;
        padding: 3rem 1rem;
        color: var(--gray-500);
    }
    
    .empty-state i {
        font-size: 3rem;
        margin-bottom: 1rem;
        opacity: 0.5;
    }
    
    .table-filters {
        background: white;
        padding: 1.5rem;
        border-radius: 12px;
        margin-bottom: 1.5rem;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    
    .filters-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
        align-items: end;
    }
    
    .filter-group {
        display: flex;
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .filter-label {
        font-size: 0.875rem;
        font-weight: 600;
        color: var(--gray-700);
    }
    
    .filter-input {
        padding: 0.75rem;
        border: 2px solid var(--gray-200);
        border-radius: 6px;
        font-size: 0.875rem;
        transition: border-color 0.2s;
    }
    
    .filter-input:focus {
        outline: none;
        border-color: #667eea;
    }
    
    .btn-filter {
        background: #667eea;
        color: white;
        border: none;
        padding: 0.75rem 1.5rem;
        border-radius: 6px;
        cursor: pointer;
        font-weight: 600;
        transition: all 0.2s;
    }
    
    .btn-filter:hover {
        background: #5a67d8;
        transform: translateY(-1px);
    }
    
    @media (max-width: 768px) {
        .quotes-header {
            flex-direction: column;
            gap: 1rem;
            align-items: stretch;
        }
        
        .stats-container {
            grid-template-columns: 1fr;
        }
        
        .table-responsive {
            font-size: 0.875rem;
        }
        
        .customer-info,
        .product-info,
        .quote-date {
            font-size: 0.875rem;
        }
        
        .action-buttons {
            flex-direction: column;
            gap: 0.25rem;
        }
    }
    
    /* Estilos para SweetAlert modals */
    .swal2-popup .form-group {
        text-align: left;
        margin-bottom: 1rem;
    }
    
    .swal2-popup .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 600;
        color: #374151;
    }
    
    .swal2-popup .form-control {
        width: 100%;
        padding: 0.75rem;
        border: 2px solid #d1d5db;
        border-radius: 0.375rem;
        font-size: 1rem;
        transition: border-color 0.2s;
    }
    
    .swal2-popup .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    
    /* Estilos para SweetAlert modals */
    .swal2-popup .form-group {
        text-align: left;
        margin-bottom: 1rem;
    }
    
    .swal2-popup .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 600;
        color: #374151;
    }
    
    .swal2-popup .form-control {
        width: 100%;
        padding: 0.75rem;
        border: 2px solid #d1d5db;
        border-radius: 0.375rem;
        font-size: 1rem;
        transition: border-color 0.2s;
    }
    
    .swal2-popup .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    
    /* Estilos para SweetAlert modals */
    .swal2-popup .form-group {
        text-align: left;
        margin-bottom: 1rem;
    }
    
    .swal2-popup .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 600;
        color: #374151;
    }
    
    .swal2-popup .form-control {
        width: 100%;
        padding: 0.75rem;
        border: 2px solid #d1d5db;
        border-radius: 0.375rem;
        font-size: 1rem;
        transition: border-color 0.2s;
    }
    
    .swal2-popup .form-control:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="quotes-container">
    <!-- Header -->
    <div class="quotes-header">
        <h1 class="quotes-title">
            <i class="fas fa-file-invoice-dollar mr-2" style="color: #667eea;"></i>
            Gestión de Cotizaciones
        </h1>
    </div>
    
    <!-- Estadísticas -->
    <div class="stats-container" id="statsContainer">
        <div class="stat-card warning">
            <div class="stat-number" id="totalPendientes">-</div>
            <div class="stat-label">Pendientes</div>
        </div>
        <div class="stat-card info">
            <div class="stat-number" id="totalProcesando">-</div>
            <div class="stat-label">Procesando</div>
        </div>
        <div class="stat-card success">
            <div class="stat-number" id="totalEnviados">-</div>
            <div class="stat-label">Enviados</div>
        </div>
        <div class="stat-card secondary">
            <div class="stat-number" id="totalCerrados">-</div>
            <div class="stat-label">Cerrados</div>
        </div>
    </div>
    
    <!-- Filtros -->
    <div class="table-filters">
        <div class="filters-row">
            <div class="filter-group">
                <label class="filter-label">Buscar por cliente</label>
                <input type="text" id="searchCustomer" class="filter-input" placeholder="Nombre o email">
            </div>
            <div class="filter-group">
                <label class="filter-label">Producto</label>
                <input type="text" id="searchProduct" class="filter-input" placeholder="Nombre del producto">
            </div>
            <div class="filter-group">
                <label class="filter-label">Estado</label>
                <select id="filterStatus" class="filter-input">
                    <option value="">Todos los estados</option>
                    <option value="pendiente">Pendiente</option>
                    <option value="procesando">Procesando</option>
                    <option value="enviado">Enviado</option>
                    <option value="cerrado">Cerrado</option>
                </select>
            </div>
            <div class="filter-group">
                <label class="filter-label">Prioridad</label>
                <select id="filterPriority" class="filter-input">
                    <option value="">Todas las prioridades</option>
                    <option value="alta">Alta</option>
                    <option value="media">Media</option>
                    <option value="baja">Baja</option>
                </select>
            </div>
            <div class="filter-group">
                <button class="btn-filter" onclick="applyFilters()">
                    <i class="fas fa-search mr-1"></i>
                    Filtrar
                </button>
            </div>
        </div>
    </div>
    
    <!-- Tabla de Cotizaciones -->
    <div class="quotes-table">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Cliente</th>
                        <th>Producto</th>
                        <th>Cantidad</th>
                        <th>Presupuesto</th>
                        <th>Estado</th>
                        <th>Prioridad</th>
                        <th>Fecha</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="quotesTableBody">
                    <!-- Skeleton Loading -->
                    <tr>
                        <td colspan="9">
                            <div class="loading-skeleton"></div>
                            <div class="loading-skeleton"></div>
                            <div class="loading-skeleton"></div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal para Ver Detalles -->
<div id="quoteModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            
            <div class="modal-body" id="quoteModalBody">
                <!-- Contenido cargado dinámicamente -->
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let quotesData = [];
let filteredQuotes = [];

// Cargar datos al iniciar
document.addEventListener('DOMContentLoaded', function() {
    console.log('🚀 Iniciando gestión de cotizaciones...');
    loadStats();
    loadQuotes();
});

// Cargar estadísticas
async function loadStats() {
    try {
        console.log('📊 Cargando estadísticas...');
        
        const response = await fetch('<?php echo e(route("admin.quotes.stats")); ?>');
        const result = await response.json();
        
        if (result.success) {
            const data = result.data;
            document.getElementById('totalPendientes').textContent = data.pendientes || 0;
            document.getElementById('totalProcesando').textContent = data.procesando || 0;
            document.getElementById('totalEnviados').textContent = data.enviados || 0;
            document.getElementById('totalCerrados').textContent = data.cerrados || 0;
            console.log('✅ Estadísticas cargadas');
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('❌ Error al cargar estadísticas:', error);
        document.querySelectorAll('.stat-number').forEach(el => el.textContent = 'Error');
    }
}

// Cargar cotizaciones
async function loadQuotes() {
    try {
        console.log('📋 Cargando cotizaciones...');
        
        const response = await fetch('<?php echo e(route("admin.quotes.data")); ?>');
        const result = await response.json();
        
        if (result.success) {
            quotesData = result.data;
            filteredQuotes = [...quotesData];
            renderQuotes();
            console.log('✅ Cotizaciones cargadas:', quotesData.length);
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('❌ Error al cargar cotizaciones:', error);
        showError('Error al cargar las cotizaciones');
    }
}

// Renderizar cotizaciones
function renderQuotes() {
    const tbody = document.getElementById('quotesTableBody');
    
    if (filteredQuotes.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="9" class="empty-state">
                    <i class="fas fa-file-invoice-dollar"></i>
                    <p>No se encontraron cotizaciones</p>
                </td>
            </tr>
        `;
        return;
    }
    
    tbody.innerHTML = filteredQuotes.map(quote => `
        <tr>
            <td>
                <span class="quote-number">#${quote.id}</span>
            </td>
            <td>
                <div class="customer-info">
                    <span class="customer-name">${quote.name}</span>
                    <span class="customer-email">${quote.email}</span>
                    <span class="customer-email">${quote.phone || 'Sin teléfono'}</span>
                </div>
            </td>
            <td>
                <div class="product-info">
                    <span class="product-name">${quote.product_name}</span>
                    <span class="product-category">${quote.product_category || 'Sin categoría'}</span>
                </div>
            </td>
            <td>
                <span class="quote-quantity">${quote.quantity || 'No especificado'}</span>
            </td>
            <td>
                <span class="quote-budget">${quote.budget_range || 'No especificado'}</span>
            </td>
            <td>
                <span class="status-badge ${quote.status_class}">${quote.status_name}</span>
            </td>
            <td>
                <span class="status-badge ${quote.priority_class}">${quote.priority || 'Media'}</span>
            </td>
            <td>
                <div class="quote-date">
                    <span class="date-full">${quote.created_at}</span>
                    <span class="date-relative">${quote.created_at_human}</span>
                </div>
            </td>
            <td>
                <div class="action-buttons">
                    <button class="btn-action btn-view" onclick="viewQuote(${quote.id})" title="Ver detalles">
                        <i class="fas fa-eye"></i>
                    </button>
                    <button class="btn-action btn-edit" onclick="changeStatus(${quote.id}, '${quote.status}')" title="Cambiar estado">
                        <i class="fas fa-edit"></i>
                    </button>
                    <button class="btn-action btn-priority" onclick="changePriority(${quote.id}, '${quote.priority}')" title="Cambiar prioridad">
                        <i class="fas fa-flag"></i>
                    </button>
                    <button class="btn-action btn-delete" onclick="deleteQuote(${quote.id})" title="Eliminar">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            </td>
        </tr>
    `).join('');
}

// Ver detalles de cotización
async function viewQuote(id) {
    try {
        console.log('👁️ Viendo cotización:', id);
        
        const response = await fetch(`<?php echo e(url('administrador/quotes')); ?>/${id}`);
        const result = await response.json();
        
        if (result.success) {
            const quote = result.data;
            
            // Construir HTML directamente para SweetAlert
            const detailsHtml = `
                <div class="quote-details-container">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="details-section">
                                <h6><i class="fas fa-user text-primary"></i> Información del Cliente</h6>
                                <p><strong>Nombre:</strong> ${quote.name}</p>
                                <p><strong>Email:</strong> <a href="mailto:${quote.email}">${quote.email}</a></p>
                                <p><strong>Teléfono:</strong> ${quote.phone || 'No proporcionado'}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="details-section">
                                <h6><i class="fas fa-box text-info"></i> Información del Producto</h6>
                                <p><strong>Producto:</strong> ${quote.product_name}</p>
                                <p><strong>Categoría:</strong> ${quote.product_category || 'No especificada'}</p>
                                <p><strong>Cantidad:</strong> ${quote.quantity || 'No especificada'}</p>
                                <p><strong>Presupuesto:</strong> ${quote.budget_range || 'No especificado'}</p>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="details-section">
                                <h6><i class="fas fa-info-circle text-warning"></i> Estado y Prioridad</h6>
                                <p><strong>Estado:</strong> <span class="badge ${quote.status_class}">${quote.status_name}</span></p>
                                <p><strong>Prioridad:</strong> <span class="badge ${quote.priority_class}">${quote.priority}</span></p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="details-section">
                                <h6><i class="fas fa-calendar text-success"></i> Información de Fecha</h6>
                                <p><strong>Fecha de solicitud:</strong> ${quote.created_at}</p>
                                <p><strong>Hace:</strong> ${quote.created_at_human}</p>
                            </div>
                        </div>
                    </div>
                    ${quote.message ? `
                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="details-section">
                                    <h6><i class="fas fa-comment text-primary"></i> Mensaje del Cliente</h6>
                                    <div class="message-content">
                                        ${quote.message}
                                    </div>
                                </div>
                            </div>
                        </div>
                    ` : ''}
                </div>
                
                <style>
                .quote-details-container .details-section {
                    background: #f8f9fa;
                    padding: 1rem;
                    border-radius: 8px;
                    border-left: 4px solid #667eea;
                    margin-bottom: 1rem;
                }
                
                .quote-details-container .details-section h6 {
                    color: #495057;
                    margin-bottom: 0.75rem;
                    font-weight: 600;
                }
                
                .quote-details-container .details-section p {
                    margin-bottom: 0.5rem;
                    color: #6c757d;
                }
                
                .quote-details-container .badge {
                    font-size: 0.75rem;
                    padding: 0.375rem 0.75rem;
                }
                
                .quote-details-container .message-content {
                    background: white;
                    padding: 1rem;
                    border-radius: 6px;
                    border: 1px solid #dee2e6;
                    font-style: italic;
                    color: #495057;
                }
                </style>
            `;
            
            Swal.fire({
                title: `<i class="fas fa-file-invoice"></i> Cotización #${quote.id}`,
                html: detailsHtml,
                width: '900px',
                showCancelButton: false,
                confirmButtonText: '<i class="fas fa-times"></i> Cerrar',
                confirmButtonColor: '#667eea',
                customClass: {
                    popup: 'quote-details-modal',
                    title: 'quote-details-title'
                }
            });
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('❌ Error al ver cotización:', error);
        showError('Error al cargar los detalles de la cotización');
    }
}

// Eliminar cotización
function deleteQuote(id) {
    const quote = quotesData.find(q => q.id === id);
    
    Swal.fire({
        title: '¿Eliminar Cotización?',
        html: `
            <p>¿Estás seguro de que deseas eliminar esta cotización?</p>
            <div class="alert alert-warning mt-3">
                <strong>Cliente:</strong> ${quote.name}<br>
                <strong>Producto:</strong> ${quote.product_name}<br>
                <strong>Fecha:</strong> ${quote.created_at}
            </div>
            <p class="text-danger"><strong>Esta acción no se puede deshacer.</strong></p>
        `,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#f56565',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar',
        reverseButtons: true
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                console.log('🗑️ Eliminando cotización:', id);
                
                const response = await fetch(`<?php echo e(url('administrador/quotes')); ?>/${id}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Content-Type': 'application/json'
                    }
                });
                
                const deleteResult = await response.json();
                
                if (deleteResult.success) {
                    Swal.fire({
                        title: '¡Eliminada!',
                        text: deleteResult.message,
                        icon: 'success',
                        timer: 3000,
                        showConfirmButton: false
                    });
                    
                    // Recargar datos
                    loadStats();
                    loadQuotes();
                    
                    console.log('✅ Cotización eliminada');
                } else {
                    throw new Error(deleteResult.message);
                }
            } catch (error) {
                console.error('❌ Error al eliminar:', error);
                showError('Error al eliminar la cotización');
            }
        }
    });
}

// Aplicar filtros
function applyFilters() {
    const searchCustomer = document.getElementById('searchCustomer').value.toLowerCase();
    const searchProduct = document.getElementById('searchProduct').value.toLowerCase();
    const filterStatus = document.getElementById('filterStatus').value;
    const filterPriority = document.getElementById('filterPriority').value;
    
    filteredQuotes = quotesData.filter(quote => {
        const matchesCustomer = !searchCustomer || 
            quote.name.toLowerCase().includes(searchCustomer) ||
            quote.email.toLowerCase().includes(searchCustomer);
            
        const matchesProduct = !searchProduct || 
            quote.product_name.toLowerCase().includes(searchProduct);
            
        const matchesStatus = !filterStatus || quote.status === filterStatus;
        const matchesPriority = !filterPriority || quote.priority === filterPriority;
        
        return matchesCustomer && matchesProduct && matchesStatus && matchesPriority;
    });
    
    renderQuotes();
    console.log('🔍 Filtros aplicados:', filteredQuotes.length, 'de', quotesData.length);
}

// Limpiar filtros
function clearFilters() {
    document.getElementById('searchCustomer').value = '';
    document.getElementById('searchProduct').value = '';
    document.getElementById('filterStatus').value = '';
    document.getElementById('filterPriority').value = '';
    
    filteredQuotes = [...quotesData];
    renderQuotes();
    console.log('🧹 Filtros limpiados');
}

// Cambiar estado de cotización
function changeStatus(id, currentStatus) {
    const statusOptions = {
        'pendiente': 'Pendiente',
        'procesando': 'Procesando', 
        'enviado': 'Enviado',
        'cerrado': 'Cerrado'
    };
    
    // Construir opciones para el select
    let optionsHtml = '';
    for (const [value, label] of Object.entries(statusOptions)) {
        const selected = value === currentStatus ? 'selected' : '';
        optionsHtml += `<option value="${value}" ${selected}>${label}</option>`;
    }
    
    Swal.fire({
        title: 'Cambiar Estado',
        html: `
            <div class="form-group">
                <label for="statusSelect" class="form-label">Selecciona el nuevo estado:</label>
                <select id="statusSelect" class="form-control">
                    ${optionsHtml}
                </select>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Actualizar',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#667eea',
        cancelButtonColor: '#6c757d',
        preConfirm: () => {
            const newStatus = document.getElementById('statusSelect').value;
            if (!newStatus) {
                Swal.showValidationMessage('Debes seleccionar un estado');
                return false;
            }
            return newStatus;
        }
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                console.log('🔄 Cambiando estado de cotización:', id, 'a', result.value);
                
                const response = await fetch(`<?php echo e(url('administrador/quotes')); ?>/${id}/status`, {
                    method: 'PUT',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        status: result.value
                    })
                });
                
                const updateResult = await response.json();
                
                if (updateResult.success) {
                    Swal.fire({
                        title: '¡Actualizado!',
                        text: updateResult.message,
                        icon: 'success',
                        timer: 3000,
                        showConfirmButton: false
                    });
                    
                    // Actualizar datos locales
                    const quoteIndex = quotesData.findIndex(q => q.id === id);
                    if (quoteIndex !== -1) {
                        quotesData[quoteIndex].status = updateResult.data.status;
                        quotesData[quoteIndex].status_name = updateResult.data.status_name;
                        quotesData[quoteIndex].status_class = updateResult.data.status_class;
                    }
                    
                    // Recargar datos
                    loadStats();
                    applyFilters();
                    
                    console.log('✅ Estado actualizado');
                } else {
                    throw new Error(updateResult.message);
                }
            } catch (error) {
                console.error('❌ Error al cambiar estado:', error);
                showError('Error al actualizar el estado');
            }
        }
    });
}

// Cambiar prioridad de cotización
function changePriority(id, currentPriority) {
    const priorityOptions = {
        'baja': 'Baja',
        'media': 'Media',
        'alta': 'Alta'
    };
    
    // Construir opciones para el select
    let optionsHtml = '';
    for (const [value, label] of Object.entries(priorityOptions)) {
        const selected = value === currentPriority ? 'selected' : '';
        optionsHtml += `<option value="${value}" ${selected}>${label}</option>`;
    }
    
    Swal.fire({
        title: 'Cambiar Prioridad',
        html: `
            <div class="form-group">
                <label for="prioritySelect" class="form-label">Selecciona la nueva prioridad:</label>
                <select id="prioritySelect" class="form-control">
                    ${optionsHtml}
                </select>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Actualizar',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#667eea',
        cancelButtonColor: '#6c757d',
        preConfirm: () => {
            const newPriority = document.getElementById('prioritySelect').value;
            if (!newPriority) {
                Swal.showValidationMessage('Debes seleccionar una prioridad');
                return false;
            }
            return newPriority;
        }
    }).then(async (result) => {
        if (result.isConfirmed) {
            try {
                console.log('🚩 Cambiando prioridad de cotización:', id, 'a', result.value);
                
                const response = await fetch(`<?php echo e(url('administrador/quotes')); ?>/${id}/priority`, {
                    method: 'PUT',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        priority: result.value
                    })
                });
                
                const updateResult = await response.json();
                
                if (updateResult.success) {
                    Swal.fire({
                        title: '¡Actualizado!',
                        text: updateResult.message,
                        icon: 'success',
                        timer: 3000,
                        showConfirmButton: false
                    });
                    
                    // Actualizar datos locales
                    const quoteIndex = quotesData.findIndex(q => q.id === id);
                    if (quoteIndex !== -1) {
                        quotesData[quoteIndex].priority = updateResult.data.priority;
                        quotesData[quoteIndex].priority_class = updateResult.data.priority_class;
                    }
                    
                    // Recargar datos
                    loadStats();
                    applyFilters();
                    
                    console.log('✅ Prioridad actualizada');
                } else {
                    throw new Error(updateResult.message);
                }
            } catch (error) {
                console.error('❌ Error al cambiar prioridad:', error);
                showError('Error al actualizar la prioridad');
            }
        }
    });
}

// Mostrar error
function showError(message) {
    Swal.fire({
        title: 'Error',
        text: message,
        icon: 'error',
        confirmButtonColor: '#667eea'
    });
}

// Event listeners para filtros en tiempo real
document.getElementById('searchCustomer').addEventListener('input', applyFilters);
document.getElementById('searchProduct').addEventListener('input', applyFilters);
document.getElementById('filterStatus').addEventListener('change', applyFilters);
document.getElementById('filterPriority').addEventListener('change', applyFilters);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('administrador.include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/administrador/quotes/index.blade.php ENDPATH**/ ?>