

<?php $__env->startSection('content'); ?>
<div class="blog-post-page" style="margin-top: 120px;">
    <!-- Post Header -->
    <section class="post-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 3rem 0;">
        <div class="container" style="max-width: 800px; margin: 0 auto; padding: 0 2rem; text-align: center;">
            <div style="margin-bottom: 1rem;">
                <span style="background: rgba(255,255,255,0.2); padding: 0.5rem 1rem; border-radius: 20px; font-size: 0.9rem;"><?php echo e($post->category); ?></span>
            </div>
            <h1 style="margin: 0 0 1rem 0; font-size: 2.5rem; font-weight: 600; line-height: 1.2;"><?php echo e($post->title); ?></h1>
            <div style="display: flex; justify-content: center; align-items: center; gap: 2rem; font-size: 0.95rem; opacity: 0.9;">
                <span><i class="fas fa-user"></i> <?php echo e($post->author); ?></span>
                <span><i class="fas fa-calendar"></i> <?php echo e($post->spanish_date); ?></span>
                <span><i class="fas fa-clock"></i> <?php echo e($post->read_time); ?></span>
                <span><i class="fas fa-eye"></i> <?php echo e($post->views_count); ?> vistas</span>
            </div>
        </div>
    </section>

    <!-- Post Content -->
    <section class="post-content" style="padding: 4rem 0;">
        <div class="container" style="max-width: 800px; margin: 0 auto; padding: 0 2rem;">
            
            <!-- Featured Image -->
            <div style="margin-bottom: 3rem; border-radius: 15px; overflow: hidden; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
                <img src="<?php echo e($post->image_url); ?>" alt="<?php echo e($post->title); ?>" style="width: 100%; height: 400px; object-fit: cover;">
            </div>

            <!-- Excerpt -->
            <?php if($post->excerpt): ?>
                <div style="background: #f8f9ff; padding: 2rem; border-radius: 15px; margin-bottom: 3rem; border-left: 4px solid #667eea;">
                    <p style="margin: 0; font-size: 1.1rem; font-style: italic; color: #555; line-height: 1.6;"><?php echo e($post->excerpt); ?></p>
                </div>
            <?php endif; ?>

            <!-- Article Content -->
            <div class="article-content" style="line-height: 1.8; color: #333; font-size: 1.05rem;">
                <?php echo $post->content; ?>

            </div>

            <!-- Post Actions -->
            <div style="margin: 4rem 0; padding: 2rem; background: #f8f9ff; border-radius: 15px; text-align: center;">
                <h3 style="margin-bottom: 1rem; color: #333;">¿Te resultó útil este artículo?</h3>
                <div style="display: flex; justify-content: center; gap: 1rem; margin-bottom: 2rem;">
                    <button onclick="likePost()" style="padding: 10px 20px; background: #28a745; color: white; border: none; border-radius: 25px; cursor: pointer; font-weight: 600;">
                        <i class="fas fa-thumbs-up"></i> Útil
                    </button>
                    <button onclick="sharePost()" style="padding: 10px 20px; background: #667eea; color: white; border: none; border-radius: 25px; cursor: pointer; font-weight: 600;">
                        <i class="fas fa-share"></i> Compartir
                    </button>
                </div>
                <p style="margin: 0; color: #666;">Comparte este artículo con tus amigos y familiares</p>
            </div>
        </div>
    </section>

    <!-- Related Posts -->
    <?php if($relatedPosts->count() > 0): ?>
        <section class="related-posts" style="background: #f8f9fa; padding: 4rem 0;">
            <div class="container" style="max-width: 1200px; margin: 0 auto; padding: 0 2rem;">
                <h2 style="text-align: center; margin-bottom: 3rem; color: #333;">Artículos Relacionados</h2>
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 2rem;">
                    <?php $__currentLoopData = $relatedPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedPost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <article style="background: white; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1); overflow: hidden; transition: transform 0.3s ease;">
                            <div style="height: 180px; overflow: hidden;">
                                <img src="<?php echo e($relatedPost->image_url); ?>" alt="<?php echo e($relatedPost->title); ?>" style="width: 100%; height: 100%; object-fit: cover;">
                            </div>
                            <div style="padding: 1.5rem;">
                                <div style="margin-bottom: 1rem; font-size: 0.9rem; color: #666;">
                                    <span style="background: #f0f0f0; padding: 0.3rem 0.8rem; border-radius: 15px;"><?php echo e($relatedPost->category); ?></span>
                                </div>
                                <h3 style="margin: 0 0 1rem 0; font-size: 1.1rem; color: #333;"><?php echo e($relatedPost->title); ?></h3>
                                <p style="color: #666; margin-bottom: 1.5rem; font-size: 0.95rem;"><?php echo e($relatedPost->short_excerpt); ?></p>
                                <a href="<?php echo e(route('blog.show', $relatedPost->slug)); ?>" style="color: #667eea; font-weight: 600; text-decoration: none;">
                                    Leer más <i class="fas fa-arrow-right"></i>
                                </a>
                            </div>
                        </article>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Back to Blog -->
    <section style="padding: 3rem 0; text-align: center;">
        <a href="<?php echo e(route('index')); ?>" style="display: inline-flex; align-items: center; gap: 0.5rem; padding: 12px 24px; background: #667eea; color: white; text-decoration: none; border-radius: 25px; font-weight: 600; transition: transform 0.3s ease;">
            <i class="fas fa-arrow-left"></i>
            Volver al inicio
        </a>
    </section>
</div>

<style>
.article-content h2 {
    color: #333;
    margin: 2rem 0 1rem 0;
    font-size: 1.5rem;
    font-weight: 600;
}

.article-content h3 {
    color: #444;
    margin: 1.5rem 0 1rem 0;
    font-size: 1.3rem;
    font-weight: 600;
}

.article-content p {
    margin-bottom: 1.5rem;
}

.article-content ul, .article-content ol {
    margin: 1.5rem 0;
    padding-left: 2rem;
}

.article-content li {
    margin-bottom: 0.5rem;
}

.article-content blockquote {
    background: #f8f9ff;
    border-left: 4px solid #667eea;
    padding: 1.5rem;
    margin: 2rem 0;
    border-radius: 8px;
    font-style: italic;
}

@media (max-width: 768px) {
    .post-header h1 {
        font-size: 2rem !important;
    }
    
    .post-header > div > div {
        flex-direction: column !important;
        gap: 1rem !important;
    }
}
</style>

<script>
function likePost() {
    Swal.fire({
        title: '¡Gracias!',
        text: 'Nos alegra que este artículo te haya sido útil',
        icon: 'success',
        confirmButtonText: 'De nada'
    });
}

function sharePost() {
    if (navigator.share) {
        navigator.share({
            title: '<?php echo e($post->title); ?>',
            text: '<?php echo e($post->excerpt); ?>',
            url: window.location.href
        });
    } else {
        // Fallback: copiar URL al portapapeles
        navigator.clipboard.writeText(window.location.href).then(() => {
            Swal.fire({
                title: '¡URL Copiada!',
                text: 'El enlace se ha copiado al portapapeles',
                icon: 'success',
                confirmButtonText: 'Perfecto'
            });
        });
    }
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/blog/show.blade.php ENDPATH**/ ?>