

<?php $__env->startSection('title', 'Gestión de Categorías'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <span class="breadcrumb-item">Productos</span>
    <span class="breadcrumb-item active">Categorías</span>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .categories-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
    }
    
    .categories-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .btn-create {
        background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
        color: white;
        border: none;
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.3s ease;
    }
    
    .btn-create:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }
    
    .categories-table {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    
    .table-responsive {
        overflow-x: auto;
    }
    
    .table {
        width: 100%;
        margin-bottom: 0;
        color: var(--gray-700);
    }
    
    .table thead th {
        background: var(--gray-50);
        border-bottom: 1px solid var(--gray-200);
        padding: 1rem;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        color: var(--gray-600);
    }
    
    .table tbody td {
        padding: 1rem;
        border-bottom: 1px solid var(--gray-100);
        vertical-align: middle;
    }
    
    .table tbody tr:hover {
        background: var(--gray-50);
    }
    
    .badge {
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
    }
    
    .badge-info {
        background: rgba(66, 153, 225, 0.1);
        color: var(--info-color);
    }
    
    .action-buttons {
        display: flex;
        gap: 0.5rem;
    }
    
    .btn-action {
        width: 32px;
        height: 32px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.875rem;
        transition: all 0.3s ease;
    }
    
    .btn-view {
        background: rgba(66, 153, 225, 0.1);
        color: var(--info-color);
    }
    
    .btn-edit {
        background: rgba(72, 187, 120, 0.1);
        color: var(--success-color);
    }
    
    .btn-delete {
        background: rgba(245, 101, 101, 0.1);
        color: var(--danger-color);
    }
    
    .btn-action:hover {
        transform: scale(1.1);
    }
    
    .loading-spinner {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 200px;
    }
    
    .spinner {
        width: 40px;
        height: 40px;
        border: 4px solid var(--gray-200);
        border-top: 4px solid var(--primary-color);
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }
    
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .empty-state {
        text-align: center;
        padding: 3rem;
        color: var(--gray-500);
    }
    
    .empty-state i {
        font-size: 3rem;
        margin-bottom: 1rem;
        color: var(--gray-300);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="categories-container">
    <div class="categories-header">
        <h1 class="categories-title">
            <i class="fas fa-tags"></i>
            Gestión de Categorías
        </h1>
        <button class="btn-create" onclick="openCreateModal()">
            <i class="fas fa-plus"></i>
            Nueva Categoría
        </button>
    </div>
    
    <div class="categories-table">
        <div class="table-responsive">
            <table class="table" id="categoriesTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nombre</th>
                        <th>Descripción</th>
                        <th>Productos</th>
                        <th>Fecha Creación</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="categoriesTableBody">
                    <tr>
                        <td colspan="6">
                            <div class="loading-spinner">
                                <div class="spinner"></div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Crear/Editar Categoría -->
<div id="categoryModal" style="display: none;">
    <form id="categoryForm">
        <div style="margin-bottom: 1rem;">
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Nombre de la Categoría *</label>
            <input type="text" id="categoryName" name="name" 
                   style="width: 100%; padding: 0.75rem; border: 2px solid #e2e8f0; border-radius: 8px;" 
                   placeholder="Ej: Línea Refrigeración" required>
        </div>
        <div style="margin-bottom: 1rem;">
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Descripción</label>
            <textarea id="categoryDescription" name="description" rows="3"
                      style="width: 100%; padding: 0.75rem; border: 2px solid #e2e8f0; border-radius: 8px; resize: vertical;"
                      placeholder="Descripción opcional de la categoría..."></textarea>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let currentCategoryId = null;
let isEditMode = false;

// Cargar categorías al cargar la página
document.addEventListener('DOMContentLoaded', function() {
    loadCategories();
});

// Cargar categorías
async function loadCategories() {
    console.log('🔄 Iniciando carga de categorías...');
    try {
        const url = '<?php echo e(route("admin.categories.data")); ?>';
        console.log('📡 URL de solicitud:', url);
        
        const response = await fetch(url);
        console.log('📊 Respuesta recibida:', response.status, response.statusText);
        
        const result = await response.json();
        console.log('📋 Datos recibidos:', result);
        
        const tbody = document.getElementById('categoriesTableBody');
        
        if (result.success && result.data.length > 0) {
            console.log('✅ Categorías encontradas:', result.data.length);
            tbody.innerHTML = result.data.map(category => `
                <tr>
                    <td>${category.id}</td>
                    <td><strong>${category.name}</strong></td>
                    <td>${category.description || '<em>Sin descripción</em>'}</td>
                    <td>
                        <span class="badge badge-info">${category.products_count} productos</span>
                    </td>
                    <td>${category.created_at}</td>
                    <td>
                        <div class="action-buttons">
                            <button class="btn-action btn-view" onclick="viewCategory(${category.id})" title="Ver detalles">
                                <i class="fas fa-eye"></i>
                            </button>
                            <button class="btn-action btn-edit" onclick="editCategory(${category.id})" title="Editar">
                                <i class="fas fa-edit"></i>
                            </button>
                            <button class="btn-action btn-delete" onclick="deleteCategory(${category.id})" title="Eliminar">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            `).join('');
        } else {
            console.log('⚠️ No hay categorías o error en datos');
            tbody.innerHTML = `
                <tr>
                    <td colspan="6">
                        <div class="empty-state">
                            <i class="fas fa-tags"></i>
                            <p>No hay categorías registradas</p>
                            <button class="btn-create" onclick="openCreateModal()" style="margin-top: 1rem;">
                                <i class="fas fa-plus"></i>
                                Crear Primera Categoría
                            </button>
                        </div>
                    </td>
                </tr>
            `;
        }
    } catch (error) {
        console.error('❌ Error al cargar categorías:', error);
        const tbody = document.getElementById('categoriesTableBody');
        tbody.innerHTML = `
            <tr>
                <td colspan="6">
                    <div class="empty-state">
                        <i class="fas fa-exclamation-triangle"></i>
                        <p>Error al cargar las categorías</p>
                        <button class="btn-create" onclick="loadCategories()" style="margin-top: 1rem;">
                            <i class="fas fa-sync"></i>
                            Reintentar
                        </button>
                    </div>
                </td>
            </tr>
        `;
        Swal.fire({
            title: 'Error',
            text: 'No se pudieron cargar las categorías: ' + error.message,
            icon: 'error'
        });
    }
}

// Abrir modal para crear categoría
function openCreateModal() {
    isEditMode = false;
    currentCategoryId = null;
    
    Swal.fire({
        title: 'Nueva Categoría',
        html: document.getElementById('categoryModal').innerHTML,
        showCancelButton: true,
        confirmButtonText: 'Crear Categoría',
        cancelButtonText: 'Cancelar',
        confirmButtonColor: '#667eea',
        width: '500px',
        preConfirm: () => {
            const name = Swal.getPopup().querySelector('#categoryName').value;
            const description = Swal.getPopup().querySelector('#categoryDescription').value;
            
            if (!name.trim()) {
                Swal.showValidationMessage('El nombre de la categoría es obligatorio');
                return false;
            }
            
            return { name: name.trim(), description: description.trim() };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            createCategory(result.value);
        }
    });
}

// Crear categoría
async function createCategory(data) {
    try {
        const response = await fetch('<?php echo e(route("admin.categories.store")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.success) {
            Swal.fire({
                title: '¡Éxito!',
                text: result.message,
                icon: 'success',
                timer: 2000,
                showConfirmButton: false
            });
            loadCategories();
        } else {
            let errorMessage = result.message;
            if (result.errors) {
                errorMessage = Object.values(result.errors).flat().join('<br>');
            }
            
            Swal.fire({
                title: 'Error de Validación',
                html: errorMessage,
                icon: 'error'
            });
        }
    } catch (error) {
        console.error('Error al crear categoría:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo crear la categoría',
            icon: 'error'
        });
    }
}

// Ver detalles de categoría
async function viewCategory(id) {
    try {
        const response = await fetch(`<?php echo e(route("admin.categories.show", ":id")); ?>`.replace(':id', id));
        const result = await response.json();
        
        if (result.success) {
            const category = result.data;
            
            Swal.fire({
                title: category.name,
                html: `
                    <div style="text-align: left;">
                        <p><strong>ID:</strong> ${category.id}</p>
                        <p><strong>Descripción:</strong> ${category.description || 'Sin descripción'}</p>
                        <p><strong>Productos asociados:</strong> ${category.products ? category.products.length : 0}</p>
                        <p><strong>Fecha de creación:</strong> ${new Date(category.created_at).toLocaleDateString('es-ES')}</p>
                    </div>
                `,
                icon: 'info',
                confirmButtonText: 'Cerrar',
                confirmButtonColor: '#667eea'
            });
        }
    } catch (error) {
        console.error('Error al ver categoría:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudieron cargar los detalles',
            icon: 'error'
        });
    }
}

// Editar categoría
async function editCategory(id) {
    try {
        const response = await fetch(`<?php echo e(route("admin.categories.show", ":id")); ?>`.replace(':id', id));
        const result = await response.json();
        
        if (result.success) {
            const category = result.data;
            isEditMode = true;
            currentCategoryId = id;
            
            Swal.fire({
                title: 'Editar Categoría',
                html: document.getElementById('categoryModal').innerHTML,
                showCancelButton: true,
                confirmButtonText: 'Actualizar Categoría',
                cancelButtonText: 'Cancelar',
                confirmButtonColor: '#667eea',
                width: '500px',
                didOpen: () => {
                    // Llenar los campos con los datos actuales
                    Swal.getPopup().querySelector('#categoryName').value = category.name;
                    Swal.getPopup().querySelector('#categoryDescription').value = category.description || '';
                },
                preConfirm: () => {
                    const name = Swal.getPopup().querySelector('#categoryName').value;
                    const description = Swal.getPopup().querySelector('#categoryDescription').value;
                    
                    if (!name.trim()) {
                        Swal.showValidationMessage('El nombre de la categoría es obligatorio');
                        return false;
                    }
                    
                    return { name: name.trim(), description: description.trim() };
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    updateCategory(id, result.value);
                }
            });
        }
    } catch (error) {
        console.error('Error al cargar categoría:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo cargar la categoría',
            icon: 'error'
        });
    }
}

// Actualizar categoría
async function updateCategory(id, data) {
    try {
        const response = await fetch(`<?php echo e(route("admin.categories.update", ":id")); ?>`.replace(':id', id), {
            method: 'PUT',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify(data)
        });
        
        const result = await response.json();
        
        if (result.success) {
            Swal.fire({
                title: '¡Éxito!',
                text: result.message,
                icon: 'success',
                timer: 2000,
                showConfirmButton: false
            });
            loadCategories();
        } else {
            let errorMessage = result.message;
            if (result.errors) {
                errorMessage = Object.values(result.errors).flat().join('<br>');
            }
            
            Swal.fire({
                title: 'Error de Validación',
                html: errorMessage,
                icon: 'error'
            });
        }
    } catch (error) {
        console.error('Error al actualizar categoría:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo actualizar la categoría',
            icon: 'error'
        });
    }
}

// Eliminar categoría
function deleteCategory(id) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: 'Esta acción no se puede deshacer',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            performDeleteCategory(id);
        }
    });
}

// Realizar eliminación
async function performDeleteCategory(id) {
    try {
        const response = await fetch(`<?php echo e(route("admin.categories.destroy", ":id")); ?>`.replace(':id', id), {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });
        
        const result = await response.json();
        
        if (result.success) {
            Swal.fire({
                title: '¡Eliminado!',
                text: result.message,
                icon: 'success',
                timer: 2000,
                showConfirmButton: false
            });
            loadCategories();
        } else {
            Swal.fire({
                title: 'Error',
                text: result.message,
                icon: 'error'
            });
        }
    } catch (error) {
        console.error('Error al eliminar categoría:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo eliminar la categoría',
            icon: 'error'
        });
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('administrador.include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/administrador/categories/index.blade.php ENDPATH**/ ?>