

<?php $__env->startSection('content'); ?>
<div class="blog-page" style="margin-top: 120px;">
    <!-- Blog Header -->
    <section class="blog-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 4rem 0; text-align: center;">
        <div class="container">
            <h1 style="margin: 0 0 1rem 0; font-size: 3rem; font-weight: 600;">Nuestro Blog</h1>
            <p style="margin: 0; font-size: 1.2rem; opacity: 0.9;">Consejos, tips y novedades del mundo de los electrodomésticos</p>
        </div>
    </section>

    <!-- Blog Content -->
    <section class="blog-content" style="padding: 4rem 0;">
        <div class="container" style="max-width: 1200px; margin: 0 auto; padding: 0 2rem;">
            
            <!-- Featured Posts (if any) -->
            <?php if($featuredPosts->count() > 0): ?>
                <div class="featured-section" style="margin-bottom: 4rem;">
                    <h2 style="color: #333; margin-bottom: 2rem; text-align: center;">Artículos Destacados</h2>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 2rem;">
                        <?php $__currentLoopData = $featuredPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <article class="featured-post" style="background: white; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); overflow: hidden; position: relative;">
                                <div style="position: absolute; top: 1rem; left: 1rem; background: #667eea; color: white; padding: 0.5rem 1rem; border-radius: 20px; font-size: 0.9rem; font-weight: 600; z-index: 2;">
                                    ⭐ Destacado
                                </div>
                                <div style="height: 200px; overflow: hidden;">
                                    <img src="<?php echo e($post->image_url); ?>" alt="<?php echo e($post->title); ?>" style="width: 100%; height: 100%; object-fit: cover;">
                                </div>
                                <div style="padding: 2rem;">
                                    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem; font-size: 0.9rem; color: #666;">
                                        <span style="background: #f0f0f0; padding: 0.3rem 0.8rem; border-radius: 15px;"><?php echo e($post->category); ?></span>
                                        <span><?php echo e($post->spanish_date); ?></span>
                                    </div>
                                    <h3 style="margin: 0 0 1rem 0; font-size: 1.3rem; color: #333;"><?php echo e($post->title); ?></h3>
                                    <p style="color: #666; margin-bottom: 1.5rem; line-height: 1.6;"><?php echo e($post->short_excerpt); ?></p>
                                    <a href="<?php echo e(route('blog.show', $post->slug)); ?>" style="display: inline-flex; align-items: center; gap: 0.5rem; color: #667eea; font-weight: 600; text-decoration: none;">
                                        Leer más <i class="fas fa-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Filters and Search -->
            <div class="blog-filters" style="background: white; padding: 2rem; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1); margin-bottom: 3rem;">
                <form method="GET" action="<?php echo e(route('blog.index')); ?>" style="display: flex; gap: 1rem; align-items: center; flex-wrap: wrap;">
                    <div style="flex: 1; min-width: 250px;">
                        <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Buscar artículos..." 
                               style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px; font-size: 1rem;">
                    </div>
                    <div style="min-width: 200px;">
                        <select name="category" style="width: 100%; padding: 12px; border: 2px solid #e9ecef; border-radius: 8px; font-size: 1rem;">
                            <option value="">Todas las categorías</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category); ?>" <?php echo e(request('category') == $category ? 'selected' : ''); ?>>
                                    <?php echo e($category); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <button type="submit" style="padding: 12px 24px; background: #667eea; color: white; border: none; border-radius: 8px; font-weight: 600; cursor: pointer;">
                        <i class="fas fa-search"></i> Buscar
                    </button>
                </form>
            </div>

            <!-- Blog Posts Grid -->
            <div class="blog-posts-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 2rem;">
                <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <article class="blog-post-card" style="background: white; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.1); overflow: hidden; transition: transform 0.3s ease;">
                        <div style="height: 200px; overflow: hidden;">
                            <img src="<?php echo e($post->image_url); ?>" alt="<?php echo e($post->title); ?>" style="width: 100%; height: 100%; object-fit: cover; transition: transform 0.3s ease;">
                        </div>
                        <div style="padding: 1.5rem;">
                            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem; font-size: 0.9rem; color: #666;">
                                <span style="background: #f0f0f0; padding: 0.3rem 0.8rem; border-radius: 15px;"><?php echo e($post->category); ?></span>
                                <span><?php echo e($post->spanish_date); ?></span>
                            </div>
                            <h3 style="margin: 0 0 1rem 0; font-size: 1.2rem; color: #333; line-height: 1.4;"><?php echo e($post->title); ?></h3>
                            <p style="color: #666; margin-bottom: 1.5rem; line-height: 1.6; font-size: 0.95rem;"><?php echo e($post->short_excerpt); ?></p>
                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                <small style="color: #999;"><?php echo e($post->read_time); ?></small>
                                <a href="<?php echo e(route('blog.show', $post->slug)); ?>" style="display: inline-flex; align-items: center; gap: 0.5rem; color: #667eea; font-weight: 600; text-decoration: none;">
                                    Leer más <i class="fas fa-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div style="grid-column: 1 / -1; text-align: center; padding: 4rem 2rem; color: #666;">
                        <i class="fas fa-newspaper" style="font-size: 4rem; margin-bottom: 1rem; opacity: 0.3;"></i>
                        <h3 style="margin-bottom: 1rem;">No se encontraron artículos</h3>
                        <p>Intenta con otros términos de búsqueda o selecciona una categoría diferente.</p>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Pagination -->
            <?php if($posts->hasPages()): ?>
                <div style="margin-top: 3rem; display: flex; justify-content: center;">
                    <?php echo e($posts->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </section>
</div>

<style>
.blog-post-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15) !important;
}

.blog-post-card:hover img {
    transform: scale(1.05);
}

@media (max-width: 768px) {
    .blog-filters form {
        flex-direction: column;
    }
    
    .blog-filters form > div {
        width: 100%;
        min-width: auto;
    }
    
    .blog-posts-grid {
        grid-template-columns: 1fr !important;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/blog/index.blade.php ENDPATH**/ ?>