<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Panel de Administración - ElectroMart'); ?></title>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- CSS Principal del Admin -->
    <link rel="stylesheet" href="<?php echo e(asset('css/admin.css')); ?>">
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="admin-layout">
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-brand">
                <i class="fas fa-bolt"></i>
                <span class="brand-text">Industria sp</span>
                <span class="brand-admin">Admin</span>
            </div>
            <button class="sidebar-toggle" id="sidebarToggle">
                <i class="fas fa-bars"></i>
            </button>
        </div>
        
        <nav class="sidebar-nav">
            <ul class="nav-list">
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.index') ? 'active' : ''); ?>">
                        <i class="fas fa-home"></i>
                        <span class="nav-text">Dashboard</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="#" class="nav-link has-submenu" data-submenu="categorias">
                        <i class="fas fa-tags"></i>
                        <span class="nav-text">Categorías</span>
                        <i class="fas fa-chevron-down submenu-arrow"></i>
                    </a>
                    <ul class="submenu">
                        <li><a href="<?php echo e(route('admin.categories.index')); ?>" class="submenu-link <?php echo e(request()->routeIs('admin.categories.*') ? 'active' : ''); ?>">Ver Categorías</a></li>
                    </ul>
                </li>
                
                <li class="nav-item">
                    <a href="#" class="nav-link has-submenu" data-submenu="productos">
                        <i class="fas fa-box"></i>
                        <span class="nav-text">Productos</span>
                        <i class="fas fa-chevron-down submenu-arrow"></i>
                    </a>
                    <ul class="submenu">
                        <li><a href="<?php echo e(route('admin.products.index')); ?>" class="submenu-link <?php echo e(request()->routeIs('admin.products.*') ? 'active' : ''); ?>">Ver Productos</a></li>
                    </ul>
                </li>
                
               
                
                <li class="nav-item">
                    <a href="#" class="nav-link has-submenu" data-submenu="usuarios">
                        <i class="fas fa-users"></i>
                        <span class="nav-text">Usuarios</span>
                        <i class="fas fa-chevron-down submenu-arrow"></i>
                    </a>
                    <ul class="submenu">
                        <li><a href="<?php echo e(route('admin.users.admins')); ?>" class="submenu-link <?php echo e(request()->routeIs('admin.users.admins') ? 'active' : ''); ?>">Administradores</a></li>
                        <li><a href="<?php echo e(route('admin.users.clients')); ?>" class="submenu-link <?php echo e(request()->routeIs('admin.users.clients') ? 'active' : ''); ?>">Clientes</a></li>
                    </ul>
                </li>
                
                <li class="nav-item">
                    <a href="#" class="nav-link has-submenu" data-submenu="blog">
                        <i class="fas fa-blog"></i>
                        <span class="nav-text">Blog</span>
                        <i class="fas fa-chevron-down submenu-arrow"></i>
                    </a>
                    <ul class="submenu">
                        <li><a href="<?php echo e(route('admin.blog.index')); ?>" class="submenu-link <?php echo e(request()->routeIs('admin.blog.*') ? 'active' : ''); ?>">Ver Posts</a></li>
                    </ul>
                </li>
                
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.messages.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.messages.*') ? 'active' : ''); ?>">
                        <i class="fas fa-envelope"></i>
                        <span class="nav-text">Mensajes</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.orders.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.orders.*') ? 'active' : ''); ?>">
                        <i class="fas fa-shopping-cart"></i>
                        <span class="nav-text">Pedidos</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.quotes.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.quotes.*') ? 'active' : ''); ?>">
                        <i class="fas fa-file-invoice-dollar"></i>
                        <span class="nav-text">Cotizaciones</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.reports.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.reports.*') ? 'active' : ''); ?>">
                        <i class="fas fa-chart-line"></i>
                        <span class="nav-text">Reportes</span>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.company-info.index')); ?>" class="nav-link <?php echo e(request()->routeIs('admin.company-info.*') ? 'active' : ''); ?>">
                        <i class="fas fa-building"></i>
                        <span class="nav-text">Información Empresa</span>
                    </a>
                </li>
                
               
            </ul>
        </nav>
        
        <div class="sidebar-footer">
            <div class="user-info">
                <div class="user-avatar">
                    <i class="fas fa-user-circle"></i>
                </div>
                <div class="user-details">
                    <span class="user-name"><?php echo e(Auth::user()->name); ?></span>
                    <span class="user-role">Administrador</span>
                </div>
            </div>
        </div>
    </aside>
    
    <!-- Main Content -->
    <main class="main-content">
        <!-- Header -->
        <header class="main-header">
            <div class="header-left">
                <button class="mobile-menu-toggle" id="mobileMenuToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <div class="breadcrumb">
                    <?php echo $__env->yieldContent('breadcrumb'); ?>
                </div>
            </div>
            
            <div class="header-right">
                <!-- Notifications -->
               
                <!-- User Menu -->
                <div class="header-item user-dropdown">
                    <button class="user-btn">
                        <img src="https://ui-avatars.com/api/?name=<?php echo e(Auth::user()->name); ?>&background=667eea&color=fff" alt="Usuario" class="user-avatar">
                        <span class="user-name"><?php echo e(Auth::user()->name); ?></span>
                        <i class="fas fa-chevron-down"></i>
                    </button>
                    <div class="user-menu">
                        <a href="#" class="user-menu-item">
                            <i class="fas fa-user"></i>
                            Mi Perfil
                        </a>
                     
                        <div class="user-menu-divider"></div>
                        <a href="#" class="user-menu-item" id="logoutBtn">
                            <i class="fas fa-sign-out-alt"></i>
                            Cerrar Sesión
                        </a>
                    </div>
                </div>
            </div>
        </header>
        
        <!-- Page Content -->
        <div class="page-content">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </main>
    
    <!-- Overlay for mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>
    
    <!-- Scripts -->
    <script>
        // Sidebar Toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.body.classList.toggle('sidebar-collapsed');
        });
        
        document.getElementById('mobileMenuToggle').addEventListener('click', function() {
            document.body.classList.toggle('sidebar-open');
        });
        
        document.getElementById('sidebarOverlay').addEventListener('click', function() {
            document.body.classList.remove('sidebar-open');
        });
        
        // Submenu Toggle - ARREGLADO
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.nav-link.has-submenu').forEach(item => {
                item.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    // Cerrar otros submenús
                    document.querySelectorAll('.nav-item .has-submenu.open').forEach(openItem => {
                        if (openItem !== this) {
                            openItem.classList.remove('open');
                            const otherSubmenu = openItem.nextElementSibling;
                            if (otherSubmenu && otherSubmenu.classList.contains('submenu')) {
                                otherSubmenu.style.display = 'none';
                            }
                        }
                    });
                    
                    // Toggle el submenú actual
                    this.classList.toggle('open');
                    const submenu = this.nextElementSibling;
                    
                    if (submenu && submenu.classList.contains('submenu')) {
                        if (this.classList.contains('open')) {
                            submenu.style.display = 'block';
                            // Animación suave
                            submenu.style.opacity = '0';
                            submenu.style.transform = 'translateY(-10px)';
                            setTimeout(() => {
                                submenu.style.transition = 'all 0.3s ease';
                                submenu.style.opacity = '1';
                                submenu.style.transform = 'translateY(0)';
                            }, 10);
                        } else {
                            submenu.style.display = 'none';
                        }
                    }
                });
            });
            
            // Mantener abierto el submenú activo
            document.querySelectorAll('.submenu-link.active').forEach(activeLink => {
                const submenu = activeLink.closest('.submenu');
                const parentLink = submenu.previousElementSibling;
                if (parentLink && parentLink.classList.contains('has-submenu')) {
                    parentLink.classList.add('open');
                    submenu.style.display = 'block';
                }
            });
        });
        
        // Dropdown Toggles
        document.querySelectorAll('.notification-btn, .user-btn').forEach(btn => {
            btn.addEventListener('click', function(e) {
                e.stopPropagation();
                const dropdown = this.parentElement;
                dropdown.classList.toggle('open');
                
                // Close other dropdowns
                document.querySelectorAll('.header-item.open').forEach(item => {
                    if (item !== dropdown) {
                        item.classList.remove('open');
                    }
                });
            });
        });
        
        // Close dropdowns when clicking outside
        document.addEventListener('click', function() {
            document.querySelectorAll('.header-item.open').forEach(item => {
                item.classList.remove('open');
            });
        });
        
        // Prevent dropdown close when clicking inside
        document.querySelectorAll('.notification-menu, .user-menu').forEach(menu => {
            menu.addEventListener('click', function(e) {
                e.stopPropagation();
            });
        });
        
        // Logout con SweetAlert y AJAX
        document.getElementById('logoutBtn').addEventListener('click', function(e) {
            e.preventDefault();
            
            Swal.fire({
                title: '¿Cerrar sesión?',
                text: '¿Estás seguro de que deseas cerrar sesión?',
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#667eea',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Sí, cerrar sesión',
                cancelButtonText: 'Cancelar',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // Mostrar loading
                    Swal.fire({
                        title: 'Cerrando sesión...',
                        text: 'Por favor espere',
                        icon: 'info',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        showConfirmButton: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });
                    
                    // Crear form para logout
                    const form = document.createElement('form');
                    form.method = 'POST';
                    form.action = '<?php echo e(route("admin.logout")); ?>';
                    
                    // Agregar CSRF token
                    const csrfToken = document.createElement('input');
                    csrfToken.type = 'hidden';
                    csrfToken.name = '_token';
                    csrfToken.value = '<?php echo e(csrf_token()); ?>';
                    form.appendChild(csrfToken);
                    
                    // Agregar al DOM y enviar
                    document.body.appendChild(form);
                    
                    // Simular un pequeño delay para mostrar el loading
                    setTimeout(() => {
                        form.submit();
                    }, 1000);
                }
            });
        });
    </script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/administrador/include/template.blade.php ENDPATH**/ ?>