<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/latest-products.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Hero Section -->
    <section class="hero" id="inicio">
        <div class="hero-background">
            <div class="appliance-graphics">
                <!-- SVG graphics for appliances will be styled with CSS -->
                <div class="appliance-shape appliance-1"></div>
                <div class="appliance-shape appliance-2"></div>
                <div class="appliance-shape appliance-3"></div>
                <div class="appliance-shape appliance-4"></div>
            </div>
        </div>
        <div class="container">
            <div class="hero-content">
                <h2 class="hero-title">
                    ELECTRODOMÉSTICOS<br>
                    DE CALIDAD PREMIUM
                </h2>
                <p class="hero-subtitle">
                    Descubre nuestra amplia gama de electrodomésticos para hacer tu hogar más eficiente y moderno
                </p>
                
            </div>
        </div>
    </section>

    <!-- Categories Section -->
    <section class="categories">
        <div class="container">
            <h2 class="section-title">
                ENCUENTRA <span>lo que buscas</span>
            </h2>
            <div class="categories-grid">
                <div class="category-card">
                    <div class="category-image">
                        <img src="https://images.pexels.com/photos/2343468/pexels-photo-2343468.jpeg?auto=compress&cs=tinysrgb&w=400"
                            alt="Línea Refrigeración">
                    </div>
                    <h3 class="category-title">Línea Refrigeración</h3>
                    <div class="category-underline blue"></div>
                </div>
                <div class="category-card">
                    <div class="category-image">
                        <img src="https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=400"
                            alt="Línea Lavandería">
                    </div>
                    <h3 class="category-title">Línea Lavandería</h3>
                    <div class="category-underline teal"></div>
                </div>
                <div class="category-card">
                    <div class="category-image">
                        <img src="https://images.pexels.com/photos/2062431/pexels-photo-2062431.jpeg?auto=compress&cs=tinysrgb&w=400"
                            alt="Línea Cocina">
                    </div>
                    <h3 class="category-title">Línea Cocina</h3>
                    <div class="category-underline orange"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Featured Products -->
   
    <section class="categories">
        <div class="container">
            <h2 class="section-title">
                PRODUCTOS <span>recientes</span>
            </h2>
            <p class="section-subtitle">Descubre los últimos productos agregados a nuestro catálogo</p>

            <div class="categories-grid">
                <?php $__empty_1 = true; $__currentLoopData = $latestProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="category-card product-card-simple">
                        <div class="category-image">
                            <img src="<?php echo e($product->image); ?>" alt="<?php echo e($product->name); ?>">
                            <?php if($product->category): ?>
                                <div class="product-category-badge"><?php echo e($product->category->name); ?></div>
                            <?php endif; ?>
                        </div>
                        <h3 class="category-title"><?php echo e($product->name); ?></h3>
                        <div class="product-price-simple"><?php echo e($product->formatted_price); ?></div>
                        <div class="category-underline blue"></div>
                       
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <!-- Productos por defecto si no hay en la BD -->
                  
                <?php endif; ?>
            </div>

            <?php if($latestProducts->count() > 0): ?>
                <div style="text-align: center; margin-top: 3rem;">
                    <a href="<?php echo e(route('Producto.index')); ?>" class="btn btn-primary"
                        style="padding: 15px 30px; font-size: 16px; font-weight: 600;">
                        <i class="fas fa-th-large"></i>
                        Ver todos los productos
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </section>


    </div>
    </section>

    <!-- About Us Section -->
    <section class="about-us" id="nosotros">
        <div class="container">
            <div class="about-content">
                <div class="about-text">
                    <h2 class="section-title">
                        ACERCA DE <span>nosotros</span>
                    </h2>
                    <p class="about-description">
                        En ElectroMart, nos especializamos en ofrecer electrodomésticos de la más alta calidad
                        para hacer tu hogar más eficiente y moderno. Con más de 15 años de experiencia en el
                        mercado peruano, nos hemos convertido en la tienda de confianza para miles de familias.
                    </p>
                    <div class="about-features">
                        <div class="feature-item">
                            <i class="fas fa-medal"></i>
                            <div>
                                <h4>Calidad Premium</h4>
                                <p>Solo trabajamos con las mejores marcas del mercado</p>
                            </div>
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-tools"></i>
                            <div>
                                <h4>Servicio Técnico</h4>
                                <p>Instalación y mantenimiento profesional</p>
                            </div>
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-shipping-fast"></i>
                            <div>
                                <h4>Delivery Gratuito</h4>
                                <p>Entrega sin costo en Lima y Callao</p>
                            </div>
                        </div>
                        <div class="feature-item">
                            <i class="fas fa-shield-alt"></i>
                            <div>
                                <h4>Garantía Extendida</h4>
                                <p>Protección adicional para tu inversión</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="about-image">
                    <img src="https://images.pexels.com/photos/4107043/pexels-photo-4107043.jpeg?auto=compress&cs=tinysrgb&w=600"
                        alt="Nuestra tienda ElectroMart">
                    <div class="about-stats">
                        <div class="stat-item">
                            <h3>15+</h3>
                            <p>Años de experiencia</p>
                        </div>
                        <div class="stat-item">
                            <h3>10,000+</h3>
                            <p>Clientes satisfechos</p>
                        </div>
                        <div class="stat-item">
                            <h3>500+</h3>
                            <p>Productos disponibles</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Blog Section -->
    <section class="blog-section" id="blog">
        <div class="container">
            <h2 class="section-title">
                NUESTRO <span>blog</span>
            </h2>
            <p class="section-subtitle">Consejos, tips y novedades del mundo de los electrodomésticos</p>
            <div class="blog-grid">
                <?php $__empty_1 = true; $__currentLoopData = $blogPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <article class="blog-card">
                        <div class="blog-image">
                            <img src="<?php echo e($post->image_url); ?>" alt="<?php echo e($post->title); ?>">
                            <div class="blog-category"><?php echo e($post->category); ?></div>
                        </div>
                        <div class="blog-content">
                            <div class="blog-meta">
                                <span class="blog-date"><?php echo e($post->spanish_date); ?></span>
                                <span class="blog-author">Por <?php echo e($post->author); ?></span>
                            </div>
                            <h3 class="blog-title"><?php echo e($post->title); ?></h3>
                            <p class="blog-excerpt">
                                <?php echo e($post->short_excerpt); ?>

                            </p>
                            <a href="<?php echo e(route('blog.show', $post->slug)); ?>" class="blog-read-more">
                                Leer más <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <!-- Posts por defecto si no hay en la BD -->
                   
                <?php endif; ?>
            </div>

        
        </div>
    </section>




    <!-- Technical Service Section -->
    <section class="technical-service" id="servicio">
        <div class="container">
            <h2 class="section-title">
                SERVICIO <span>técnico</span>
            </h2>
            <p class="section-subtitle">Soporte profesional para todos tus electrodomésticos</p>

            <div class="service-content">
                <div class="service-info">
                    <div class="service-intro">
                        <h3>Expertos a tu servicio</h3>
                        <p>
                            Nuestro equipo de técnicos certificados está disponible para brindarte
                            el mejor servicio de instalación, mantenimiento y reparación de electrodomésticos.
                        </p>
                    </div>

                    <div class="service-features">
                        <div class="service-feature">
                            <i class="fas fa-user-tie"></i>
                            <div>
                                <h4>Técnicos Certificados</h4>
                                <p>Personal altamente capacitado y certificado por las principales marcas</p>
                            </div>
                        </div>
                        <div class="service-feature">
                            <i class="fas fa-clock"></i>
                            <div>
                                <h4>Atención 24/7</h4>
                                <p>Servicio de emergencia disponible todos los días del año</p>
                            </div>
                        </div>
                        <div class="service-feature">
                            <i class="fas fa-shield-alt"></i>
                            <div>
                                <h4>Garantía de Servicio</h4>
                                <p>Todos nuestros trabajos incluyen garantía de 6 meses</p>
                            </div>
                        </div>
                        <div class="service-feature">
                            <i class="fas fa-home"></i>
                            <div>
                                <h4>Servicio a Domicilio</h4>
                                <p>Atendemos en la comodidad de tu hogar sin costo adicional</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="service-image">
                    <img src="https://images.pexels.com/photos/5691659/pexels-photo-5691659.jpeg?auto=compress&cs=tinysrgb&w=600"
                        alt="Técnico reparando electrodoméstico">
                </div>
            </div>

            <!-- Service Types -->
            <div class="service-types">
                <div class="service-type-card">
                    <i class="fas fa-wrench"></i>
                    <h4>Instalación</h4>
                    <p>Instalación profesional de todos tus electrodomésticos nuevos</p>
                    <ul>
                        <li>Refrigeradoras</li>
                        <li>Lavadoras</li>
                        <li>Cocinas</li>
                        <li>Aires acondicionados</li>
                    </ul>
                </div>

                <div class="service-type-card">
                    <i class="fas fa-tools"></i>
                    <h4>Mantenimiento</h4>
                    <p>Mantenimiento preventivo para prolongar la vida útil</p>
                    <ul>
                        <li>Limpieza profunda</li>
                        <li>Revisión de componentes</li>
                        <li>Cambio de filtros</li>
                        <li>Calibración</li>
                    </ul>
                </div>

                <div class="service-type-card">
                    <i class="fas fa-ambulance"></i>
                    <h4>Reparación</h4>
                    <p>Diagnóstico y reparación de fallas en tiempo récord</p>
                    <ul>
                        <li>Diagnóstico gratuito</li>
                        <li>Repuestos originales</li>
                        <li>Reparación express</li>
                        <li>Garantía incluida</li>
                    </ul>
                </div>

                <div class="service-type-card">
                    <i class="fas fa-phone-alt"></i>
                    <h4>Soporte Técnico</h4>
                    <p>Asesoría telefónica y resolución de problemas menores</p>
                    <ul>
                        <li>Consultas gratuitas</li>
                        <li>Guías paso a paso</li>
                        <li>Tips de uso</li>
                        <li>Programación remota</li>
                    </ul>
                </div>
            </div>

            <!-- Emergency Contact -->
            <div class="emergency-contact">
                <div class="emergency-content">
                    <i class="fas fa-exclamation-triangle"></i>
                    <div>
                        <h3>¿Emergencia con tu electrodoméstico?</h3>
                        <p>Llámanos ahora y un técnico se dirigirá a tu domicilio en menos de 2 horas</p>
                    </div>
                    <div class="emergency-phone">
                        <a href="tel:012345679" class="btn btn-emergency">
                            <i class="fas fa-phone"></i>
                            <?php echo e($salesInfo->phone); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    <section class="contact-cards" id="contacto">
        <div class="container">
            <h2 class="section-title">
                CONTÁCTANOS <span>hoy</span>
            </h2>
            <p class="section-subtitle">Estamos aquí para ayudarte en todo lo que necesites</p>

            <div class="cards-grid">
                <div class="contact-card blue">
                    <h3>Cotiza aquí</h3>
                    <div class="contact-info">
                        
                        <div>
                            <p><strong>ingresa a cotizar</strong></p>
                            <p>te llegara un mensaje a tu correo</p>
                        </div>
                    </div>
                </div>

                <div class="contact-card white">
                    <h3>Servicio Técnico</h3>
                    <div class="contact-info">
                        <i class="fas fa-tools"></i>
                        <div>
                            <p><strong><?php echo e($salesInfo->name ?? 'Lima'); ?></strong></p>
                            <p><?php echo e($salesInfo->phone ?? '(01) 234-5679'); ?></p>
                            <p><?php echo e($salesInfo->email); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Contact Form -->
            <div class="contact-form-section">
                <div class="contact-form-container">
                    <div class="contact-form-info">
                        <h3>Envíanos un mensaje</h3>
                        <p>¿Tienes alguna pregunta? Completa el formulario y te responderemos a la brevedad.</p>
                        <div class="contact-details">
                            <div class="contact-detail">
                                <i class="fas fa-map-marker-alt"></i>
                                <div>
                                    <h4>Dirección</h4>
                                    <p><?php echo e($salesInfo->address ?? 'Av. Principal 123, Lima'); ?></p>
                                </div>
                            </div>
                            <div class="contact-detail">
                                <i class="fas fa-clock"></i>
                                <div>
                                    <h4>Horarios</h4>
                                    <p><?php echo $salesInfo
                                        ? str_replace('\n', '<br>', $salesInfo->hours)
                                        : ''; ?></p>
                                </div>
                            </div>
                            <div class="contact-detail">
                                <i class="fas fa-envelope"></i>
                                <div>
                                    <h4>Email</h4>
                                    <p><?php echo e($salesInfo->email ?? 'info@electromart.pe'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <form class="contact-form" id="contactForm">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <input type="text" name="name" placeholder="Tu nombre completo" required>
                        </div>
                        <div class="form-group">
                            <input type="email" name="email" placeholder="Tu correo electrónico" required>
                        </div>
                        <div class="form-group">
                            <input type="tel" name="phone" placeholder="Tu teléfono">
                        </div>
                        <div class="form-group">
                            <select name="subject" required>
                                <option value="">Selecciona un tema</option>
                                <option value="ventas">Consulta de ventas</option>
                                <option value="servicio">Servicio técnico</option>
                                <option value="garantia">Garantía</option>
                                <option value="otros">Otros</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <textarea name="message" placeholder="Tu mensaje" rows="5" required></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-paper-plane"></i>
                            Enviar mensaje
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>

   
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        // Formulario de contacto
        document.getElementById('contactForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const form = this;
            const formData = new FormData(form);
            const submitBtn = form.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;

            // Deshabilitar botón y mostrar loading
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Enviando...';

            // Convertir FormData a objeto
            const data = Object.fromEntries(formData);

            fetch("<?php echo e(route('contact.send.message')); ?>", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute(
                            'content')
                    },
                    body: JSON.stringify(data)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            title: '¡Mensaje Enviado!',
                            text: data.message,
                            icon: 'success',
                            confirmButtonText: 'Continuar'
                        });
                        form.reset();
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: data.message,
                            icon: 'error',
                            confirmButtonText: 'Entendido'
                        });
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire({
                        title: 'Error',
                        text: 'Error de conexión. Inténtalo nuevamente.',
                        icon: 'error',
                        confirmButtonText: 'Reintentar'
                    });
                })
                .finally(() => {
                    // Restaurar botón
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalText;
                });
        });

        // Funcionalidad para agregar productos al carrito
        function addToCart(productId, productName) {
            // Verificar si el usuario está logueado
            <?php if(auth()->guard()->guest()): ?>
            showLoginAlert();
            return;
        <?php endif; ?>

        fetch("<?php echo e(route('cart.add')); ?>", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    product_id: productId,
                    quantity: 1
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Actualizar contador del carrito
                    updateCartCount(data.cart_count);

                    Swal.fire({
                        title: '¡Producto agregado!',
                        text: `${productName} ha sido agregado a tu carrito`,
                        icon: 'success',
                        showCancelButton: true,
                        confirmButtonText: 'Ver carrito',
                        cancelButtonText: 'Continuar comprando',
                        confirmButtonColor: '#667eea'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Abrir modal del carrito o redirigir
                            window.location.href = "<?php echo e(route('Producto.index')); ?>#cart";
                        }
                    });
                } else {
                    Swal.fire({
                        title: 'Error',
                        text: data.message,
                        icon: 'error',
                        confirmButtonText: 'Entendido'
                    });
                }
            })
            .catch(error => {
                console.error('Error:', error);
                Swal.fire({
                    title: 'Error',
                    text: 'Error de conexión. Inténtalo nuevamente.',
                    icon: 'error',
                    confirmButtonText: 'Reintentar'
                });
            });
        }

        // Función para comprar ahora
        function buyNow(productId) {
            // Agregar al carrito y redirigir al checkout
            addToCart(productId, 'Producto');
            setTimeout(() => {
                window.location.href = "<?php echo e(route('checkout')); ?>";
            }, 1500);
        }

        // Función para vista rápida del producto
        function quickView(productId) {
            // Aquí podrías implementar un modal con detalles del producto
            Swal.fire({
                title: 'Vista rápida',
                text: 'Función de vista rápida en desarrollo',
                icon: 'info'
            });
        }

        // Función para agregar a lista de deseos
        function addToWishlist(productId) {
            <?php if(auth()->guard()->guest()): ?>
            showLoginAlert();
            return;
        <?php endif; ?>

        Swal.fire({
            title: 'Lista de deseos',
            text: 'Función de lista de deseos en desarrollo',
            icon: 'info'
        });
        }

        // Actualizar contador del carrito en el header
        function updateCartCount(count) {
            const cartCounter = document.querySelector('.cart-count');
            if (cartCounter) {
                cartCounter.textContent = count;
                cartCounter.style.display = count > 0 ? 'inline' : 'none';
            }
        }

        // Mostrar alerta para usuarios no logueados
        function showLoginAlert() {
            Swal.fire({
                title: 'Iniciar sesión requerido',
                text: 'Debes iniciar sesión para agregar productos al carrito',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Iniciar sesión',
                cancelButtonText: 'Cancelar',
                confirmButtonColor: '#667eea'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "<?php echo e(route('login')); ?>";
                }
            });
        }

        // Funcionalidad para cotizaciones (botones "Cotiza aquí")
        document.addEventListener('DOMContentLoaded', function() {
            // Cargar contador del carrito al cargar la página
            <?php if(auth()->guard()->check()): ?>
            fetch("<?php echo e(route('cart.count')); ?>")
                .then(response => response.json())
                .then(data => {
                    updateCartCount(data.count);
                })
                .catch(error => console.error('Error loading cart count:', error));
        <?php endif; ?>

        // Agregar evento click a las tarjetas de contacto
        const cotizarCards = document.querySelectorAll('.contact-card');

        cotizarCards.forEach(card => {
            if (card.querySelector('h3').textContent.includes('Cotiza')) {
                card.style.cursor = 'pointer';
                card.addEventListener('click', function() {
                    openQuoteModal();
                });
            }
        });
        });

        // Modal para solicitar cotización
        function openQuoteModal() {
            Swal.fire({
                title: 'Solicitar Cotización',
                html: `
            <form id="quoteForm" style="text-align: left;">
                <div style="margin-bottom: 1rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Nombre completo *</label>
                    <input type="text" id="quoteName" name="name" style="width: 100%; padding: 0.75rem; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div style="margin-bottom: 1rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Email *</label>
                    <input type="email" id="quoteEmail" name="email" style="width: 100%; padding: 0.75rem; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div style="margin-bottom: 1rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Teléfono *</label>
                    <input type="tel" id="quotePhone" name="phone" style="width: 100%; padding: 0.75rem; border: 2px solid #e9ecef; border-radius: 8px;" required>
                </div>
                <div style="margin-bottom: 1rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Producto de interés</label>
                    <input type="text" id="quoteProduct" name="product_name" placeholder="Ej: Refrigeradora Samsung 420L" style="width: 100%; padding: 0.75rem; border: 2px solid #e9ecef; border-radius: 8px;">
                </div>
                <div style="margin-bottom: 1rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Categoría</label>
                    <select id="quoteCategory" name="product_category" style="width: 100%; padding: 0.75rem; border: 2px solid #e9ecef; border-radius: 8px;">
                        <option value="">Seleccionar categoría</option>
                        <option value="refrigeracion">Línea Refrigeración</option>
                        <option value="lavanderia">Línea Lavandería</option>
                        <option value="cocina">Línea Cocina</option>
                        <option value="otros">Otros</option>
                    </select>
                </div>
                <div style="margin-bottom: 1rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Presupuesto estimado</label>
                    <select id="quoteBudget" name="budget_range" style="width: 100%; padding: 0.75rem; border: 2px solid #e9ecef; border-radius: 8px;">
                        <option value="">Seleccionar rango</option>
                        <option value="500-1000">S/ 500 - S/ 1,000</option>
                        <option value="1000-3000">S/ 1,000 - S/ 3,000</option>
                        <option value="3000-5000">S/ 3,000 - S/ 5,000</option>
                        <option value="5000-10000">S/ 5,000 - S/ 10,000</option>
                        <option value="10000+">Más de S/ 10,000</option>
                    </select>
                </div>
                <div style="margin-bottom: 1rem;">
                    <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Mensaje adicional</label>
                    <textarea id="quoteMessage" name="message" rows="3" placeholder="Cuéntanos más detalles sobre lo que necesitas..." style="width: 100%; padding: 0.75rem; border: 2px solid #e9ecef; border-radius: 8px; resize: vertical;"></textarea>
                </div>
            </form>
        `,
                showCancelButton: true,
                confirmButtonText: 'Solicitar Cotización',
                cancelButtonText: 'Cancelar',
                confirmButtonColor: '#667eea',
                width: '600px',
                preConfirm: () => {
                    const form = document.getElementById('quoteForm');
                    const formData = new FormData(form);

                    // Validar campos requeridos
                    if (!formData.get('name') || !formData.get('email') || !formData.get('phone')) {
                        Swal.showValidationMessage('Por favor completa todos los campos obligatorios');
                        return false;
                    }

                    // Validar email
                    const email = formData.get('email');
                    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                    if (!emailRegex.test(email)) {
                        Swal.showValidationMessage('Por favor ingresa un email válido');
                        return false;
                    }

                    return Object.fromEntries(formData);
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    sendQuoteRequest(result.value);
                }
            });
        }

        // Enviar solicitud de cotización
        function sendQuoteRequest(data) {
            fetch("<?php echo e(route('contact.request.quote')); ?>", {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify(data)
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Swal.fire({
                            title: '¡Cotización Solicitada!',
                            text: data.message,
                            icon: 'success',
                            confirmButtonText: 'Perfecto'
                        });
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: data.message,
                            icon: 'error',
                            confirmButtonText: 'Entendido'
                        });
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire({
                        title: 'Error',
                        text: 'Error de conexión. Inténtalo nuevamente.',
                        icon: 'error',
                        confirmButtonText: 'Reintentar'
                    });
                });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/index.blade.php ENDPATH**/ ?>