

<?php $__env->startSection('content'); ?>
<div class="checkout-container" style="margin-top: 200px;">
    <div class="checkout-header">
        <h1>Finalizar Compra</h1>
        <div class="checkout-steps">
            <div class="step active">
                <span class="step-number">1</span> 
                <span class="step-text">Carrito</span>
            </div>
            <div class="step active">
                <span class="step-number">2</span>
                <span class="step-text">Datos</span>
            </div>
            <div class="step">
                <span class="step-number">3</span>
                <span class="step-text">Pago</span>
            </div>
        </div>
    </div>

    <div class="checkout-content">
        <!-- Paso 1: Datos de Entrega -->
        <div id="step1" class="checkout-step">
            <div class="checkout-form">
                <h2>Datos de Entrega</h2>
                <form id="deliveryForm">
                    <?php echo csrf_field(); ?>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Nombre Completo</label>
                            <input type="text" name="full_name" value="<?php echo e(Session::get('user_name')); ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Teléfono</label>
                            <input type="tel" name="phone" required>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Dirección Completa</label>
                        <textarea name="address" rows="3" placeholder="Dirección, distrito, referencias" required></textarea>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Distrito</label>
                            <select name="district" required>
                                <option value="">Seleccionar distrito</option>
                                <option value="Lima">Lima</option>
                                <option value="Miraflores">Miraflores</option>
                                <option value="San Isidro">San Isidro</option>
                                <option value="Surco">Surco</option>
                                <option value="La Molina">La Molina</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Método de Pago</label>
                            <select name="payment_method" id="paymentMethod" required onchange="togglePaymentSteps()">
                                <option value="">Seleccionar método</option>
                                <option value="efectivo">Efectivo</option>
                                <option value="tarjeta">Tarjeta de Crédito/Débito</option>
                                <option value="transferencia">Transferencia Bancaria</option>
                            </select>
                        </div>
                    </div>

                    <button type="button" class="btn btn-primary btn-large" onclick="nextStep(1)">
                        Continuar al Pago <i class="fas fa-arrow-right"></i>
                    </button>
                </form>
            </div>
        </div>

        <!-- Paso 2: Información de Pago -->
        <div id="step2" class="checkout-step" style="display: none;">
            <div class="checkout-form">
                <h2>Información de Pago</h2>
                
                <!-- Formulario de Tarjeta de Crédito -->
                <div id="cardForm" style="display: none;">
                    <div class="card-display">
                        <div class="credit-card">
                            <div class="card-number" id="cardDisplay">#### #### #### ####</div>
                            <div class="card-info">
                                <div class="card-holder" id="cardHolderDisplay">NOMBRE DEL TITULAR</div>
                                <div class="card-expiry" id="cardExpiryDisplay">MM/AA</div>
                            </div>
                        </div>
                    </div>

                    <form id="paymentForm">
                        <div class="form-group">
                            <label>Número de Tarjeta</label>
                            <input type="text" name="card_number" id="cardNumber" placeholder="1234 5678 9012 3456" 
                                   maxlength="19" required oninput="formatCardNumber(this); validateCard()">
                            <small class="card-type" id="cardType"></small>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label>Nombre del Titular</label>
                                <input type="text" name="card_holder" id="cardHolder" placeholder="Como aparece en la tarjeta" 
                                       required oninput="updateCardDisplay()">
                            </div>
                            <div class="form-group">
                                <label>Fecha de Vencimiento</label>
                                <input type="text" name="card_expiry" id="cardExpiry" placeholder="MM/AA" 
                                       maxlength="5" required oninput="formatExpiry(this); updateCardDisplay()">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label>Código CVV</label>
                                <input type="text" name="card_cvv" id="cardCvv" placeholder="123" 
                                       maxlength="4" required oninput="validateCvv(this)">
                            </div>
                            <div class="form-group">
                                <label>Tipo de Tarjeta</label>
                                <select name="card_type" id="cardTypeSelect" required>
                                    <option value="">Seleccionar</option>
                                    <option value="credito">Crédito</option>
                                    <option value="debito">Débito</option>
                                </select>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Información para Efectivo -->
                <div id="cashInfo" style="display: none;">
                    <div class="payment-info-box">
                        <i class="fas fa-money-bill-wave fa-3x"></i>
                        <h3>Pago en Efectivo</h3>
                        <p>El pago se realizará contra entrega. Asegúrate de tener el monto exacto.</p>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i>
                            Nuestro personal llevará cambio hasta S/ 100.00
                        </div>
                    </div>
                </div>

                <!-- Información para Transferencia -->
                <div id="transferInfo" style="display: none;">
                    <div class="payment-info-box">
                        <i class="fas fa-university fa-3x"></i>
                        <h3>Transferencia Bancaria</h3>
                        <div class="bank-info">
                            <p><strong>Banco:</strong> BCP</p>
                            <p><strong>Cuenta:</strong> 123-456789-0-12</p>
                            <p><strong>CCI:</strong> 00212345678901234567</p>
                            <p><strong>Titular:</strong> ElectroMart S.A.C.</p>
                        </div>
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            Envía el voucher por WhatsApp al realizar la transferencia
                        </div>
                    </div>
                </div>

                <div class="form-buttons">
                    <button type="button" class="btn btn-secondary" onclick="prevStep(2)">
                        <i class="fas fa-arrow-left"></i> Regresar
                    </button>
                    <button type="button" class="btn btn-primary" onclick="nextStep(2)">
                        Finalizar Compra <i class="fas fa-check"></i>
                    </button>
                </div>
            </div>
        </div>

        <div class="checkout-summary">
            <h2>Resumen del Pedido</h2>
            <div id="checkoutItems">
                <!-- Los items se cargarán con JavaScript -->
            </div>
            
            <div class="summary-totals">
                <div class="total-line">
                    <span>Subtotal:</span>
                    <span id="subtotalAmount">S/ 0.00</span>
                </div>
                <div class="total-line">
                    <span>Envío:</span>
                    <span>Gratis</span>
                </div>
                <div class="total-line total">
                    <span>Total:</span>
                    <span id="totalAmount">S/ 0.00</span>
                </div>
            </div>

            <button class="btn btn-primary btn-large" onclick="processOrder()">
                <i class="fas fa-credit-card"></i>
                Procesar Pedido
            </button>
        </div>
    </div>
</div>

<style>
.checkout-container {
    max-width: 1200px;
    margin: 2rem auto;
    padding: 0 1rem;
}

.checkout-header {
    text-align: center;
    margin-bottom: 2rem;
}

.checkout-steps {
    display: flex;
    justify-content: center;
    gap: 2rem;
    margin-top: 1rem;
}

.step {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #ccc;
}

.step.active {
    color: #007bff;
}

.step-number {
    width: 30px;
    height: 30px;
    border-radius: 50%;
    background: #e0e0e0;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
}

.step.active .step-number {
    background: #007bff;
    color: white;
}

.checkout-content {
    display: grid;
    grid-template-columns: 1fr 400px;
    gap: 2rem;
}

.checkout-step {
    display: block;
}

.checkout-form {
    background: white;
    padding: 2rem;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.form-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
}

.form-group {
    margin-bottom: 1rem;
}

.form-group label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
}

.form-group input,
.form-group select,
.form-group textarea {
    width: 100%;
    padding: 12px;
    border: 1px solid #ddd;
    border-radius: 5px;
    font-size: 14px;
}

.form-group small.card-type {
    color: #28a745;
    font-weight: bold;
    font-size: 12px;
}

/* Estilos de la tarjeta de crédito */
.card-display {
    margin-bottom: 2rem;
    perspective: 1000px;
}

.credit-card {
    width: 350px;
    height: 200px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 15px;
    padding: 20px;
    color: white;
    position: relative;
    box-shadow: 0 8px 20px rgba(0,0,0,0.3);
    margin: 0 auto;
    transform-style: preserve-3d;
    transition: transform 0.3s ease;
}

.credit-card:hover {
    transform: rotateY(10deg) rotateX(5deg);
}

.card-number {
    font-family: 'Courier New', monospace;
    font-size: 22px;
    letter-spacing: 3px;
    margin-top: 60px;
    margin-bottom: 20px;
}

.card-info {
    display: flex;
    justify-content: space-between;
    align-items: end;
}

.card-holder {
    font-size: 14px;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.card-expiry {
    font-family: 'Courier New', monospace;
    font-size: 16px;
}

/* Estilos para información de pago */
.payment-info-box {
    text-align: center;
    padding: 3rem 2rem;
    background: #f8f9fa;
    border-radius: 10px;
    border: 2px dashed #dee2e6;
}

.payment-info-box i {
    color: #007bff;
    margin-bottom: 1rem;
}

.payment-info-box h3 {
    margin-bottom: 1rem;
    color: #333;
}

.bank-info {
    background: white;
    padding: 1.5rem;
    border-radius: 8px;
    margin: 1rem 0;
    text-align: left;
}

.bank-info p {
    margin: 0.5rem 0;
    font-size: 16px;
}

.alert {
    padding: 12px 16px;
    border-radius: 6px;
    margin: 1rem 0;
    display: flex;
    align-items: center;
    gap: 10px;
}

.alert-info {
    background-color: #d1ecf1;
    border: 1px solid #bee5eb;
    color: #0c5460;
}

.alert-warning {
    background-color: #fff3cd;
    border: 1px solid #ffeaa7;
    color: #856404;
}

.form-buttons {
    display: flex;
    gap: 1rem;
    margin-top: 2rem;
}

.form-buttons .btn {
    flex: 1;
}

.btn-secondary {
    background: #6c757d;
    color: white;
    border: none;
}

.btn-secondary:hover {
    background: #5a6268;
}

.checkout-summary {
    background: white;
    padding: 2rem;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    height: fit-content;
}

.checkout-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 0;
    border-bottom: 1px solid #eee;
}

.checkout-item img {
    width: 60px;
    height: 60px;
    object-fit: cover;
    border-radius: 5px;
}

.item-details {
    flex: 1;
}

.item-name {
    font-weight: 500;
    margin-bottom: 0.25rem;
}

.item-price {
    color: #666;
    font-size: 14px;
}

.item-total {
    font-weight: bold;
    color: #007bff;
}

.summary-totals {
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid #eee;
}

.total-line {
    display: flex;
    justify-content: space-between;
    margin-bottom: 0.5rem;
}

.total-line.total {
    font-weight: bold;
    font-size: 18px;
    padding-top: 0.5rem;
    border-top: 1px solid #eee;
}

.btn-large {
    width: 100%;
    padding: 15px;
    font-size: 16px;
    margin-top: 1rem;
}

@media (max-width: 768px) {
    .checkout-content {
        grid-template-columns: 1fr;
    }
    
    .form-row {
        grid-template-columns: 1fr;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
let currentStep = 1;
let orderData = {};

function loadCheckoutItems() {
    fetch("<?php echo e(route('cart.items')); ?>")
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                let itemsHtml = '';
                data.items.forEach(function(item) {
                    const price = parseFloat(item.price);
                    const subtotal = parseFloat(item.subtotal);
                    
                    itemsHtml += `
                        <div class="checkout-item">
                            <img src="${item.image}" alt="${item.name}">
                            <div class="item-details">
                                <div class="item-name">${item.name}</div>
                                <div class="item-price">Cantidad: ${item.quantity} | S/ ${price.toFixed(2)}</div>
                            </div>
                            <div class="item-total">
                                S/ ${subtotal.toFixed(2)}
                            </div>
                        </div>
                    `;
                });
                
                document.getElementById('checkoutItems').innerHTML = itemsHtml;
                document.getElementById('subtotalAmount').textContent = data.formatted_total;
                document.getElementById('totalAmount').textContent = data.formatted_total;
            } else {
                console.error('Error al cargar items del carrito:', data.message);
            }
        })
        .catch(error => {
            console.error('Error al cargar carrito:', error);
        });
}

function updateSteps(step) {
    const steps = document.querySelectorAll('.step');
    steps.forEach((stepEl, index) => {
        if (index < step) {
            stepEl.classList.add('active');
        } else {
            stepEl.classList.remove('active');
        }
    });
}

function togglePaymentSteps() {
    const paymentMethod = document.getElementById('paymentMethod').value;
    const cardForm = document.getElementById('cardForm');
    const cashInfo = document.getElementById('cashInfo');
    const transferInfo = document.getElementById('transferInfo');
    
    // Ocultar todos los formularios de pago
    cardForm.style.display = 'none';
    cashInfo.style.display = 'none';
    transferInfo.style.display = 'none';
    
    // Mostrar el formulario correspondiente
    if (paymentMethod === 'tarjeta') {
        cardForm.style.display = 'block';
    } else if (paymentMethod === 'efectivo') {
        cashInfo.style.display = 'block';
    } else if (paymentMethod === 'transferencia') {
        transferInfo.style.display = 'block';
    }
}

function nextStep(step) {
    if (step === 1) {
        // Validar datos de entrega
        const form = document.getElementById('deliveryForm');
        if (!form.checkValidity()) {
            form.reportValidity();
            return;
        }
        
        // Guardar datos del formulario
        const formData = new FormData(form);
        orderData.full_name = formData.get('full_name');
        orderData.phone = formData.get('phone');
        orderData.address = formData.get('address');
        orderData.district = formData.get('district');
        orderData.payment_method = formData.get('payment_method');
        
        // Mostrar paso 2
        document.getElementById('step1').style.display = 'none';
        document.getElementById('step2').style.display = 'block';
        currentStep = 2;
        updateSteps(2);
        
        // Configurar el formulario de pago según el método seleccionado
        togglePaymentSteps();
        
    } else if (step === 2) {
        // Validar información de pago si es tarjeta
        if (orderData.payment_method === 'tarjeta') {
            if (!validatePaymentForm()) {
                return;
            }
            
            // Guardar datos de tarjeta
            const paymentForm = document.getElementById('paymentForm');
            const paymentData = new FormData(paymentForm);
            orderData.card_number = paymentData.get('card_number');
            orderData.card_holder = paymentData.get('card_holder');
            orderData.card_expiry = paymentData.get('card_expiry');
            orderData.card_cvv = paymentData.get('card_cvv');
            orderData.card_type = paymentData.get('card_type');
        }
        
        currentStep = 3;
        updateSteps(3);
        processOrder();
    }
}

function prevStep(step) {
    if (step === 2) {
        document.getElementById('step2').style.display = 'none';
        document.getElementById('step1').style.display = 'block';
        currentStep = 1;
        updateSteps(1);
    }
}

function validatePaymentForm() {
    const cardNumber = document.getElementById('cardNumber').value;
    const cardHolder = document.getElementById('cardHolder').value;
    const cardExpiry = document.getElementById('cardExpiry').value;
    const cardCvv = document.getElementById('cardCvv').value;
    const cardType = document.getElementById('cardTypeSelect').value;
    
    if (!cardNumber || !cardHolder || !cardExpiry || !cardCvv || !cardType) {
        Swal.fire({
            title: 'Datos Incompletos',
            text: 'Por favor completa todos los campos de la tarjeta',
            icon: 'warning',
            confirmButtonText: 'Entendido'
        });
        return false;
    }
    
    // Validar número de tarjeta (Luhn algorithm simple)
    if (!isValidCardNumber(cardNumber.replace(/\s/g, ''))) {
        Swal.fire({
            title: 'Tarjeta Inválida',
            text: 'El número de tarjeta no es válido',
            icon: 'error',
            confirmButtonText: 'Corregir'
        });
        return false;
    }
    
    // Validar fecha de vencimiento
    if (!isValidExpiry(cardExpiry)) {
        Swal.fire({
            title: 'Fecha Inválida',
            text: 'La fecha de vencimiento debe ser futura',
            icon: 'error',
            confirmButtonText: 'Corregir'
        });
        return false;
    }
    
    // Validar CVV
    if (cardCvv.length < 3 || cardCvv.length > 4) {
        Swal.fire({
            title: 'CVV Inválido',
            text: 'El código CVV debe tener 3 o 4 dígitos',
            icon: 'error',
            confirmButtonText: 'Corregir'
        });
        return false;
    }
    
    return true;
}

function formatCardNumber(input) {
    let value = input.value.replace(/\D/g, '');
    value = value.replace(/(\d{4})(?=\d)/g, '$1 ');
    input.value = value;
    updateCardDisplay();
}

function formatExpiry(input) {
    let value = input.value.replace(/\D/g, '');
    if (value.length >= 2) {
        value = value.substring(0, 2) + '/' + value.substring(2, 4);
    }
    input.value = value;
}

function validateCard() {
    const cardNumber = document.getElementById('cardNumber').value.replace(/\s/g, '');
    const cardType = document.getElementById('cardType');
    
    if (cardNumber.startsWith('4')) {
        cardType.textContent = 'Visa';
        cardType.style.color = '#1a1f71';
    } else if (cardNumber.startsWith('5') || cardNumber.startsWith('2')) {
        cardType.textContent = 'Mastercard';
        cardType.style.color = '#eb001b';
    } else if (cardNumber.startsWith('3')) {
        cardType.textContent = 'American Express';
        cardType.style.color = '#006fcf';
    } else {
        cardType.textContent = '';
    }
}

function validateCvv(input) {
    input.value = input.value.replace(/\D/g, '');
}

function updateCardDisplay() {
    const cardNumber = document.getElementById('cardNumber').value || '#### #### #### ####';
    const cardHolder = document.getElementById('cardHolder').value || 'NOMBRE DEL TITULAR';
    const cardExpiry = document.getElementById('cardExpiry').value || 'MM/AA';
    
    document.getElementById('cardDisplay').textContent = cardNumber;
    document.getElementById('cardHolderDisplay').textContent = cardHolder.toUpperCase();
    document.getElementById('cardExpiryDisplay').textContent = cardExpiry;
}

function isValidCardNumber(cardNumber) {
    // Algoritmo Luhn simplificado
    let sum = 0;
    let shouldDouble = false;
    
    for (let i = cardNumber.length - 1; i >= 0; i--) {
        let digit = parseInt(cardNumber.charAt(i));
        
        if (shouldDouble) {
            digit *= 2;
            if (digit > 9) {
                digit -= 9;
            }
        }
        
        sum += digit;
        shouldDouble = !shouldDouble;
    }
    
    return (sum % 10) === 0 && cardNumber.length >= 13 && cardNumber.length <= 19;
}

function isValidExpiry(expiry) {
    const [month, year] = expiry.split('/');
    const now = new Date();
    const currentYear = now.getFullYear() % 100;
    const currentMonth = now.getMonth() + 1;
    
    const expMonth = parseInt(month);
    const expYear = parseInt(year);
    
    if (expMonth < 1 || expMonth > 12) return false;
    if (expYear < currentYear) return false;
    if (expYear === currentYear && expMonth < currentMonth) return false;
    
    return true;
}

function processOrder() {
    Swal.fire({
        title: 'Procesando...',
        text: 'Validando información de pago',
        allowOutsideClick: false,
        showConfirmButton: false,
        willOpen: () => {
            Swal.showLoading();
        }
    });
    
    // Simular validación de tarjeta (2 segundos)
    setTimeout(() => {
        fetch("<?php echo e(route('order.process')); ?>", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(orderData)
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Marcar que el proceso está completo
                sessionStorage.setItem('orderCompleted', 'true');
                
                Swal.fire({
                    title: '¡Pago Exitoso!',
                    text: `Tu pedido #${data.order_id} ha sido procesado correctamente.`,
                    icon: 'success',
                    confirmButtonText: 'Ver Detalles',
                    allowOutsideClick: false,
                    allowEscapeKey: false
                }).then(() => {
                    // Redirigir a la página de éxito
                    if (data.redirect_url) {
                        window.location.href = data.redirect_url;
                    } else {
                        window.location.href = `/order-success/${data.order_id}`;
                    }
                });
            } else {
                Swal.fire({
                    title: 'Error en el Pago',
                    text: data.message || 'Error al procesar el pedido',
                    icon: 'error',
                    confirmButtonText: 'Intentar de nuevo'
                });
            }
        })
        .catch(error => {
            console.error('Error:', error);
            Swal.fire({
                title: 'Error',
                text: 'Error al procesar el pedido',
                icon: 'error',
                confirmButtonText: 'Intentar de nuevo'
            });
        });
    }, 2000);
}

// Prevenir navegación hacia atrás durante el checkout
document.addEventListener('DOMContentLoaded', function() {
    // Limpiar cualquier variable de sessionStorage problemática
    sessionStorage.removeItem('orderCompleted');
    
    // Cargar items del checkout
    loadCheckoutItems();
    
    // Mensaje de advertencia al intentar cerrar la ventana (solo si hay datos en el formulario)
    window.addEventListener('beforeunload', function(e) {
        if (currentStep > 1) {
            const message = '¿Estás seguro que quieres salir? Perderás el progreso del checkout.';
            e.returnValue = message;
            return message;
        }
    });
});

document.addEventListener('DOMContentLoaded', function() {
    loadCheckoutItems();
    updateSteps(1);
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/checkout/index.blade.php ENDPATH**/ ?>