

<?php $__env->startSection('title', 'Dashboard - Panel de Administración'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <span class="breadcrumb-item active">Dashboard</span>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .dashboard-container {
        padding: 1.5rem;
    }
    
    .dashboard-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
        flex-wrap: wrap;
        gap: 1rem;
    }
    
    .dashboard-title h1 {
        font-size: 2rem;
        font-weight: 700;
        color: var(--gray-900);
        margin-bottom: 0.5rem;
    }
    
    .dashboard-title p {
        color: var(--gray-600);
        margin: 0;
    }
    
    .dashboard-filters {
        display: flex;
        gap: 1rem;
        align-items: center;
        flex-wrap: wrap;
    }
    
    .filter-group {
        display: flex;
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .filter-label {
        font-size: 0.875rem;
        font-weight: 600;
        color: var(--gray-700);
    }
    
    .filter-input {
        padding: 0.5rem;
        border: 2px solid var(--gray-200);
        border-radius: 6px;
        font-size: 0.875rem;
        min-width: 140px;
    }
    
    .btn-filter {
        background: #667eea;
        color: white;
        border: none;
        padding: 0.5rem 1rem;
        border-radius: 6px;
        cursor: pointer;
        font-weight: 600;
        margin-top: 1.25rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }
    
    .btn-filter:hover {
        background: #5a67d8;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 1.5rem;
        margin-bottom: 2rem;
    }
    
    .stat-card {
        background: white;
        padding: 1.5rem;
        border-radius: 12px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        border-left: 4px solid #667eea;
        transition: transform 0.2s;
    }
    
    .stat-card:hover {
        transform: translateY(-2px);
    }
    
    .stat-card.blue { border-left-color: #3b82f6; }
    .stat-card.green { border-left-color: #10b981; }
    .stat-card.yellow { border-left-color: #f59e0b; }
    .stat-card.purple { border-left-color: #8b5cf6; }
    .stat-card.red { border-left-color: #ef4444; }
    
    .stat-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .stat-icon {
        width: 48px;
        height: 48px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        color: white;
    }
    
    .stat-card.blue .stat-icon { background: #3b82f6; }
    .stat-card.green .stat-icon { background: #10b981; }
    .stat-card.yellow .stat-icon { background: #f59e0b; }
    .stat-card.purple .stat-icon { background: #8b5cf6; }
    .stat-card.red .stat-icon { background: #ef4444; }
    
    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        color: var(--gray-900);
        margin: 0 0 0.25rem 0;
    }
    
    .stat-label {
        color: var(--gray-600);
        font-size: 0.875rem;
        margin: 0;
    }
    
    .charts-grid {
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 1.5rem;
        margin-bottom: 2rem;
    }
    
    @media (max-width: 768px) {
        .charts-grid {
            grid-template-columns: 1fr;
        }
    }
    
    .chart-container {
        background: white;
        padding: 1.5rem;
        border-radius: 12px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    
    .chart-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1rem;
        flex-wrap: wrap;
        gap: 1rem;
    }
    
    .chart-title {
        font-size: 1.25rem;
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .chart-period {
        display: flex;
        gap: 0.5rem;
    }
    
    .period-btn {
        padding: 0.25rem 0.75rem;
        border: 1px solid var(--gray-300);
        background: white;
        border-radius: 4px;
        cursor: pointer;
        font-size: 0.875rem;
        transition: all 0.2s;
    }
    
    .period-btn.active,
    .period-btn:hover {
        background: #667eea;
        color: white;
        border-color: #667eea;
    }
    
    .content-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 1.5rem;
        margin-bottom: 2rem;
    }
    
    @media (max-width: 768px) {
        .content-grid {
            grid-template-columns: 1fr;
        }
    }
    
    .content-section {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    
    .section-header {
        padding: 1.5rem 1.5rem 1rem 1.5rem;
        border-bottom: 1px solid var(--gray-200);
    }
    
    .section-title {
        font-size: 1.125rem;
        font-weight: 600;
        color: var(--gray-900);
        margin: 0;
    }
    
    .section-content {
        padding: 1rem 1.5rem 1.5rem 1.5rem;
        max-height: 300px;
        overflow-y: auto;
    }
    
    .top-product, .recent-order {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 0.75rem 0;
        border-bottom: 1px solid var(--gray-100);
    }
    
    .top-product:last-child, .recent-order:last-child {
        border-bottom: none;
    }
    
    .product-info h4, .order-info h4 {
        font-size: 0.875rem;
        font-weight: 600;
        margin: 0 0 0.25rem 0;
        color: var(--gray-900);
    }
    
    .product-info p, .order-info p {
        font-size: 0.75rem;
        color: var(--gray-600);
        margin: 0;
    }
    
    .product-sales, .order-status {
        text-align: right;
    }
    
    .sales-number {
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .status-badge {
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
        white-space: nowrap;
    }
    
    .badge-warning { background: rgba(237, 137, 54, 0.1); color: #ed8936; }
    .badge-info { background: rgba(66, 153, 225, 0.1); color: #4299e1; }
    .badge-primary { background: rgba(102, 126, 234, 0.1); color: #667eea; }
    .badge-secondary { background: rgba(113, 128, 150, 0.1); color: #718096; }
    .badge-success { background: rgba(72, 187, 120, 0.1); color: #48bb78; }
    .badge-danger { background: rgba(245, 101, 101, 0.1); color: #f56565; }
    
    .loading-skeleton {
        background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
        background-size: 200% 100%;
        animation: loading 1.5s infinite;
        border-radius: 4px;
        height: 20px;
        margin-bottom: 10px;
    }
    
    @keyframes loading {
        0% { background-position: 200% 0; }
        100% { background-position: -200% 0; }
    }
    
    .chart-canvas {
        position: relative;
        height: 300px;
    }
    
    .error-message {
        color: #ef4444;
        font-size: 0.875rem;
        text-align: center;
        padding: 1rem;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-container">
    <!-- Header con filtros -->
    <div class="dashboard-header">
        <div class="dashboard-title">
            <h1>Dashboard</h1>
            <p>Bienvenido de vuelta, <?php echo e(Auth::user()->name); ?>. Aquí tienes un resumen de tu tienda.</p>
        </div>
        <div class="dashboard-filters">
            <div class="filter-group">
                <label class="filter-label">Desde</label>
                <input type="date" id="dateFrom" class="filter-input" value="<?php echo e(date('Y-m-01')); ?>">
            </div>
            <div class="filter-group">
                <label class="filter-label">Hasta</label>
                <input type="date" id="dateTo" class="filter-input" value="<?php echo e(date('Y-m-d')); ?>">
            </div>
            <button class="btn-filter" onclick="refreshData()">
                <i class="fas fa-sync"></i>
                Actualizar
            </button>
        </div>
    </div>
    
    <!-- Tarjetas de estadísticas -->
    <div class="stats-grid">
        <div class="stat-card blue">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="totalOrders">-</h3>
                    <p class="stat-label">Total Pedidos</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-shopping-cart"></i>
                </div>
            </div>
        </div>
        
        <div class="stat-card green">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="totalSales">S/ -</h3>
                    <p class="stat-label">Ventas Totales</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-dollar-sign"></i>
                </div>
            </div>
        </div>
        
        <div class="stat-card yellow">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="pendingOrders">-</h3>
                    <p class="stat-label">Pedidos Pendientes</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-clock"></i>
                </div>
            </div>
        </div>
        
        <div class="stat-card purple">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="totalProducts">-</h3>
                    <p class="stat-label">Productos Total</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-box"></i>
                </div>
            </div>
        </div>
        
        <div class="stat-card red">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="newMessages">-</h3>
                    <p class="stat-label">Mensajes Nuevos</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-envelope"></i>
                </div>
            </div>
        </div>
        
        <!-- Segunda fila de estadísticas -->
        <div class="stat-card blue">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="totalClients">-</h3>
                    <p class="stat-label">Clientes</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
            </div>
        </div>
        
        <div class="stat-card green">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="totalAdmins">-</h3>
                    <p class="stat-label">Administradores</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-user-shield"></i>
                </div>
            </div>
        </div>
        
        <div class="stat-card yellow">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="totalCategories">-</h3>
                    <p class="stat-label">Categorías</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-tags"></i>
                </div>
            </div>
        </div>
        
        <div class="stat-card purple">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="totalPosts">-</h3>
                    <p class="stat-label">Blog Posts</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-blog"></i>
                </div>
            </div>
        </div>
        
        <div class="stat-card red">
            <div class="stat-header">
                <div>
                    <h3 class="stat-number" id="deliveredOrders">-</h3>
                    <p class="stat-label">Pedidos Entregados</p>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Gráficos -->
    <div class="charts-grid">
        <div class="chart-container">
            <div class="chart-header">
                <h3 class="chart-title">Ventas Diarias</h3>
                <div class="chart-period">
                    <button class="period-btn" onclick="changePeriod(7)">7 días</button>
                    <button class="period-btn" onclick="changePeriod(15)">15 días</button>
                    <button class="period-btn active" onclick="changePeriod(30)">30 días</button>
                </div>
            </div>
            <div class="chart-canvas">
                <canvas id="salesChart"></canvas>
            </div>
        </div>
        
        <div class="chart-container">
            <div class="chart-header">
                <h3 class="chart-title">Estados de Pedidos</h3>
            </div>
            <div class="chart-canvas">
                <canvas id="ordersStatusChart"></canvas>
            </div>
        </div>
    </div>
    
    <!-- Contenido adicional -->
    <div class="content-grid">
        <div class="content-section">
            <div class="section-header">
                <h3 class="section-title">Productos Más Vendidos</h3>
            </div>
            <div class="section-content" id="topProductsList">
                <div class="loading-skeleton"></div>
                <div class="loading-skeleton"></div>
                <div class="loading-skeleton"></div>
            </div>
        </div>
        
        <div class="content-section">
            <div class="section-header">
                <h3 class="section-title">Pedidos Recientes</h3>
            </div>
            <div class="section-content" id="recentOrdersList">
                <div class="loading-skeleton"></div>
                <div class="loading-skeleton"></div>
                <div class="loading-skeleton"></div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
let salesChart = null;
let ordersChart = null;
let currentPeriod = 30;

// Cargar datos al iniciar
document.addEventListener('DOMContentLoaded', function() {
    console.log('🚀 Iniciando dashboard...');
    refreshData();
});

// Función para refrescar todos los datos
async function refreshData() {
    console.log('🔄 Refrescando datos del dashboard...');
    
    // Mostrar indicador de carga
    document.querySelectorAll('.stat-number').forEach(el => el.textContent = '-');
    
    try {
        await Promise.all([
            loadStats(),
            loadSalesChart(),
            loadOrdersStatusChart(),
            loadTopProducts(),
            loadRecentOrders()
        ]);
        console.log('✅ Dashboard cargado completamente');
    } catch (error) {
        console.error('❌ Error al cargar dashboard:', error);
        Swal.fire({
            title: 'Error',
            text: 'Error al cargar los datos del dashboard',
            icon: 'error'
        });
    }
}

// Cargar estadísticas principales
async function loadStats() {
    try {
        const dateFrom = document.getElementById('dateFrom').value;
        const dateTo = document.getElementById('dateTo').value;
        
        console.log('📊 Cargando estadísticas...', { dateFrom, dateTo });
        
        const response = await fetch(`<?php echo e(route('admin.dashboard.stats')); ?>?date_from=${dateFrom}&date_to=${dateTo}`);
        const result = await response.json();
        
        if (result.success) {
            const data = result.data;
            
            // Estadísticas de pedidos
            document.getElementById('totalOrders').textContent = data.orders.total || 0;
            document.getElementById('totalSales').textContent = 'S/ ' + (data.orders.total_sales || '0.00');
            document.getElementById('pendingOrders').textContent = data.orders.pending || 0;
            document.getElementById('deliveredOrders').textContent = data.orders.delivered || 0;
            
            // Estadísticas de productos
            document.getElementById('totalProducts').textContent = data.products.total || 0;
            document.getElementById('totalCategories').textContent = data.products.categories || 0;
            
            // Estadísticas de usuarios
            document.getElementById('totalClients').textContent = data.users.clients || 0;
            document.getElementById('totalAdmins').textContent = data.users.admins || 0;
            
            // Estadísticas de mensajes
            document.getElementById('newMessages').textContent = data.messages.new || 0;
            
            // Estadísticas del blog
            document.getElementById('totalPosts').textContent = data.blog.total || 0;
            
            console.log('✅ Estadísticas cargadas exitosamente');
        } else {
            console.warn('⚠️ Error en respuesta:', result.message);
            // Mostrar valores por defecto en caso de error
            document.getElementById('totalOrders').textContent = '0';
            document.getElementById('totalSales').textContent = 'S/ 0.00';
            document.getElementById('pendingOrders').textContent = '0';
            document.getElementById('deliveredOrders').textContent = '0';
            document.getElementById('totalProducts').textContent = '0';
            document.getElementById('totalCategories').textContent = '0';
            document.getElementById('totalClients').textContent = '0';
            document.getElementById('totalAdmins').textContent = '0';
            document.getElementById('newMessages').textContent = '0';
            document.getElementById('totalPosts').textContent = '0';
        }
    } catch (error) {
        console.error('❌ Error al cargar estadísticas:', error);
        // Mostrar "Error" en todas las estadísticas
        document.getElementById('totalOrders').textContent = 'Error';
        document.getElementById('totalSales').textContent = 'Error';
        document.getElementById('pendingOrders').textContent = 'Error';
        document.getElementById('deliveredOrders').textContent = 'Error';
        document.getElementById('totalProducts').textContent = 'Error';
        document.getElementById('totalCategories').textContent = 'Error';
        document.getElementById('totalClients').textContent = 'Error';
        document.getElementById('totalAdmins').textContent = 'Error';
        document.getElementById('newMessages').textContent = 'Error';
        document.getElementById('totalPosts').textContent = 'Error';
        
        // Mostrar notificación de error al usuario
        if (typeof Swal !== 'undefined') {
            Swal.fire({
                title: 'Error',
                text: 'No se pudieron cargar las estadísticas del dashboard',
                icon: 'error',
                timer: 3000,
                showConfirmButton: false
            });
        }
    }
}

// Cargar gráfico de ventas
async function loadSalesChart() {
    try {
        console.log('📈 Cargando gráfico de ventas...');
        
        const response = await fetch(`<?php echo e(route('admin.dashboard.sales-chart')); ?>?days=${currentPeriod}`);
        const result = await response.json();
        
        if (result.success) {
            const ctx = document.getElementById('salesChart').getContext('2d');
            
            if (salesChart) {
                salesChart.destroy();
            }
            
            salesChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: result.data.labels,
                    datasets: [{
                        label: 'Ventas (S/)',
                        data: result.data.sales,
                        borderColor: '#3b82f6',
                        backgroundColor: 'rgba(59, 130, 246, 0.1)',
                        tension: 0.4,
                        fill: true,
                        pointBackgroundColor: '#3b82f6',
                        pointBorderColor: '#3b82f6',
                        pointHoverBackgroundColor: '#1d4ed8',
                        pointHoverBorderColor: '#1d4ed8'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return 'Ventas: S/ ' + context.parsed.y.toFixed(2);
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                callback: function(value) {
                                    return 'S/ ' + value.toFixed(0);
                                }
                            }
                        }
                    }
                }
            });
            console.log('✅ Gráfico de ventas cargado');
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('❌ Error al cargar gráfico de ventas:', error);
        document.getElementById('salesChart').parentElement.innerHTML = '<div class="error-message">Error al cargar gráfico de ventas</div>';
    }
}

// Cargar gráfico de estados de pedidos
async function loadOrdersStatusChart() {
    try {
        console.log('🥧 Cargando gráfico de estados...');
        
        const dateFrom = document.getElementById('dateFrom').value;
        const dateTo = document.getElementById('dateTo').value;
        
        const response = await fetch(`<?php echo e(route('admin.dashboard.orders-status-chart')); ?>?date_from=${dateFrom}&date_to=${dateTo}`);
        const result = await response.json();
        
        if (result.success) {
            const ctx = document.getElementById('ordersStatusChart').getContext('2d');
            
            if (ordersChart) {
                ordersChart.destroy();
            }
            
            ordersChart = new Chart(ctx, {
                type: 'doughnut',
                data: {
                    labels: result.data.labels,
                    datasets: [{
                        data: result.data.data,
                        backgroundColor: [
                            '#ed8936', // Pendientes
                            '#4299e1', // Confirmados
                            '#667eea', // En preparación
                            '#718096', // Enviados
                            '#48bb78', // Entregados
                            '#f56565'  // Cancelados
                        ],
                        borderWidth: 2,
                        borderColor: '#ffffff'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                padding: 15,
                                usePointStyle: true
                            }
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return context.label + ': ' + context.parsed + ' pedidos';
                                }
                            }
                        }
                    }
                }
            });
            console.log('✅ Gráfico de estados cargado');
        } else {
            throw new Error(result.message);
        }
    } catch (error) {
        console.error('❌ Error al cargar gráfico de estados:', error);
        document.getElementById('ordersStatusChart').parentElement.innerHTML = '<div class="error-message">Error al cargar gráfico de estados</div>';
    }
}

// Cargar productos más vendidos
async function loadTopProducts() {
    try {
        console.log('🏆 Cargando productos más vendidos...');
        
        const dateFrom = document.getElementById('dateFrom').value;
        const dateTo = document.getElementById('dateTo').value;
        
        const response = await fetch(`<?php echo e(route('admin.dashboard.top-products')); ?>?date_from=${dateFrom}&date_to=${dateTo}&limit=5`);
        const result = await response.json();
        
        if (result.success && result.data.length > 0) {
            const container = document.getElementById('topProductsList');
            container.innerHTML = result.data.map((product, index) => `
                <div class="top-product">
                    <div class="product-info">
                        <h4><span style="color: #667eea; font-weight: 700;">#${index + 1}</span> ${product.product_name}</h4>
                        <p>${product.total_quantity} unidades vendidas</p>
                    </div>
                    <div class="product-sales">
                        <div class="sales-number">S/ ${parseFloat(product.total_sales).toFixed(2)}</div>
                    </div>
                </div>
            `).join('');
            console.log('✅ Productos más vendidos cargados');
        } else {
            document.getElementById('topProductsList').innerHTML = '<p style="text-align: center; color: var(--gray-500); padding: 2rem;">No hay datos de productos en el período seleccionado.</p>';
        }
    } catch (error) {
        console.error('❌ Error al cargar productos más vendidos:', error);
        document.getElementById('topProductsList').innerHTML = '<div class="error-message">Error al cargar productos</div>';
    }
}

// Cargar pedidos recientes
async function loadRecentOrders() {
    try {
        console.log('📋 Cargando pedidos recientes...');
        
        const response = await fetch(`<?php echo e(route('admin.dashboard.recent-orders')); ?>?limit=5`);
        const result = await response.json();
        
        if (result.success && result.data.length > 0) {
            const container = document.getElementById('recentOrdersList');
            container.innerHTML = result.data.map(order => `
                <div class="recent-order">
                    <div class="order-info">
                        <h4>${order.order_number}</h4>
                        <p>${order.customer_name} - S/ ${order.total}</p>
                    </div>
                    <div class="order-status">
                        <span class="status-badge ${order.status_class}">${order.status_label}</span>
                        <div style="font-size: 0.75rem; color: var(--gray-600); margin-top: 0.25rem;">
                            ${order.created_at}
                        </div>
                    </div>
                </div>
            `).join('');
            console.log('✅ Pedidos recientes cargados');
        } else {
            document.getElementById('recentOrdersList').innerHTML = '<p style="text-align: center; color: var(--gray-500); padding: 2rem;">No hay pedidos recientes.</p>';
        }
    } catch (error) {
        console.error('❌ Error al cargar pedidos recientes:', error);
        document.getElementById('recentOrdersList').innerHTML = '<div class="error-message">Error al cargar pedidos</div>';
    }
}

// Cambiar período del gráfico de ventas
function changePeriod(days) {
    currentPeriod = days;
    console.log('📅 Cambiando período a', days, 'días');
    
    // Actualizar botones activos
    document.querySelectorAll('.period-btn').forEach(btn => btn.classList.remove('active'));
    event.target.classList.add('active');
    
    // Recargar gráfico
    loadSalesChart();
}

// Función para mostrar notificación de éxito
function showSuccessNotification() {
    Swal.fire({
        title: '¡Actualizado!',
        text: 'Dashboard actualizado correctamente',
        icon: 'success',
        timer: 2000,
        showConfirmButton: false,
        toast: true,
        position: 'top-end'
    });
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('administrador.include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/administrador/index.blade.php ENDPATH**/ ?>