

<?php $__env->startSection('title', 'Gestión de Mensajes'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <span class="breadcrumb-item">Comunicación</span>
    <span class="breadcrumb-item active">Mensajes de Contacto</span>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .messages-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 2rem;
    }
    
    .messages-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: var(--gray-900);
    }
    
    .messages-table {
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    
    .table-responsive {
        overflow-x: auto;
    }
    
    .table {
        width: 100%;
        margin-bottom: 0;
        color: var(--gray-700);
    }
    
    .table thead th {
        background: var(--gray-50);
        border-bottom: 1px solid var(--gray-200);
        padding: 1rem;
        font-weight: 600;
        text-transform: uppercase;
        font-size: 0.75rem;
        letter-spacing: 0.5px;
        color: var(--gray-600);
    }
    
    .table tbody td {
        padding: 1rem;
        border-bottom: 1px solid var(--gray-100);
        vertical-align: middle;
    }
    
    .table tbody tr:hover {
        background: var(--gray-50);
    }
    
    .badge {
        padding: 0.25rem 0.75rem;
        border-radius: 20px;
        font-size: 0.75rem;
        font-weight: 600;
    }
    
    .badge-primary {
        background: rgba(102, 126, 234, 0.1);
        color: #667eea;
    }
    
    .badge-info {
        background: rgba(66, 153, 225, 0.1);
        color: #4299e1;
    }
    
    .badge-success {
        background: rgba(72, 187, 120, 0.1);
        color: #48bb78;
    }
    
    .badge-secondary {
        background: rgba(113, 128, 150, 0.1);
        color: #718096;
    }
    
    .action-buttons {
        display: flex;
        gap: 0.5rem;
    }
    
    .btn-action {
        width: 32px;
        height: 32px;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.875rem;
        transition: all 0.3s ease;
    }
    
    .btn-view {
        background: rgba(66, 153, 225, 0.1);
        color: var(--info-color);
    }
    
    .btn-answer {
        background: rgba(72, 187, 120, 0.1);
        color: var(--success-color);
    }
    
    .btn-delete {
        background: rgba(245, 101, 101, 0.1);
        color: var(--danger-color);
    }
    
    .btn-action:hover {
        transform: scale(1.1);
    }
    
    .loading-spinner {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 200px;
    }
    
    .spinner {
        width: 40px;
        height: 40px;
        border: 4px solid var(--gray-200);
        border-top: 4px solid var(--primary-color);
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }
    
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    
    .empty-state {
        text-align: center;
        padding: 3rem;
        color: var(--gray-500);
    }
    
    .empty-state i {
        font-size: 3rem;
        margin-bottom: 1rem;
        color: var(--gray-300);
    }
    
    .message-preview {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
    
    .stats-container {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 1rem;
        margin-bottom: 2rem;
    }
    
    .stat-card {
        background: white;
        padding: 1.5rem;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        text-align: center;
    }
    
    .stat-number {
        font-size: 2rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    
    .stat-label {
        font-size: 0.875rem;
        color: var(--gray-600);
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="messages-container">
    <div class="messages-header">
        <h1 class="messages-title">
            <i class="fas fa-envelope"></i>
            Mensajes de Contacto
        </h1>
    </div>
    
    <!-- Estadísticas -->
    <div class="stats-container" id="statsContainer">
        <div class="stat-card">
            <div class="stat-number" style="color: #667eea;" id="nuevosCount">0</div>
            <div class="stat-label">Nuevos</div>
        </div>
        <div class="stat-card">
            <div class="stat-number" style="color: #4299e1;" id="leidosCount">0</div>
            <div class="stat-label">Leídos</div>
        </div>
        <div class="stat-card">
            <div class="stat-number" style="color: #48bb78;" id="respondidosCount">0</div>
            <div class="stat-label">Respondidos</div>
        </div>
        <div class="stat-card">
            <div class="stat-number" style="color: #667eea;" id="totalCount">0</div>
            <div class="stat-label">Total</div>
        </div>
    </div>
    
    <div class="messages-table">
        <div class="table-responsive">
            <table class="table" id="messagesTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nombre</th>
                        <th>Email</th>
                        <th>Teléfono</th>
                        <th>Asunto</th>
                        <th>Mensaje</th>
                        <th>Estado</th>
                        <th>Fecha</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="messagesTableBody">
                    <tr>
                        <td colspan="9">
                            <div class="loading-spinner">
                                <div class="spinner"></div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Cargar mensajes al cargar la página
document.addEventListener('DOMContentLoaded', function() {
    loadMessages();
});

// Cargar mensajes
async function loadMessages() {
    console.log('🔄 Iniciando carga de mensajes...');
    try {
        const url = '<?php echo e(route("admin.messages.data")); ?>';
        console.log('📡 URL de solicitud:', url);
        
        const response = await fetch(url);
        console.log('📊 Respuesta recibida:', response.status, response.statusText);
        
        const result = await response.json();
        console.log('📋 Datos recibidos:', result);
        
        const tbody = document.getElementById('messagesTableBody');
        
        if (result.success && result.data.length > 0) {
            console.log('✅ Mensajes encontrados:', result.data.length);
            
            // Actualizar estadísticas
            updateStats(result.data);
            
            tbody.innerHTML = result.data.map(message => `
                <tr>
                    <td><strong>#${message.id}</strong></td>
                    <td>${message.name}</td>
                    <td><a href="mailto:${message.email}">${message.email}</a></td>
                    <td>${message.phone || '<em>No proporcionado</em>'}</td>
                    <td><span class="badge badge-info">${message.subject_name}</span></td>
                    <td><div class="message-preview" title="${message.message}">${message.message}</div></td>
                    <td><span class="badge ${message.status_class}">${getStatusText(message.status)}</span></td>
                    <td>${message.created_at}</td>
                    <td>
                        <div class="action-buttons">
                            <button class="btn-action btn-view" onclick="viewMessage(${message.id})" title="Ver mensaje completo">
                                <i class="fas fa-eye"></i>
                            </button>
                            ${message.status !== 'respondido' ? 
                                `<button class="btn-action btn-answer" onclick="markAsAnswered(${message.id})" title="Marcar como respondido">
                                    <i class="fas fa-check"></i>
                                </button>` : ''
                            }
                            <button class="btn-action btn-delete" onclick="deleteMessage(${message.id})" title="Eliminar mensaje">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            `).join('');
        } else {
            console.log('⚠️ No hay mensajes o error en datos');
            updateStats([]);
            tbody.innerHTML = `
                <tr>
                    <td colspan="9">
                        <div class="empty-state">
                            <i class="fas fa-envelope-open"></i>
                            <p>No hay mensajes de contacto</p>
                        </div>
                    </td>
                </tr>
            `;
        }
    } catch (error) {
        console.error('❌ Error al cargar mensajes:', error);
        const tbody = document.getElementById('messagesTableBody');
        tbody.innerHTML = `
            <tr>
                <td colspan="9">
                    <div class="empty-state">
                        <i class="fas fa-exclamation-triangle"></i>
                        <p>Error al cargar los mensajes</p>
                        <button class="btn-create" onclick="loadMessages()" style="margin-top: 1rem;">
                            <i class="fas fa-sync"></i>
                            Reintentar
                        </button>
                    </div>
                </td>
            </tr>
        `;
        Swal.fire({
            title: 'Error',
            text: 'No se pudieron cargar los mensajes: ' + error.message,
            icon: 'error'
        });
    }
}

// Actualizar estadísticas
function updateStats(messages) {
    const stats = {
        nuevos: messages.filter(m => m.status === 'nuevo').length,
        leidos: messages.filter(m => m.status === 'leido').length,
        respondidos: messages.filter(m => m.status === 'respondido').length,
        total: messages.length
    };
    
    document.getElementById('nuevosCount').textContent = stats.nuevos;
    document.getElementById('leidosCount').textContent = stats.leidos;
    document.getElementById('respondidosCount').textContent = stats.respondidos;
    document.getElementById('totalCount').textContent = stats.total;
}

// Obtener texto del estado en español
function getStatusText(status) {
    const statusTexts = {
        'nuevo': 'Nuevo',
        'leido': 'Leído',
        'respondido': 'Respondido',
        'cerrado': 'Cerrado'
    };
    return statusTexts[status] || status;
}

// Ver mensaje completo
async function viewMessage(id) {
    try {
        const response = await fetch(`<?php echo e(route("admin.messages.show", ":id")); ?>`.replace(':id', id));
        const result = await response.json();
        
        if (result.success) {
            const message = result.data;
            
            Swal.fire({
                title: `Mensaje de ${message.name}`,
                html: `
                    <div style="text-align: left; max-width: 500px;">
                        <div style="margin-bottom: 1rem;">
                            <strong>Email:</strong> <a href="mailto:${message.email}">${message.email}</a>
                        </div>
                        ${message.phone ? `
                            <div style="margin-bottom: 1rem;">
                                <strong>Teléfono:</strong> ${message.phone}
                            </div>
                        ` : ''}
                        <div style="margin-bottom: 1rem;">
                            <strong>Asunto:</strong> ${message.subject_name}
                        </div>
                        <div style="margin-bottom: 1rem;">
                            <strong>Estado:</strong> <span class="badge ${message.status_class}">${getStatusText(message.status)}</span>
                        </div>
                        <div style="margin-bottom: 1rem;">
                            <strong>Fecha:</strong> ${message.created_at}
                        </div>
                        <div style="margin-bottom: 1rem;">
                            <strong>Mensaje:</strong>
                            <div style="background: #f7fafc; padding: 1rem; border-radius: 8px; margin-top: 0.5rem; border-left: 4px solid #667eea;">
                                ${message.message.replace(/\n/g, '<br>')}
                            </div>
                        </div>
                    </div>
                `,
                icon: 'info',
                confirmButtonText: 'Cerrar',
                confirmButtonColor: '#667eea',
                width: '600px',
                showCancelButton: message.status !== 'respondido',
                cancelButtonText: message.status !== 'respondido' ? 'Marcar como Respondido' : null,
                cancelButtonColor: '#48bb78'
            }).then((result) => {
                if (result.dismiss === Swal.DismissReason.cancel && message.status !== 'respondido') {
                    markAsAnswered(id);
                }
            });
        }
    } catch (error) {
        console.error('Error al ver mensaje:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudieron cargar los detalles del mensaje',
            icon: 'error'
        });
    }
}

// Marcar como respondido
async function markAsAnswered(id) {
    try {
        const response = await fetch(`<?php echo e(route("admin.messages.answered", ":id")); ?>`.replace(':id', id), {
            method: 'PUT',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });
        
        const result = await response.json();
        
        if (result.success) {
            Swal.fire({
                title: '¡Actualizado!',
                text: result.message,
                icon: 'success',
                timer: 2000,
                showConfirmButton: false
            });
            loadMessages();
        } else {
            Swal.fire({
                title: 'Error',
                text: result.message,
                icon: 'error'
            });
        }
    } catch (error) {
        console.error('Error al marcar como respondido:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo actualizar el estado del mensaje',
            icon: 'error'
        });
    }
}

// Eliminar mensaje
function deleteMessage(id) {
    Swal.fire({
        title: '¿Estás seguro?',
        text: 'Esta acción no se puede deshacer. El mensaje será eliminado permanentemente.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            performDeleteMessage(id);
        }
    });
}

// Realizar eliminación
async function performDeleteMessage(id) {
    try {
        const response = await fetch(`<?php echo e(route("admin.messages.destroy", ":id")); ?>`.replace(':id', id), {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });
        
        const result = await response.json();
        
        if (result.success) {
            Swal.fire({
                title: '¡Eliminado!',
                text: result.message,
                icon: 'success',
                timer: 2000,
                showConfirmButton: false
            });
            loadMessages();
        } else {
            Swal.fire({
                title: 'Error',
                text: result.message,
                icon: 'error'
            });
        }
    } catch (error) {
        console.error('Error al eliminar mensaje:', error);
        Swal.fire({
            title: 'Error',
            text: 'No se pudo eliminar el mensaje',
            icon: 'error'
        });
    }
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('administrador.include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/administrador/messages/index.blade.php ENDPATH**/ ?>