

<?php $__env->startSection('content'); ?>
<div class="profile-container" style="width: 80%; margin: auto;margin-top:150px;">
    <div class="profile-header">
        <div class="profile-info">
            <div class="profile-avatar">
                <i class="fas fa-shopping-bag"></i>
            </div>
            <div class="profile-details">
                <h1>Mis Pedidos</h1>
                <p class="profile-subtitle">Historial completo de tus compras</p>
            </div>
        </div>
        
    </div>

    <div class="profile-content">
       
        <div class="profile-main">
            <?php if($orders->count() > 0): ?>
                <div class="orders-filters">
                    <div class="filter-group">
                        <label>Filtrar por estado:</label>
                        <select id="statusFilter" class="filter-select">
                            <option value="">Todos los estados</option>
                            <option value="pending">Pendiente</option>
                            <option value="confirmed">Confirmado</option>
                            <option value="processing">Procesando</option>
                            <option value="shipped">Enviado</option>
                            <option value="delivered">Entregado</option>
                            <option value="cancelled">Cancelado</option>
                        </select>
                    </div>
                </div>

                <div class="orders-list">
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="order-card" data-status="<?php echo e($order->status); ?>">
                        <div class="order-header">
                            <div class="order-number">
                                <h3>Pedido #<?php echo e($order->order_number); ?></h3>
                                <p class="order-date"><?php echo e($order->created_at->format('d/m/Y H:i')); ?></p>
                            </div>
                            <div class="order-status">
                                <span class="status-badge status-<?php echo e($order->status); ?>">
                                    <?php switch($order->status):
                                        case ('pending'): ?>
                                            <i class="fas fa-clock"></i> Pendiente
                                            <?php break; ?>
                                        <?php case ('confirmed'): ?>
                                            <i class="fas fa-check"></i> Confirmado
                                            <?php break; ?>
                                        <?php case ('processing'): ?>
                                            <i class="fas fa-cog"></i> Procesando
                                            <?php break; ?>
                                        <?php case ('shipped'): ?>
                                            <i class="fas fa-truck"></i> Enviado
                                            <?php break; ?>
                                        <?php case ('delivered'): ?>
                                            <i class="fas fa-check-circle"></i> Entregado
                                            <?php break; ?>
                                        <?php case ('cancelled'): ?>
                                            <i class="fas fa-times-circle"></i> Cancelado
                                            <?php break; ?>
                                        <?php default: ?>
                                            <?php echo e(ucfirst($order->status)); ?>

                                    <?php endswitch; ?>
                                </span>
                            </div>
                            <div class="order-total">
                                <strong>S/ <?php echo e(number_format($order->total, 2)); ?></strong>
                            </div>
                        </div>

                        <div class="order-details">
                            <div class="delivery-info">
                                <h4><i class="fas fa-map-marker-alt"></i> Información de Entrega</h4>
                                <p><strong>Destinatario:</strong> <?php echo e($order->full_name); ?></p>
                                <p><strong>Teléfono:</strong> <?php echo e($order->phone); ?></p>
                                <p><strong>Dirección:</strong> <?php echo e($order->address); ?></p>
                                <p><strong>Distrito:</strong> <?php echo e($order->district); ?></p>
                                <p><strong>Método de Pago:</strong> 
                                    <?php if($order->payment_method === 'tarjeta'): ?>
                                        Tarjeta de Crédito/Débito
                                    <?php elseif($order->payment_method === 'efectivo'): ?>
                                        Efectivo
                                    <?php else: ?>
                                        <?php echo e(ucfirst($order->payment_method)); ?>

                                    <?php endif; ?>
                                </p>
                            </div>

                            <div class="order-items">
                                <h4><i class="fas fa-box"></i> Productos (<?php echo e($order->orderItems->count()); ?> items)</h4>
                                <div class="items-list">
                                    <?php $__currentLoopData = $order->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="item-row">
                                        <?php if($item->product): ?>
                                        <img src="<?php echo e($item->product->image); ?>" alt="<?php echo e($item->product_name); ?>" class="item-image">
                                        <?php else: ?>
                                        <div class="item-image-placeholder">
                                            <i class="fas fa-image"></i>
                                        </div>
                                        <?php endif; ?>
                                        <div class="item-info">
                                            <h5><?php echo e($item->product_name); ?></h5>
                                            <p>Cantidad: <?php echo e($item->quantity); ?> | Precio: S/ <?php echo e(number_format($item->product_price, 2)); ?></p>
                                        </div>
                                        <div class="item-subtotal">
                                            <strong>S/ <?php echo e(number_format($item->subtotal, 2)); ?></strong>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>

                        <div class="order-actions">
                            <?php if($order->status === 'pending'): ?>
                            
                            <?php endif; ?>
                            <?php if($order->status === 'delivered'): ?>
                            <button class="btn btn-outline btn-sm">
                                <i class="fas fa-star"></i> Calificar Productos
                            </button>
                            <?php endif; ?>
                            <button class="btn btn-outline btn-sm" onclick="trackOrder('<?php echo e($order->order_number); ?>')">
                                <i class="fas fa-search"></i> Seguir Pedido
                            </button>
                           
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Paginación -->
                <div class="pagination-wrapper">
                    <?php echo e($orders->links()); ?>

                </div>
            <?php else: ?>
                <div class="empty-orders">
                    <div class="empty-icon">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <h3>No tienes pedidos aún</h3>
                    <p>¡Explora nuestros productos y realiza tu primera compra!</p>
                    <a href="<?php echo e(route('Producto.index')); ?>" class="btn btn-primary">
                        <i class="fas fa-shopping-cart"></i>
                        Ir a Comprar
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.orders-filters {
    background: white;
    padding: 1rem;
    border-radius: 10px;
    margin-bottom: 1rem;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

.filter-group {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.filter-select {
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: 14px;
}

.orders-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.order-card {
    background: white;
    border-radius: 12px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
    overflow: hidden;
    transition: transform 0.3s ease;
}

.order-card:hover {
    transform: translateY(-2px);
}

.order-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem;
    background: #f8f9fa;
    border-bottom: 1px solid #eee;
}

.order-number h3 {
    margin: 0 0 0.25rem 0;
    color: #333;
    font-size: 1.1rem;
}

.order-date {
    margin: 0;
    color: #666;
    font-size: 0.9rem;
}

.status-badge {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.status-pending {
    background: #fff3cd;
    color: #856404;
}

.status-confirmed {
    background: #d1ecf1;
    color: #0c5460;
}

.status-processing {
    background: #f3e5f5;
    color: #6a1b9a;
}

.status-shipped {
    background: #e3f2fd;
    color: #1976d2;
}

.status-delivered {
    background: #d4edda;
    color: #155724;
}

.status-cancelled {
    background: #f8d7da;
    color: #721c24;
}

.order-total {
    font-size: 1.2rem;
    color: #333;
}

.order-details {
    padding: 1.5rem;
    display: grid;
    grid-template-columns: 1fr 2fr;
    gap: 2rem;
}

.delivery-info h4,
.order-items h4 {
    color: #333;
    margin: 0 0 1rem 0;
    font-size: 1rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.delivery-info p {
    margin: 0.5rem 0;
    color: #555;
    font-size: 0.9rem;
}

.items-list {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.item-row {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 0.75rem;
    background: #f8f9fa;
    border-radius: 8px;
}

.item-image {
    width: 50px;
    height: 50px;
    object-fit: cover;
    border-radius: 6px;
}

.item-image-placeholder {
    width: 50px;
    height: 50px;
    background: #ddd;
    border-radius: 6px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #999;
}

.item-info {
    flex: 1;
}

.item-info h5 {
    margin: 0 0 0.25rem 0;
    color: #333;
    font-size: 0.95rem;
}

.item-info p {
    margin: 0;
    color: #666;
    font-size: 0.85rem;
}

.item-subtotal {
    font-weight: bold;
    color: #333;
}

.order-actions {
    padding: 1rem 1.5rem;
    background: #f8f9fa;
    border-top: 1px solid #eee;
    display: flex;
    gap: 0.75rem;
    flex-wrap: wrap;
}

.btn-sm {
    padding: 8px 16px;
    font-size: 0.85rem;
}

.btn-danger {
    background: #dc3545;
    color: white;
}

.btn-danger:hover {
    background: #c82333;
}

.empty-orders {
    text-align: center;
    padding: 4rem 2rem;
    background: white;
    border-radius: 12px;
    box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}

.empty-icon {
    font-size: 4rem;
    color: #ddd;
    margin-bottom: 1rem;
}

.empty-orders h3 {
    color: #333;
    margin: 0 0 1rem 0;
}

.empty-orders p {
    color: #666;
    margin: 0 0 2rem 0;
}

.pagination-wrapper {
    margin-top: 2rem;
    display: flex;
    justify-content: center;
}

@media (max-width: 768px) {
    .order-header {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .order-details {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .order-actions {
        justify-content: center;
    }
    
    .filter-group {
        flex-direction: column;
        align-items: flex-start;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
// Filtro por estado
document.getElementById('statusFilter').addEventListener('change', function() {
    const selectedStatus = this.value;
    const orderCards = document.querySelectorAll('.order-card');
    
    orderCards.forEach(card => {
        const cardStatus = card.getAttribute('data-status');
        if (selectedStatus === '' || cardStatus === selectedStatus) {
            card.style.display = 'block';
        } else {
            card.style.display = 'none';
        }
    });
});

function cancelOrder(orderId) {
    Swal.fire({
        title: '¿Cancelar Pedido?',
        text: 'Esta acción no se puede deshacer',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sí, cancelar',
        cancelButtonText: 'No cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Aquí iría la lógica para cancelar el pedido
            Swal.fire({
                title: 'Pedido Cancelado',
                text: 'Tu pedido ha sido cancelado exitosamente',
                icon: 'success',
                confirmButtonText: 'Entendido'
            }).then(() => {
                location.reload();
            });
        }
    });
}

function trackOrder(orderNumber) {
    Swal.fire({
        title: 'Seguimiento de Pedido',
        html: `
            <div style="text-align: left;">
                <p><strong>Pedido:</strong> #${orderNumber}</p>
                <div style="margin: 1rem 0;">
                    <div style="display: flex; align-items: center; gap: 0.5rem; margin: 0.5rem 0;">
                        <i class="fas fa-check-circle" style="color: #28a745;"></i>
                        <span>Pedido confirmado</span>
                    </div>
                    <div style="display: flex; align-items: center; gap: 0.5rem; margin: 0.5rem 0;">
                        <i class="fas fa-clock" style="color: #ffc107;"></i>
                        <span>En preparación</span>
                    </div>
                    <div style="display: flex; align-items: center; gap: 0.5rem; margin: 0.5rem 0; opacity: 0.5;">
                        <i class="fas fa-truck"></i>
                        <span>En camino</span>
                    </div>
                    <div style="display: flex; align-items: center; gap: 0.5rem; margin: 0.5rem 0; opacity: 0.5;">
                        <i class="fas fa-home"></i>
                        <span>Entregado</span>
                    </div>
                </div>
            </div>
        `,
        icon: 'info',
        confirmButtonText: 'Cerrar'
    });
}

function reorderItems(orderId) {
    Swal.fire({
        title: 'Volver a Comprar',
        text: '¿Quieres agregar todos los productos de este pedido a tu carrito?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#007bff',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Sí, agregar al carrito',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Aquí iría la lógica para agregar productos al carrito
            Swal.fire({
                title: 'Productos Agregados',
                text: 'Los productos han sido agregados a tu carrito',
                icon: 'success',
                confirmButtonText: 'Ir al Carrito'
            });
        }
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('include.template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp8.1\htdocs\electrodomesticos-app\resources\views/user/orders.blade.php ENDPATH**/ ?>